/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DataSourceException;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;

public class RenderingSettingsSaver
extends BatchCallTree {
    public static final int PASTE = 0;
    public static final int RESET = 1;
    public static final int SET_MIN_MAX = 2;
    public static final int CREATE = 3;
    public static final int SET_OWNER = 4;
    private Object result;
    private BatchCall loadCall;
    private SecurityContext ctx;

    private void checkRootType(Class type) {
        if (ImageData.class.equals((Object)type) || DatasetData.class.equals((Object)type) || PlateData.class.equals((Object)type) || ProjectData.class.equals((Object)type) || ScreenData.class.equals((Object)type) || PlateAcquisitionData.class.equals((Object)type)) {
            return;
        }
        throw new IllegalArgumentException("Type not supported.");
    }

    private BatchCall makeBatchCall(final long pixelsID, final Class rootType, final List<Long> ids, final int index) {
        return new BatchCall("Modify the rendering settings: "){

            @Override
            public void doCall() throws Exception {
                OmeroImageService rds = RenderingSettingsSaver.this.context.getImageService();
                switch (index) {
                    case 0: {
                        RenderingSettingsSaver.this.result = rds.pasteRenderingSettings(RenderingSettingsSaver.this.ctx, pixelsID, rootType, ids);
                        break;
                    }
                    case 1: {
                        RenderingSettingsSaver.this.result = rds.resetRenderingSettings(RenderingSettingsSaver.this.ctx, rootType, ids);
                        break;
                    }
                    case 2: {
                        RenderingSettingsSaver.this.result = rds.setMinMaxSettings(RenderingSettingsSaver.this.ctx, rootType, ids);
                        break;
                    }
                    case 4: {
                        RenderingSettingsSaver.this.result = rds.setOwnerRenderingSettings(RenderingSettingsSaver.this.ctx, rootType, ids);
                    }
                }
            }
        };
    }

    private BatchCall makeBatchCall(final Class rootType, final List<Long> ids, final RndProxyDef def, final ImageData refImage) {
        return new BatchCall("Modify the rendering settings: "){

            @Override
            public void doCall() throws Exception {
                long userId = MetadataViewerAgent.getUserDetails().getId();
                OmeroImageService rds = RenderingSettingsSaver.this.context.getImageService();
                RndProxyDef original = null;
                Map<DataObject, Collection<RndProxyDef>> tmp = rds.getRenderingSettings(RenderingSettingsSaver.this.ctx, refImage.getDefaultPixels().getId(), userId);
                for (Map.Entry<DataObject, Collection<RndProxyDef>> e : tmp.entrySet()) {
                    ExperimenterData exp;
                    if (!(e.getKey() instanceof ExperimenterData) || (exp = (ExperimenterData)e.getKey()).getId() != userId) continue;
                    original = e.getValue().iterator().next();
                    break;
                }
                MetadataViewer viewer = MetadataViewerFactory.getViewer(refImage);
                viewer.reloadRenderingControl();
                Renderer rnd = null;
                if (viewer != null && (rnd = viewer.getRenderer()) != null) {
                    try {
                        rnd.resetSettings(def, true);
                        rnd.saveCurrentSettings();
                    }
                    catch (Throwable e) {
                        throw new DataSourceException("Could not save pending rendering settings for image id " + refImage.getId());
                    }
                }
                Map map = rds.pasteRenderingSettings(RenderingSettingsSaver.this.ctx, refImage.getDefaultPixels().getId(), rootType, ids);
                RenderingSettingsSaver.this.result = map;
                boolean refImagePartOfSaved = ((List)map.get(Boolean.TRUE)).contains(refImage.getId());
                if (rnd != null && original != null && !refImagePartOfSaved) {
                    rnd.resetSettings(original, true);
                    rnd.saveCurrentSettings();
                }
            }
        };
    }

    private BatchCall makeBatchCall(final long pixelsID, final TimeRefObject ref, final int index) {
        return new BatchCall("Modify the rendering settings: "){

            @Override
            public void doCall() throws Exception {
                long userID = ((ExperimenterData)RenderingSettingsSaver.this.context.lookup("/current_user/details")).getId();
                OmeroDataService os = RenderingSettingsSaver.this.context.getDataService();
                Collection l = os.getImagesPeriod(RenderingSettingsSaver.this.ctx, ref.getStartTime(), ref.getEndTime(), userID, true);
                if (l != null) {
                    Iterator i = l.iterator();
                    ArrayList<Long> ids = new ArrayList<Long>(l.size());
                    while (i.hasNext()) {
                        DataObject element = (DataObject)i.next();
                        ids.add(element.getId());
                    }
                    OmeroImageService rds = RenderingSettingsSaver.this.context.getImageService();
                    switch (index) {
                        case 0: {
                            RenderingSettingsSaver.this.result = rds.pasteRenderingSettings(RenderingSettingsSaver.this.ctx, pixelsID, ImageData.class, ids);
                            break;
                        }
                        case 1: {
                            RenderingSettingsSaver.this.result = rds.resetRenderingSettings(RenderingSettingsSaver.this.ctx, ImageData.class, ids);
                            break;
                        }
                        case 2: {
                            RenderingSettingsSaver.this.result = rds.setMinMaxSettings(RenderingSettingsSaver.this.ctx, ImageData.class, ids);
                            break;
                        }
                        case 4: {
                            RenderingSettingsSaver.this.result = rds.setOwnerRenderingSettings(RenderingSettingsSaver.this.ctx, ImageData.class, ids);
                        }
                    }
                }
            }
        };
    }

    private BatchCall makeCreateBatchCall(final long pixelsID, final RndProxyDef rndToCopy, final List<Integer> indexes) {
        return new BatchCall("Paste the rendering settings: "){

            @Override
            public void doCall() throws Exception {
                OmeroImageService os = RenderingSettingsSaver.this.context.getImageService();
                RenderingSettingsSaver.this.result = os.createRenderingSettings(RenderingSettingsSaver.this.ctx, pixelsID, rndToCopy, indexes);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public RenderingSettingsSaver(SecurityContext ctx, Class rootNodeType, List<Long> ids, int index) {
        this.checkRootType(rootNodeType);
        if (CollectionUtils.isEmpty(ids)) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        this.ctx = ctx;
        this.loadCall = this.makeBatchCall(-1L, rootNodeType, ids, index);
    }

    public RenderingSettingsSaver(SecurityContext ctx, long pixelsID, Class rootNodeType, List<Long> ids) {
        this.checkRootType(rootNodeType);
        if (CollectionUtils.isEmpty(ids)) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.ctx = ctx;
        this.loadCall = this.makeBatchCall(pixelsID, rootNodeType, ids, 0);
    }

    public RenderingSettingsSaver(SecurityContext ctx, Class rootNodeType, List<Long> ids, RndProxyDef def, ImageData refImage) {
        this.checkRootType(rootNodeType);
        if (CollectionUtils.isEmpty(ids)) {
            throw new IllegalArgumentException("No nodes specified.");
        }
        if (refImage == null) {
            throw new IllegalArgumentException("No reference image provided.");
        }
        this.ctx = ctx;
        this.loadCall = this.makeBatchCall(rootNodeType, ids, def, refImage);
    }

    public RenderingSettingsSaver(SecurityContext ctx, long pixelsID, TimeRefObject ref) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        if (ref == null) {
            throw new IllegalArgumentException("Period not valid.");
        }
        this.ctx = ctx;
        this.loadCall = this.makeBatchCall(pixelsID, ref, 0);
    }

    public RenderingSettingsSaver(SecurityContext ctx, TimeRefObject ref, int index) {
        if (ref == null) {
            throw new IllegalArgumentException("Period not valid.");
        }
        this.ctx = ctx;
        this.loadCall = this.makeBatchCall(-1L, ref, index);
    }

    public RenderingSettingsSaver(SecurityContext ctx, long pixelsID, RndProxyDef rndToCopy, List<Integer> indexes) {
        if (pixelsID < 0L) {
            throw new IllegalArgumentException("Pixels ID not valid.");
        }
        this.ctx = ctx;
        this.loadCall = this.makeCreateBatchCall(pixelsID, rndToCopy, indexes);
    }
}

