/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.ProcessCallback;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class DataObjectRemover
extends UserNotifierLoader {
    private CallHandle handle;
    private List<ProcessCallback> callBacks;
    private Map<SecurityContext, Collection<DeletableObject>> objects;
    private int number;

    private SecurityContext getKey(Map<SecurityContext, Collection<DeletableObject>> map, long id) {
        for (SecurityContext ctx : map.keySet()) {
            if (ctx.getGroupID() != id) continue;
            return ctx;
        }
        return null;
    }

    @Override
    protected void onException(String message, Throwable ex) {
        if (this.activity != null) {
            this.activity.notifyError("Unable to delete the object", message, ex);
        }
    }

    public DataObjectRemover(UserNotifier viewer, Registry registry, List<DeletableObject> objects, ActivityComponent activity) {
        super(viewer, registry, null, activity);
        if (objects == null || objects.size() == 0) {
            throw new IllegalArgumentException("No Objects to delete.");
        }
        this.callBacks = new ArrayList<ProcessCallback>();
        HashMap<SecurityContext, Collection<DeletableObject>> map = new HashMap<SecurityContext, Collection<DeletableObject>>();
        for (DeletableObject o : objects) {
            DataObject ho = o.getObjectToDelete();
            SecurityContext ctx = o.getSecurityContext();
            if (ctx == null) {
                long groupId = ho.getGroupId();
                ctx = this.getKey(map, groupId);
                if (ctx == null) {
                    ctx = new SecurityContext(groupId);
                    map.put(ctx, new ArrayList());
                }
            } else if (this.getKey(map, ctx.getGroupID()) == null) {
                map.put(ctx, new ArrayList());
            }
            Collection l = (Collection)map.get(ctx);
            l.add(o);
        }
        this.objects = map;
    }

    @Override
    public void load() {
        this.handle = this.dmView.delete(this.objects, this);
    }

    @Override
    public void cancel() {
        try {
            for (ProcessCallback callback : this.callBacks) {
                if (callback == null) continue;
                callback.cancel();
            }
            if (this.activity != null) {
                this.activity.onActivityCancelled();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Object o = fe.getPartialResult();
        if (o != null) {
            if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                if (!b.booleanValue()) {
                    this.onException("", null);
                }
            } else {
                ProcessCallback callBack = (ProcessCallback)o;
                callBack.setAdapter(this);
                this.callBacks.add(callBack);
                ++this.number;
                if (this.number == this.objects.size() && this.activity != null) {
                    this.activity.onCallBackSet();
                }
            }
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void handleResult(Object result) {
        if (this.activity != null) {
            if (result instanceof Boolean) {
                boolean b = (Boolean)result;
                if (b) {
                    this.activity.endActivity("Delete completed");
                } else {
                    this.onException("No result returned.", null);
                }
            } else {
                this.activity.endActivity(result);
            }
        }
    }
}

