/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import omero.cmd.GraphException;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.ProcessReport;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.DataObjectRemover;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class DeleteActivity
extends ActivityComponent {
    public static final String DELETE_COMPLETE = "Delete completed";
    private static final String DESCRIPTION_START = "Deleting ";
    private static final String DEFAULT_TYPE = "Object";
    private static final String DESCRIPTION_END = " deleted";
    private static final String DESCRIPTION_ERROR = "Unable to delete";
    private static final String DESCRIPTION_CANCEL = "Deletion cancelled";
    private DeleteActivityParam parameters;

    private String getDeleteType() {
        String value;
        List<DeletableObject> objects = this.parameters.getObjects();
        DeletableObject o = objects.get(0);
        String s = "";
        if (objects.size() > 1) {
            s = "s";
        }
        if ((value = o.getType()) == null || value.trim().length() == 0) {
            return DEFAULT_TYPE + s;
        }
        return value + s;
    }

    private String createMessage() {
        List<DeletableObject> objects = this.parameters.getObjects();
        if (objects.size() == 1) {
            return objects.get(0).getMessage();
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<DeletableObject> i = objects.iterator();
        int index = 0;
        int n = 1;
        while (i.hasNext()) {
            DeletableObject o = i.next();
            if (index == n) break;
            buffer.append(o.getMessage());
            if (index < n - 1) {
                buffer.append(", ");
            }
            ++index;
        }
        if (objects.size() > n) {
            buffer.append(" and " + (objects.size() - n) + " more");
        }
        return buffer.toString();
    }

    public DeleteActivity(UserNotifier viewer, Registry registry, DeleteActivityParam parameters) {
        super(viewer, registry, null);
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        this.initialize(DESCRIPTION_START + this.getDeleteType(), parameters.getIcon());
        this.messageLabel.setText(this.createMessage());
    }

    public List<Object> getNodes() {
        return this.parameters.getNodes();
    }

    public long getImageID() {
        return this.parameters.getImageID();
    }

    @Override
    protected UserNotifierLoader createLoader() {
        List<DeletableObject> objects = this.parameters.getObjects();
        this.loader = new DataObjectRemover(this.viewer, this.registry, objects, (ActivityComponent)this);
        return this.loader;
    }

    @Override
    protected void notifyActivityEnd() {
        if (this.result instanceof ProcessReport) {
            this.type.setText(DESCRIPTION_ERROR);
            GraphException ex = ((ProcessReport)this.result).getGraphException();
            if (ex != null) {
                this.messageLabel.setText(this.messageLabel.getText() + " - " + ex.message);
            }
            this.notifyActivityError();
        } else {
            this.type.setText(DESCRIPTION_END);
            Icon icon = this.parameters.getIcon();
            if (icon != null) {
                this.iconLabel.setIcon(icon);
            }
        }
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
        Icon icon = this.parameters.getFailureIcon();
        if (icon != null) {
            this.iconLabel.setIcon(icon);
        }
    }
}

