/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.concur;

import org.openmicroscopy.shoola.util.concur.ControlFlowObserver;
import org.openmicroscopy.shoola.util.concur.Semaphore;

public class ObjectTransfer {
    private Object objInTransit = null;
    private final Semaphore empty = new Semaphore(1);
    private final Semaphore full = new Semaphore(0);
    private final Semaphore objTransferred = new Semaphore(0);
    static final int TRANSITION_TO_EMPTY = 1;
    static final int TRANSITION_TO_FULL = 2;
    private ControlFlowObserver flowObs;

    private void waitForObjectToBeTransferred() throws InterruptedException {
        InterruptedException exc = null;
        while (true) {
            try {
                this.objTransferred.down();
            }
            catch (InterruptedException ie) {
                exc = ie;
                continue;
            }
            break;
        }
        if (exc != null) {
            throw exc;
        }
    }

    private boolean doHandOff(Object x, long timeout) throws InterruptedException {
        if (x == null) {
            throw new NullPointerException("No object.");
        }
        if (timeout == -1L) {
            this.empty.down();
        } else if (!this.empty.down(timeout)) {
            return false;
        }
        if (this.flowObs != null) {
            this.flowObs.update(2);
        }
        this.objInTransit = x;
        this.full.up();
        this.waitForObjectToBeTransferred();
        return true;
    }

    private Object doCollect(long timeout) throws InterruptedException {
        if (timeout == -1L) {
            this.full.down();
        } else if (!this.full.down(timeout)) {
            return null;
        }
        if (this.flowObs != null) {
            this.flowObs.update(1);
        }
        Object x = this.objInTransit;
        this.objInTransit = null;
        this.empty.up();
        this.objTransferred.up();
        return x;
    }

    public boolean handOff(Object x, long timeout) throws InterruptedException {
        if (timeout <= 0L) {
            timeout = 0L;
        }
        return this.doHandOff(x, timeout);
    }

    public void handOff(Object x) throws InterruptedException {
        this.doHandOff(x, -1L);
    }

    public Object collect() throws InterruptedException {
        return this.doCollect(-1L);
    }

    public Object collect(long timeout) throws InterruptedException {
        if (timeout <= 0L) {
            timeout = 0L;
        }
        return this.doCollect(timeout);
    }

    void register(ControlFlowObserver obs) {
        this.flowObs = obs;
    }

    Object getObjInTransit() {
        return this.objInTransit;
    }
}

