/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.table;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.openmicroscopy.shoola.util.ui.table.Reorderable;

public class TableRowTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -2692838348100758280L;
    private final DataFlavor localObjectFlavor = new ActivationDataFlavor(new int[0].getClass(), "Integer Row Indices");
    private JTable table = null;

    public TableRowTransferHandler(JTable table) {
        this.table = table;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new DataHandler((Object)this.table.getSelectedRows(), this.localObjectFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        boolean b = info.getComponent() == this.table && info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
        this.table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return b;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        if (!info.isDrop()) {
            return false;
        }
        JTable target = (JTable)info.getComponent();
        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
        int index = dl.getRow();
        int max = this.table.getModel().getRowCount();
        if (index < 0 || index > max) {
            index = max;
        }
        target.setCursor(Cursor.getPredefinedCursor(0));
        try {
            int[] rowFrom = (int[])info.getTransferable().getTransferData(this.localObjectFlavor);
            int newIndex = ((Reorderable)((Object)this.table.getModel())).reorder(rowFrom, index);
            target.getSelectionModel().addSelectionInterval(newIndex, newIndex + rowFrom.length - 1);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int act) {
        if (act == 2 || act == 0) {
            this.table.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

