/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo.path;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class FsFile
implements Comparable<FsFile> {
    public static char separatorChar = (char)47;
    public static FsFile emptyPath = new FsFile(new String[0]);
    private final List<String> components;
    private final String path;

    private static List<String> splitComponents(String path, char separator) {
        String[] splitBySeparator = path.split("\\" + separator);
        ArrayList<String> components = new ArrayList<String>(splitBySeparator.length);
        for (String component : splitBySeparator) {
            if ("".equals(component)) continue;
            components.add(component);
        }
        return components;
    }

    public FsFile(Collection<String> components) {
        if (components == null || components.isEmpty()) {
            this.components = Collections.emptyList();
            this.path = "";
        } else {
            this.components = Collections.unmodifiableList(new ArrayList<String>(components));
            StringBuilder pathBuilder = new StringBuilder();
            for (String component : components) {
                if (StringUtils.isEmpty((String)component)) {
                    throw new IllegalArgumentException("each path component must have content");
                }
                if (component.indexOf(separatorChar) != -1) {
                    throw new IllegalArgumentException("path components may not contain a path separator");
                }
                pathBuilder.append(component);
                pathBuilder.append(separatorChar);
            }
            pathBuilder.setLength(pathBuilder.length() - 1);
            this.path = pathBuilder.toString();
        }
    }

    public FsFile(String ... components) {
        this(Arrays.asList(components));
    }

    private static <X> List<X> tailOf(List<X> list, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count must be positive");
        }
        int listSize = list.size();
        int startIndex = listSize > count ? listSize - count : 0;
        return list.subList(startIndex, listSize);
    }

    public FsFile(FsFile file, int maxComponentCount) {
        this(FsFile.tailOf(file.components, maxComponentCount));
    }

    public FsFile(File file) {
        this(FsFile.splitComponents(file.getAbsolutePath(), File.separatorChar));
    }

    public FsFile(Path path) {
        this(path.toFile());
    }

    public FsFile(String path) {
        this(FsFile.splitComponents(path, separatorChar));
    }

    public FsFile transform(Function<String, String> componentTransformer) {
        return new FsFile(this.components.stream().map(componentTransformer).collect(Collectors.toList()));
    }

    public FsFile getPathFrom(FsFile file) {
        Iterator<String> container = file.components.iterator();
        Iterator<String> contained = this.components.iterator();
        do {
            if (!container.hasNext()) {
                ArrayList<String> childComponents = new ArrayList<String>();
                while (contained.hasNext()) {
                    childComponents.add(contained.next());
                }
                return new FsFile(childComponents);
            }
            if (contained.hasNext()) continue;
            return null;
        } while (container.next().equals(contained.next()));
        return null;
    }

    public static FsFile concatenate(FsFile ... files) {
        int size = 0;
        for (FsFile file : files) {
            size += file.components.size();
        }
        ArrayList<String> components = new ArrayList<String>(size);
        for (FsFile file : files) {
            components.addAll(file.components);
        }
        return new FsFile(components);
    }

    public List<String> getComponents() {
        return this.components;
    }

    public File toFile(File file) {
        for (String component : this.components) {
            file = new File(file, component);
        }
        return file;
    }

    public Path toPath(Path path) {
        if (path == null) {
            path = Paths.get("", new String[0]);
        }
        for (String component : this.components) {
            path = path.resolve(component);
        }
        return path;
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FsFile)) {
            return false;
        }
        return this.path.equals(((FsFile)object).path);
    }

    public int hashCode() {
        return this.path.hashCode() * 97;
    }

    @Override
    public int compareTo(FsFile other) {
        return this.path.compareTo(other.path);
    }
}

