/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.LinkedList;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ReversedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandleMulticaster {
    LinkedList<Handle> handles;
    CompositeEdit edit;

    public HandleMulticaster(Handle handle) {
        this.handles = new LinkedList();
        this.handles.add(handle);
    }

    public HandleMulticaster(Collection<Handle> handles) {
        this.handles = new LinkedList<Handle>(handles);
    }

    public void draw(Graphics2D g) {
        for (Handle h : this.handles) {
            h.draw(g);
        }
    }

    public void keyPressed(KeyEvent e) {
        for (Handle h : this.handles) {
            h.keyPressed(e);
        }
    }

    public void keyReleased(KeyEvent e) {
        for (Handle h : this.handles) {
            h.keyReleased(e);
        }
    }

    public void keyTyped(KeyEvent e) {
        for (Handle h : this.handles) {
            h.keyTyped(e);
        }
    }

    public void trackEnd(Point current, Point anchor, int modifiersEx, DrawingView view) {
        for (Handle h : new ReversedList<Handle>(this.handles)) {
            h.trackEnd(current, anchor, modifiersEx);
        }
        view.getDrawing().fireUndoableEditHappened(this.edit);
    }

    public void trackStart(Point anchor, int modifiersEx, DrawingView view) {
        this.edit = new CompositeEdit();
        view.getDrawing().fireUndoableEditHappened(this.edit);
        for (Handle h : this.handles) {
            h.trackStart(anchor, modifiersEx);
        }
    }

    public void trackDoubleClick(Point p, int modifiersEx, DrawingView view) {
        for (Handle h : this.handles) {
            h.trackDoubleClick(p, modifiersEx);
        }
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx, DrawingView view) {
        for (Handle h : this.handles) {
            h.trackStep(anchor, lead, modifiersEx);
        }
    }
}

