/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ome.model.units.Unit;
import ome.units.quantity.Length;
import ome.xml.model.Arc;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.primitives.PercentFraction;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class ArcConverter
extends DataConverter {
    @Override
    public JComponent getLabel(String name, int index, List<ActionListener> listeners) {
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new BoxLayout(labelPane, 0));
        labelPane.setBorder(new EmptyBorder(5, 2, 2, 2));
        labelPane.setOpaque(false);
        JLabel label = new JLabel(name);
        label.setBorder(new EmptyBorder(0, 0, 0, 10));
        labelPane.add(label);
        IconManager icons = IconManager.getInstance();
        JButton applyBtn = new JButton(icons.getIcon(73));
        applyBtn.setToolTipText("Apply table selection");
        applyBtn.setAlignmentX(1.0f);
        labelPane.add(applyBtn);
        return labelPane;
    }

    public LinkedHashMap<String, TagData> convertData(Arc l, LightSourceSettings settings) {
        this.tagMap = new LinkedHashMap();
        if (l != null) {
            try {
                this.tagMap.put("ID", this.convertID(l.getID(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("ID", this.convertID(null, true));
            }
            try {
                this.tagMap.put("Manufacturer", this.convertManufact(l.getManufacturer(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            }
            try {
                this.tagMap.put("Model", this.convertModel(l.getModel(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Model", this.convertModel(null, true));
            }
            try {
                this.tagMap.put("A_Type", this.convertType((Enumeration)l.getType(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("A_Type", this.convertType(null, true));
            }
        } else {
            this.tagMap.put("ID", this.convertID(null, true));
            this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            this.tagMap.put("Model", this.convertModel(null, true));
            this.tagMap.put("Description", this.convertType(null, true));
        }
        if (settings != null) {
            try {
                this.tagMap.put("User::Wavelength", this.convertWavelengthSett(settings.getWavelength(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Wavelength", this.convertWavelengthSett(null, true));
            }
            try {
                this.tagMap.put("User::Attenuation", this.convertAttenuation(settings.getAttenuation(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Attenuation", this.convertAttenuation(null, true));
            }
        } else {
            this.tagMap.put("User::Wavelength", this.convertWavelengthSett(null, true));
            this.tagMap.put("User::Attenuation", this.convertAttenuation(null, true));
        }
        return this.tagMap;
    }

    public TagData convertID(String value, boolean prop) {
        return new TagData("OME:Arc", "ID", value, prop, "TextField");
    }

    public TagData convertManufact(String value, boolean prop) {
        return new TagData("OME:Arc", "Manufacturer", value, prop, "TextField");
    }

    public TagData convertModel(String value, boolean prop) {
        return new TagData("OME:Arc", "Model", value, prop, "TextField");
    }

    public TagData convertType(Enumeration value, boolean prop) {
        String val = value != null ? ((ArcType)value).getValue() : "";
        return new TagData("OME:Arc", "A_Type", val, prop, "ComboBox", OMEValueConverter.getNames(ArcType.class));
    }

    public TagData convertWavelengthSett(Length value, boolean prop) {
        ome.model.units.Length val = null;
        if (value != null) {
            val = new ome.model.units.Length(value);
        }
        TagData t = new TagData("OME:Arc", "User::Wavelength", (Unit)val, ome.model.units.Length.class, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerPosFloat(t, "Invalid input. Use float>0!"));
        return t;
    }

    public TagData convertAttenuation(PercentFraction value, boolean prop) {
        String val = value != null ? String.valueOf(value.getNumberValue()) : "";
        TagData t = new TagData("OME:Arc", "User::Attenuation", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerPercentFraction(t, "Invalid input. Use percent fraction as dezimal between 0.0 and 1.0!"));
        return t;
    }
}

