/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class TEXTFilter
extends CustomizedFileFilter {
    public static final String TEXT = "txt";
    public static final String[] extensions = new String[1];
    private static final String description;

    @Override
    public String getMIMEType() {
        return "text/plain";
    }

    @Override
    public String getExtension() {
        return TEXT;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    @Override
    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        TEXTFilter.extensions[0] = TEXT;
        StringBuffer s = new StringBuffer();
        s.append("Text Format (");
        for (int i = 0; i < extensions.length; ++i) {
            s.append("*." + extensions[i]);
            if (i >= extensions.length - 1) continue;
            s.append(", ");
        }
        s.append(")");
        description = s.toString();
    }
}

