/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.image.io;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmicroscopy.shoola.util.image.io.Encoder;
import org.openmicroscopy.shoola.util.image.io.EncoderException;
import org.openmicroscopy.shoola.util.image.io.TIFFEncoderCst;

public class TIFFEncoder
extends Encoder {
    private int bitsPerSample;
    private int samplesPerPixel;
    private int nEntries;
    private int photoInterp;
    private int ifdSize;
    private int imageSize;

    private void writeBitsPerPixel() throws IOException {
        this.output.writeShort(8);
        this.output.writeShort(8);
        this.output.writeShort(8);
    }

    private void writeIFD() throws IOException {
        int tagDataOffset = 8 + this.ifdSize;
        this.output.writeShort(this.nEntries);
        this.writeEntry(254, 4, 1, 0);
        this.writeEntry(256, 3, 1, this.imageWidth);
        this.writeEntry(257, 3, 1, this.imageHeight);
        if (this.colorType == 5) {
            this.writeEntry(258, 3, 3, tagDataOffset);
            tagDataOffset += 6;
        } else {
            this.writeEntry(258, 3, 1, this.bitsPerSample);
        }
        this.writeEntry(262, 3, 1, this.photoInterp);
        this.writeEntry(273, 4, 1, 768);
        this.writeEntry(277, 3, 1, this.samplesPerPixel);
        this.writeEntry(278, 3, 1, this.imageHeight);
        this.writeEntry(279, 4, 1, this.imageSize);
        this.writeEntry(282, 5, 1, tagDataOffset);
        this.writeEntry(283, 5, 1, tagDataOffset + 8);
        int unit = 2;
        this.writeEntry(296, 3, 1, unit);
        this.output.writeInt(0);
    }

    private void writeEntry(int tag, int fieldType, int count, int value) throws IOException {
        this.output.writeShort(tag);
        this.output.writeShort(fieldType);
        this.output.writeInt(count);
        if (count == 1 && fieldType == 3) {
            value <<= 16;
        }
        this.output.writeInt(value);
    }

    private void writeRGBPixels() throws IOException {
        DataBuffer db = this.image.getRaster().getDataBuffer();
        if (db instanceof DataBufferByte) {
            this.writeRGBDataBufferByte((DataBufferByte)db);
        } else if (db instanceof DataBufferInt) {
            this.writeRGBDataBufferInt((DataBufferInt)db);
        }
    }

    private void writeRGBDataBufferInt(DataBufferInt dbi) throws IOException {
        int xres = this.image.getWidth();
        int yres = this.image.getHeight();
        int[] pixels = dbi.getData();
        byte[] bank = new byte[pixels.length];
        for (int iy = 0; iy < yres; ++iy) {
            for (int ix = 0; ix < xres; ++ix) {
                int off = iy * xres + ix;
                int pixel = pixels[off];
                int r = pixel >> 16 & 0xFF;
                int g = pixel >> 8 & 0xFF;
                int b = pixel & 0xFF;
                pixel = 0xFF000000 | r << 16 | g << 8 | b;
                bank[off] = (byte)pixel;
            }
        }
        this.output.write(bank, 0, bank.length);
    }

    private void writeRGBDataBufferByte(DataBufferByte bufferByte) throws IOException {
        int size = this.imageWidth * this.imageHeight * 3;
        int count = this.imageWidth * 24;
        byte[] buffer = new byte[count];
        byte[] red = bufferByte.getData(0);
        byte[] green = bufferByte.getData(1);
        byte[] blue = bufferByte.getData(2);
        for (int bytesWritten = 0; bytesWritten < size; bytesWritten += count) {
            if (bytesWritten + count > size) {
                count = size - bytesWritten;
            }
            int j = bytesWritten / 3;
            for (int i = 0; i < count; i += 3) {
                buffer[i] = red[j];
                buffer[i + 1] = green[j];
                buffer[i + 2] = blue[j];
                ++j;
            }
            this.output.write(buffer, 0, count);
        }
        this.writeColorMap(red, green, blue);
    }

    private void writeColorMap(byte[] red, byte[] green, byte[] blue) throws IOException {
        byte[] colorTable16 = new byte[1536];
        int j = 0;
        int max = 251;
        for (int i = 0; i < max; ++i) {
            colorTable16[j] = red[i];
            colorTable16[512 + j] = green[i];
            colorTable16[1024 + j] = blue[i];
            j += 2;
        }
        this.output.write(colorTable16);
    }

    private void writeScale() throws IOException {
        double xscale = 1.0 / (double)this.imageWidth;
        double yscale = 1.0 / (double)this.imageHeight;
        double scale = 1000000.0;
        if (xscale > 1000.0) {
            scale = 1000.0;
        }
        this.output.writeInt((int)(xscale * scale));
        this.output.writeInt((int)scale);
        this.output.writeInt((int)(yscale * scale));
        this.output.writeInt((int)scale);
    }

    public TIFFEncoder(BufferedImage image, DataOutputStream output) {
        super(image, output);
    }

    @Override
    public void write() throws EncoderException {
        try {
            this.output.write(TIFFEncoderCst.header);
            this.writeIFD();
            int bpsSize = 0;
            if (this.colorType == 5) {
                this.writeBitsPerPixel();
                bpsSize = 6;
            }
            int scaleSize = 16;
            this.writeScale();
            int size = 768 - (8 + this.ifdSize + bpsSize + scaleSize);
            this.output.write(new byte[size]);
            this.writeRGBPixels();
        }
        catch (IOException e) {
            throw new EncoderException("Cannot encode the image.", e);
        }
    }

    @Override
    protected void init() {
        this.bitsPerSample = 8;
        this.samplesPerPixel = 1;
        this.nEntries = 12;
        this.photoInterp = 1;
        this.ifdSize = 6 + this.nEntries * 12;
        int bytesPerPixel = 1;
        if (this.colorType == 5) {
            this.photoInterp = 2;
            this.samplesPerPixel = 3;
            bytesPerPixel = 3;
        }
        this.imageSize = this.imageWidth * this.imageHeight * bytesPerPixel;
    }
}

