/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import org.openmicroscopy.shoola.util.ui.ColouredButtonUI;

public class ColouredButton
extends JButton {
    private ColouredButtonUI colourButtonUI;
    private Color color;

    private void setButtonColour(Color color) {
        this.colourButtonUI.setColor(color);
    }

    private void setButtonImage(BufferedImage img) {
        this.colourButtonUI.setImage(img);
    }

    public ColouredButton(String text, Color color) {
        this.setModel(new DefaultButtonModel());
        this.init(text, null);
        this.colourButtonUI = new ColouredButtonUI(this, color);
        this.setUI(this.colourButtonUI);
        this.setRolloverEnabled(false);
        this.setBorder(BorderFactory.createBevelBorder(3));
        this.setBorderPainted(true);
        this.color = color;
        this.setButtonColour(color);
    }

    public ColouredButton(String text, BufferedImage img) {
        this.color = Color.GRAY;
        this.setModel(new DefaultButtonModel());
        this.init(text, null);
        this.colourButtonUI = new ColouredButtonUI(this, this.color);
        this.setUI(this.colourButtonUI);
        this.setRolloverEnabled(false);
        this.setBorder(BorderFactory.createBevelBorder(3));
        this.setBorderPainted(true);
        this.setButtonImage(img);
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        this.setColor(this.color);
    }

    public void setGrayedOut(boolean greyedOut) {
        if (greyedOut) {
            this.setButtonColour(Color.LIGHT_GRAY);
        } else {
            this.setButtonColour(this.color);
        }
        this.colourButtonUI.setGrayedOut(greyedOut);
        this.repaint();
    }

    public void setColor(Color color) {
        this.color = color;
        this.setButtonColour(color);
        this.repaint();
    }

    public void setImage(BufferedImage img) {
        this.setButtonImage(img);
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setFontIndex(int index) {
        this.setFont(this.getFont().deriveFont(index));
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

