/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.util.List;
import ome.util.PixelData;
import omeis.providers.re.Optimizations;
import omeis.providers.re.RGBAIntBuffer;
import omeis.providers.re.RGBBuffer;
import omeis.providers.re.RGBIntBuffer;
import omeis.providers.re.RenderingTask;
import omeis.providers.re.codomain.CodomainChain;
import omeis.providers.re.data.Plane2D;
import omeis.providers.re.lut.LutReader;
import omeis.providers.re.quantum.BinaryMaskQuantizer;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RenderHSBRegionTask
implements RenderingTask {
    private static Logger log = LoggerFactory.getLogger(RenderHSBRegionTask.class);
    private RGBBuffer dataBuffer;
    private List<Plane2D> wData;
    private List<QuantumStrategy> strategies;
    private List<CodomainChain> chains;
    private List<int[]> colors;
    private int x1Start;
    private int x1End;
    private int x2Start;
    private int x2End;
    private Optimizations optimizations;
    private List<LutReader> readers;

    RenderHSBRegionTask(RGBBuffer dataBuffer, List<Plane2D> wData, List<QuantumStrategy> strategies, List<CodomainChain> chains, List<int[]> colors, Optimizations optimizations, int x1Start, int x1End, int x2Start, int x2End, List<LutReader> readers) {
        this.dataBuffer = dataBuffer;
        this.wData = wData;
        this.strategies = strategies;
        this.chains = chains;
        this.colors = colors;
        this.optimizations = optimizations;
        this.x1Start = x1Start;
        this.x1End = x1End;
        this.x2Start = x2Start;
        this.x2End = x2End;
        this.readers = readers;
    }

    @Override
    public Object call() throws QuantizationException {
        log.debug("Buffer type: " + this.dataBuffer);
        if (this.dataBuffer instanceof RGBIntBuffer) {
            this.renderPackedInt();
        } else if (this.dataBuffer instanceof RGBAIntBuffer) {
            this.renderPackedIntAsRGBA();
        } else {
            this.renderBanded();
        }
        return null;
    }

    private void renderBanded() throws QuantizationException {
        int width = this.x1End - this.x1Start;
        int i = 0;
        byte[] r = this.dataBuffer.getRedBand();
        byte[] g = this.dataBuffer.getGreenBand();
        byte[] b = this.dataBuffer.getBlueBand();
        for (Plane2D plane : this.wData) {
            int[] color = this.colors.get(i);
            LutReader reader = this.readers.get(i);
            CodomainChain cc = this.chains.get(i);
            boolean hasMap = cc.hasMapContext();
            QuantumStrategy qs = this.strategies.get(i);
            int rColor = color[0];
            int gColor = color[1];
            int bColor = color[2];
            float alpha = Float.valueOf(color[3]).floatValue() / 65025.0f;
            for (int x2 = this.x2Start; x2 < this.x2End; ++x2) {
                for (int x1 = this.x1Start; x1 < this.x1End; ++x1) {
                    int pix = width * x2 + x1;
                    int discreteValue = qs.quantize(plane.getPixelValue(x1, x2));
                    if (hasMap) {
                        discreteValue = cc.transform(discreteValue);
                    }
                    if (reader != null) {
                        int r1 = (r[pix] & 0xFF0000) >> 16;
                        int r2 = reader.getRed(discreteValue) & 0xFF;
                        int g1 = (g[pix] & 0xFF00) >> 8;
                        int g2 = reader.getGreen(discreteValue) & 0xFF;
                        int b1 = b[pix] & 0xFF;
                        int b2 = reader.getBlue(discreteValue) & 0xFF;
                        r[pix] = (byte)(r1 + r2);
                        g[pix] = (byte)(g1 + g2);
                        b[pix] = (byte)(b1 + b2);
                        continue;
                    }
                    float v = (float)discreteValue * alpha;
                    int rValue = (int)((float)rColor * v) + r[pix];
                    int gValue = (int)((float)gColor * v) + g[pix];
                    int bValue = (int)((float)bColor * v) + b[pix];
                    if (rValue > 255) {
                        rValue = 255;
                    }
                    if (gValue > 255) {
                        gValue = 255;
                    }
                    if (bValue > 255) {
                        bValue = 255;
                    }
                    r[pix] = (byte)(rValue & 0xFF);
                    g[pix] = (byte)(gValue & 0xFF);
                    b[pix] = (byte)(bValue & 0xFF);
                }
            }
            ++i;
        }
    }

    private void renderPackedInt() throws QuantizationException {
        int colorOffset = 24;
        int width = this.x1End - this.x1Start;
        int i = 0;
        int[] buf = ((RGBIntBuffer)this.dataBuffer).getDataBuffer();
        boolean isPrimaryColor = this.optimizations.isPrimaryColorEnabled();
        boolean isAlphaless = this.optimizations.isAlphalessRendering();
        for (Plane2D plane : this.wData) {
            int[] color = this.colors.get(i);
            LutReader reader = this.readers.get(i);
            CodomainChain cc = this.chains.get(i);
            boolean hasMap = cc.hasMapContext();
            QuantumStrategy qs = this.strategies.get(i);
            boolean isMask = qs instanceof BinaryMaskQuantizer;
            double redRatio = color[0] > 0 ? (double)color[0] / 255.0 : 0.0;
            double greenRatio = color[1] > 0 ? (double)color[1] / 255.0 : 0.0;
            double blueRatio = color[2] > 0 ? (double)color[2] / 255.0 : 0.0;
            boolean isXYPlanar = plane.isXYPlanar();
            PixelData data = plane.getData();
            int bytesPerPixel = data.bytesPerPixel();
            if (isPrimaryColor && reader == null) {
                colorOffset = this.getColorOffset(color);
            }
            float alpha = Integer.valueOf(color[3]).floatValue() / 255.0f;
            for (int x2 = this.x2Start; x2 < this.x2End; ++x2) {
                for (int x1 = this.x1Start; x1 < this.x1End; ++x1) {
                    int pix = width * x2 + x1;
                    int discreteValue = isXYPlanar ? qs.quantize(data.getPixelValueDirect(pix * bytesPerPixel)) : qs.quantize(plane.getPixelValue(x1, x2));
                    if (hasMap) {
                        discreteValue = cc.transform(discreteValue);
                    }
                    if (reader != null) {
                        int b;
                        int g;
                        int r1 = (buf[pix] & 0xFF0000) >> 16;
                        int r2 = reader.getRed(discreteValue) & 0xFF;
                        int g1 = (buf[pix] & 0xFF00) >> 8;
                        int g2 = reader.getGreen(discreteValue) & 0xFF;
                        int b1 = buf[pix] & 0xFF;
                        int b2 = reader.getBlue(discreteValue) & 0xFF;
                        int r = r1 + r2;
                        if (r > 255) {
                            r = 255;
                        }
                        if ((g = g1 + g2) > 255) {
                            g = 255;
                        }
                        if ((b = b1 + b2) > 255) {
                            b = 255;
                        }
                        buf[pix] = 0xFF000000 | r << 16 | g << 8 | b;
                        continue;
                    }
                    if (colorOffset != 24) {
                        int n = pix;
                        buf[n] = buf[n] | 0xFF000000;
                        int n2 = pix;
                        buf[n2] = buf[n2] | discreteValue << colorOffset;
                        continue;
                    }
                    int newRValue = (int)(redRatio * (double)discreteValue);
                    int newGValue = (int)(greenRatio * (double)discreteValue);
                    int newBValue = (int)(blueRatio * (double)discreteValue);
                    if (!isAlphaless) {
                        newRValue = (int)((float)newRValue * alpha);
                        newGValue = (int)((float)newGValue * alpha);
                        newBValue = (int)((float)newBValue * alpha);
                    }
                    if (isMask && discreteValue == 255) {
                        buf[pix] = 0xFF000000 | newRValue << 16 | newGValue << 8 | newBValue;
                        continue;
                    }
                    int rValue = ((buf[pix] & 0xFF0000) >> 16) + newRValue;
                    int gValue = ((buf[pix] & 0xFF00) >> 8) + newGValue;
                    int bValue = (buf[pix] & 0xFF) + newBValue;
                    if (rValue > 255) {
                        rValue = 255;
                    }
                    if (gValue > 255) {
                        gValue = 255;
                    }
                    if (bValue > 255) {
                        bValue = 255;
                    }
                    buf[pix] = 0xFF000000 | rValue << 16 | gValue << 8 | bValue;
                }
            }
            ++i;
        }
    }

    private void renderPackedIntAsRGBA() throws QuantizationException {
        int colorOffset = 32;
        int width = this.x1End - this.x1Start;
        int i = 0;
        int[] buf = ((RGBAIntBuffer)this.dataBuffer).getDataBuffer();
        boolean isPrimaryColor = this.optimizations.isPrimaryColorEnabled();
        boolean isAlphaless = this.optimizations.isAlphalessRendering();
        for (Plane2D plane : this.wData) {
            int[] color = this.colors.get(i);
            LutReader reader = this.readers.get(i);
            CodomainChain cc = this.chains.get(i);
            boolean hasMap = cc.hasMapContext();
            QuantumStrategy qs = this.strategies.get(i);
            double redRatio = color[0] > 0 ? (double)color[0] / 255.0 : 0.0;
            double greenRatio = color[1] > 0 ? (double)color[1] / 255.0 : 0.0;
            double blueRatio = color[2] > 0 ? (double)color[2] / 255.0 : 0.0;
            boolean isXYPlanar = plane.isXYPlanar();
            PixelData data = plane.getData();
            int bytesPerPixel = data.bytesPerPixel();
            if (isPrimaryColor) {
                colorOffset = this.getColorOffsetAsRGBA(color);
            }
            float alpha = Integer.valueOf(color[3]).floatValue() / 255.0f;
            for (int x2 = this.x2Start; x2 < this.x2End; ++x2) {
                for (int x1 = this.x1Start; x1 < this.x1End; ++x1) {
                    int pix = width * x2 + x1;
                    int discreteValue = isXYPlanar ? qs.quantize(data.getPixelValueDirect(pix * bytesPerPixel)) : qs.quantize(plane.getPixelValue(x1, x2));
                    if (hasMap) {
                        discreteValue = cc.transform(discreteValue);
                    }
                    if (reader != null) {
                        int b;
                        int g;
                        int r1 = (buf[pix] & 0xFF000000) >> 24;
                        int r2 = reader.getRed(discreteValue) & 0xFF;
                        int g1 = (buf[pix] & 0xFF0000) >> 16;
                        int g2 = reader.getGreen(discreteValue) & 0xFF;
                        int b1 = (buf[pix] & 0xFF00) >> 8;
                        int b2 = reader.getBlue(discreteValue) & 0xFF;
                        int r = r1 + r2;
                        if (r > 255) {
                            r = 255;
                        }
                        if ((g = g1 + g2) > 255) {
                            g = 255;
                        }
                        if ((b = b1 + b2) > 255) {
                            b = 255;
                        }
                        buf[pix] = 0xFF | r << 24 | g << 16 | b << 8;
                        continue;
                    }
                    if (colorOffset != 32) {
                        int n = pix;
                        buf[n] = buf[n] | 0xFF;
                        int n2 = pix;
                        buf[n2] = buf[n2] | discreteValue << colorOffset;
                        continue;
                    }
                    int newRValue = (int)(redRatio * (double)discreteValue);
                    int newGValue = (int)(greenRatio * (double)discreteValue);
                    int newBValue = (int)(blueRatio * (double)discreteValue);
                    if (!isAlphaless) {
                        newRValue = (int)((float)newRValue * alpha);
                        newGValue = (int)((float)newGValue * alpha);
                        newBValue = (int)((float)newBValue * alpha);
                    }
                    int rValue = ((buf[pix] & 0xFF000000) >> 24) + newRValue;
                    int gValue = ((buf[pix] & 0xFF0000) >> 16) + newGValue;
                    int bValue = ((buf[pix] & 0xFF00) >> 8) + newBValue;
                    if (rValue > 255) {
                        rValue = 255;
                    }
                    if (gValue > 255) {
                        gValue = 255;
                    }
                    if (bValue > 255) {
                        bValue = 255;
                    }
                    buf[pix] = 0xFF | rValue << 24 | gValue << 16 | bValue << 8;
                }
            }
            ++i;
        }
    }

    private int getColorOffset(int[] color) {
        if (color[0] == 255) {
            return 16;
        }
        if (color[1] == 255) {
            return 8;
        }
        if (color[2] == 255) {
            return 0;
        }
        throw new IllegalArgumentException("Unable to find color component offset in color.");
    }

    private int getColorOffsetAsRGBA(int[] color) {
        if (color[0] == 255) {
            return 24;
        }
        if (color[1] == 255) {
            return 16;
        }
        if (color[2] == 255) {
            return 8;
        }
        throw new IllegalArgumentException("Unable to find color component offset in color.");
    }
}

