/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.application.action.AbstractDocumentViewAction;
import org.jhotdraw.application.action.ExportableDocumentView;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.util.ResourceBundleUtil;

public class ExportAction
extends AbstractDocumentViewAction {
    public static final String ID = "File.export";
    private Component oldFocusOwner;

    public ExportAction() {
        this.initActionProperties(ID);
    }

    public void actionPerformed(ActionEvent evt) {
        final ExportableDocumentView documentView = (ExportableDocumentView)this.getCurrentView();
        if (documentView.isEnabled()) {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.application.Labels");
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(documentView.getComponent()).getFocusOwner();
            documentView.setEnabled(false);
            JFileChooser fileChooser = documentView.getExportChooser();
            JSheet.showSheet(fileChooser, documentView.getComponent(), labels.getString("filechooser.export"), new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                    if (evt.getOption() == 0) {
                        File file = evt.getFileChooser().getSelectedFile();
                        ExportAction.this.exportToFile(documentView, file, evt.getFileChooser().getFileFilter(), evt.getFileChooser().getAccessory());
                    } else {
                        documentView.setEnabled(true);
                        if (ExportAction.this.oldFocusOwner != null) {
                            ExportAction.this.oldFocusOwner.requestFocus();
                        }
                    }
                }
            });
        }
    }

    protected void exportToFile(final ExportableDocumentView documentView, final File file, final FileFilter filter, final Component accessory) {
        documentView.execute(new Worker(){

            public Object construct() {
                try {
                    documentView.export(file, filter, accessory);
                    return null;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            public void finished(Object value) {
                ExportAction.this.fileExported(documentView, file, value);
            }
        });
    }

    protected void fileExported(ExportableDocumentView documentView, File file, Object value) {
        if (value != null) {
            System.out.flush();
            ((Throwable)value).printStackTrace();
            JSheet.showMessageSheet((Component)documentView.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't export to the file \"" + file + "\".<p>" + "Reason: " + value), 0);
        }
        documentView.setEnabled(true);
        SwingUtilities.getWindowAncestor(documentView.getComponent()).toFront();
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }
}

