/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.env.data.model.DiskQuota;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class QuotaCanvas
extends JPanel {
    static final String IMPORT_SIZE_TEXT = "Import size: ";
    private static final double THRESHOLD = 0.8;
    private static final Dimension DIMENSION = new Dimension(80, 12);
    private static final Color USED_COLOR_DEFAULT = Color.BLUE;
    private static final Color USED_COLOR_WARNING = Color.RED;
    private static final Color COLOR_IMPORT = Color.GREEN;
    private double percentageToImport = 0.0;
    private DiskQuota quota;

    private void formatToolTip(long size) {
        if (this.quota == null) {
            return;
        }
        long free = this.quota.getAvailableSpace();
        ArrayList<String> tips = new ArrayList<String>();
        tips.add("Free Space: " + UIUtilities.formatFileSize(free));
        this.setToolTipText(UIUtilities.formatToolTipText(tips));
    }

    QuotaCanvas() {
        this.setPreferredSize(DIMENSION);
        this.setSize(DIMENSION);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setBackground(UIUtilities.BACKGROUND);
    }

    void setPercentage(DiskQuota quota) {
        this.quota = quota;
        if (quota == null) {
            return;
        }
        this.formatToolTip(0L);
        this.repaint();
    }

    void setSizeInQueue(long size) {
        this.formatToolTip(size);
        if (this.quota == null) {
            return;
        }
        long free = this.quota.getAvailableSpace();
        if (free != 0L) {
            this.percentageToImport = (double)size / (double)free;
        }
        this.repaint();
    }

    double getPercentageToImport() {
        return this.percentageToImport;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color c = USED_COLOR_DEFAULT;
        Graphics2D g2D = (Graphics2D)g;
        Dimension d = this.getPreferredSize();
        g2D.setColor(UIUtilities.BACKGROUND);
        g2D.fillRect(0, 0, d.width, d.height);
        int w = 0;
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, c, w, 0.0f, c);
        g2D.setPaint(paint);
        g2D.fillRect(0, 0, w, d.height);
        int x = w;
        if (this.percentageToImport > 0.0) {
            double value = this.percentageToImport;
            double v = this.percentageToImport;
            c = v < 0.8 ? COLOR_IMPORT : USED_COLOR_WARNING;
            if (v > 1.0) {
                value = 1.0;
            }
            w = (int)((double)d.width * value);
            paint = new GradientPaint(x, 0.0f, c, x + w, 0.0f, c);
            g2D.setPaint(paint);
            g2D.fillRect(x, 0, w, d.height);
        } else {
            c = UIUtilities.BACKGROUND;
            paint = new GradientPaint(x, 0.0f, c, x + w, 0.0f, c);
            g2D.setPaint(paint);
            g2D.fillRect(x, 0, d.width - w, d.height);
        }
    }
}

