/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.imviewer.ImViewerAgent;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewerRecentObject;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ActivateRecentAction
extends AbstractAction {
    private static final String DESCRIPTION = "View the selected image.";
    private ImViewerRecentObject recent;

    public ActivateRecentAction(ImViewerRecentObject recent) {
        if (recent == null) {
            throw new IllegalArgumentException("No recent viewed image.");
        }
        this.recent = recent;
        this.putValue("Name", recent.getImageName());
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.putValue("SmallIcon", recent.getImageIcon());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        EventBus bus = ImViewerAgent.getRegistry().getEventBus();
        ViewImage event = new ViewImage(this.recent.getSecurityContext(), new ViewImageObject(this.recent.getImageID()), null);
        bus.post(event);
    }
}

