/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.model.ChannelData;
import omero.log.Logger;
import omero.model.Length;
import org.apache.commons.collections4.CollectionUtils;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.agents.events.measurement.SelectPlane;
import org.openmicroscopy.shoola.agents.measurement.IconManager;
import org.openmicroscopy.shoola.agents.measurement.MeasurementAgent;
import org.openmicroscopy.shoola.agents.measurement.util.ChannelSummaryModel;
import org.openmicroscopy.shoola.agents.measurement.util.ChannelSummaryTable;
import org.openmicroscopy.shoola.agents.measurement.util.TabPaneInterface;
import org.openmicroscopy.shoola.agents.measurement.util.model.AnalysisStatsWrapper;
import org.openmicroscopy.shoola.agents.measurement.view.ChannelSelectionForm;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityModel;
import org.openmicroscopy.shoola.agents.measurement.view.IntensityValuesDialog;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerControl;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerModel;
import org.openmicroscopy.shoola.agents.measurement.view.MeasurementViewerUI;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.rnd.roi.ROIShapeStatsSimple;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.ExcelWriter;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.roi.figures.MeasureBezierFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureEllipseFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineConnectionFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasurePointFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureRectangleFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureTextFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.annotation.AnnotationKeys;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.ui.ColorListRenderer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;

class IntensityView
extends JPanel
implements ActionListener,
TabPaneInterface,
ChangeListener,
PropertyChangeListener {
    public static final int INDEX = 4;
    public static final int TEXT_WIDTH = 100;
    public static final int TEXT_HEIGHT = 26;
    public static final int LABEL_WIDTH = 60;
    public static final int LABEL_HEIGHT = 26;
    private Dimension intensityTableSize = new Dimension(300, 300);
    private static final String CHANNEL_SHEET = "Channel name ";
    private State state = State.READY;
    private static final String NAME = "Intensity View";
    private static final int SAVE_ACTION = 0;
    private static final int SHOW_TABLE_ACTION = 1;
    private static final int CHANNEL_SELECTION = 2;
    private MeasurementViewerModel model;
    private MeasurementViewerUI view;
    private ChannelSelectionForm channelsSelectionForm;
    private Map ROIStats;
    private ChannelSummaryTable channelSummaryTable;
    private ChannelSummaryModel channelSummaryModel;
    private int selectedChannel = -1;
    private String selectedChannelName;
    private JComboBox channelSelection;
    private JButton saveButton;
    private OneKnobSlider zSlider;
    private OneKnobSlider tSlider;
    private Map<Integer, String> channelName = new TreeMap<Integer, String>();
    private Map<Integer, Color> channelColour = new TreeMap<Integer, Color>();
    private Map<Integer, Double> channelSum = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMin = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMax = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelMean = new TreeMap<Integer, Double>();
    private Map<Integer, Double> channelStdDev = new TreeMap<Integer, Double>();
    private Map<String, Integer> nameMap = new LinkedHashMap<String, Integer>();
    private TreeMap<Coord3D, Map<AnalysisStatsWrapper.StatsType, Map>> shapeStatsList;
    private TreeMap<Coord3D, Map<Integer, ROIShapeStatsSimple>> pixelStats;
    private TreeMap<Coord3D, Map<Integer, Double>> minStats;
    private TreeMap<Coord3D, Map<Integer, Double>> maxStats;
    private TreeMap<Coord3D, Map<Integer, Double>> meanStats;
    private TreeMap<Coord3D, Map<Integer, Double>> stdDevStats;
    private TreeMap<Coord3D, Map<Integer, Double>> sumStats;
    private TreeMap<Coord3D, ROIShape> shapeMap;
    private Coord3D coord;
    private JButton showIntensityTable;
    private ROIShape shape;
    private IntensityValuesDialog intensityDialog;
    private IntensityModel tableModel;
    private MeasurementViewerControl controller;

    private void formatPlane() {
        if (!this.zSlider.isVisible() && !this.tSlider.isVisible()) {
            this.view.setPlaneStatus("");
            return;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.zSlider.isVisible()) {
            buffer.append("Z=" + this.zSlider.getValue() + " ");
        }
        if (this.tSlider.isVisible()) {
            buffer.append("T=" + this.tSlider.getValue());
        }
        this.view.setPlaneStatus(buffer.toString());
    }

    private void handleSliderReleased() {
        int newT;
        if (this.zSlider == null || this.tSlider == null || this.coord == null || this.state != State.READY) {
            return;
        }
        int newZ = this.zSlider.getValue() - 1;
        Coord3D thisCoord = new Coord3D(newZ, newT = this.tSlider.getValue() - 1);
        if (this.coord.equals(thisCoord)) {
            return;
        }
        if (this.checkPlane(newZ, newT)) {
            this.state = State.ANALYSING;
            SelectPlane evt = new SelectPlane(this.model.getPixelsID(), this.zSlider.getValue() - 1, this.tSlider.getValue() - 1);
            MeasurementAgent.getRegistry().getEventBus().post(evt);
        }
    }

    private boolean checkPlane(int z, int t) {
        if (z < 0 || this.model.getNumZSections() <= z) {
            return false;
        }
        return t >= 0 && this.model.getNumTimePoints() > t;
    }

    private void initTableModel() {
        Double[][] summaryData = new Double[1][1];
        ArrayList<String> rowNames = new ArrayList<String>();
        ArrayList<String> columnNames = new ArrayList<String>();
        rowNames.add("");
        columnNames.add("");
        this.channelSummaryModel = new ChannelSummaryModel(rowNames, columnNames, summaryData);
    }

    private void initComponents() {
        Double[][] data = new Double[1][1];
        this.tableModel = new IntensityModel(data);
        this.initTableModel();
        this.channelSummaryTable = new ChannelSummaryTable(this.channelSummaryModel);
        this.showIntensityTable = new JButton("Intensity Values...");
        this.showIntensityTable.setEnabled(false);
        this.showIntensityTable.addActionListener(this);
        this.showIntensityTable.setActionCommand("1");
        this.channelSelection = new JComboBox();
        this.channelSelection.setEnabled(false);
        this.channelSelection.setVisible(false);
        this.channelSelection.addActionListener(this);
        this.channelSelection.setActionCommand("2");
        this.saveButton = new JButton("Export to Excel...");
        this.saveButton.addActionListener(this);
        this.saveButton.setActionCommand("0");
        this.saveButton.setEnabled(false);
        this.state = State.READY;
        this.zSlider = new OneKnobSlider();
        this.zSlider.setOrientation(1);
        this.zSlider.setPaintTicks(false);
        this.zSlider.setPaintLabels(false);
        this.zSlider.setMajorTickSpacing(1);
        this.zSlider.setShowArrows(true);
        this.zSlider.setVisible(false);
        this.zSlider.setEndLabel("Z");
        this.zSlider.setShowEndLabel(true);
        this.tSlider = new OneKnobSlider();
        this.tSlider.setPaintTicks(false);
        this.tSlider.setPaintLabels(false);
        this.tSlider.setMajorTickSpacing(1);
        this.tSlider.setSnapToTicks(true);
        this.tSlider.setShowArrows(true);
        this.tSlider.setVisible(false);
        this.tSlider.setEndLabel("T");
        this.tSlider.setShowEndLabel(true);
        this.zSlider.addPropertyChangeListener(this);
        this.tSlider.addPropertyChangeListener(this);
        this.zSlider.addChangeListener(this);
        this.tSlider.addChangeListener(this);
    }

    private void buildGUI() {
        JPanel scrollPanel = new JPanel();
        JPanel containerPanel = new JPanel();
        containerPanel.setLayout(new BoxLayout(containerPanel, 0));
        JPanel tPanel = this.tablePanel();
        containerPanel.add(this.zSlider);
        containerPanel.add(tPanel);
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BoxLayout(cPanel, 1));
        cPanel.add(containerPanel);
        cPanel.add(this.tSlider);
        JPanel buttonPanel = this.createButtonPanel();
        scrollPanel.setLayout(new BoxLayout(scrollPanel, 0));
        scrollPanel.add(cPanel);
        scrollPanel.add(buttonPanel);
        scrollPanel.add(Box.createGlue());
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPanel, "Center");
        this.intensityDialog = new IntensityValuesDialog(this.view, this.tableModel, this.channelSelection);
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel intensityPanel = UIUtilities.buildComponentPanel(this.showIntensityTable);
        UIUtilities.setDefaultSize(intensityPanel, new Dimension(175, 32));
        panel.add(intensityPanel);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel savePanel = UIUtilities.buildComponentPanel(this.saveButton);
        UIUtilities.setDefaultSize(savePanel, new Dimension(175, 32));
        panel.add(savePanel);
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private JPanel tablePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JScrollPane scrollPane = new JScrollPane(this.channelSummaryTable);
        scrollPane.setVerticalScrollBar(scrollPane.createVerticalScrollBar());
        scrollPane.setHorizontalScrollBar(scrollPane.createHorizontalScrollBar());
        panel.add(scrollPane);
        return panel;
    }

    private void clearMaps() {
        if (this.shapeStatsList != null) {
            this.shapeStatsList.clear();
        }
        this.shapeStatsList = null;
        if (this.pixelStats != null) {
            this.pixelStats.clear();
        }
        this.pixelStats = null;
        if (this.shapeMap != null) {
            this.shapeMap.clear();
        }
        this.shapeMap = null;
        if (this.maxStats != null) {
            this.maxStats.clear();
        }
        this.maxStats = null;
        if (this.meanStats != null) {
            this.meanStats.clear();
        }
        this.meanStats = null;
        if (this.minStats != null) {
            this.minStats.clear();
        }
        this.minStats = null;
        if (this.sumStats != null) {
            this.sumStats.clear();
        }
        this.sumStats = null;
        if (this.stdDevStats != null) {
            this.stdDevStats.clear();
        }
        this.stdDevStats = null;
    }

    private void clearAllValues() {
        this.channelSelection.removeAllItems();
    }

    private void createComboBox() {
        Object[][] channelCols = new Object[this.channelName.size()][2];
        List<ChannelData> metadata = this.model.getMetadata();
        Iterator<ChannelData> i = metadata.iterator();
        int index = 0;
        while (i.hasNext()) {
            ChannelData channelData = i.next();
            int channel = channelData.getIndex();
            if (!this.channelName.containsKey(channel)) continue;
            channelCols[index] = new Object[]{this.channelColour.get(channel), this.channelName.get(channel)};
            ++index;
        }
        this.channelSelection.setModel(new DefaultComboBoxModel((E[])channelCols));
        this.channelSelection.setRenderer(new ColorListRenderer());
        this.selectedChannel = this.selectedChannelName != null ? (this.nameMap.containsKey(this.selectedChannelName) ? this.nameMap.get(this.selectedChannelName) : 0) : 0;
        if (this.selectedChannel >= this.channelSelection.getItemCount() || this.selectedChannel < 0) {
            return;
        }
        this.channelSelection.setSelectedIndex(this.selectedChannel);
        this.channelSelection.setEnabled(true);
    }

    private void populateData(Coord3D coord, int channel) {
        this.channelSummaryTable.setVisible(true);
        this.interpretResults(coord, channel);
        this.populateChannelSummaryTable(coord);
    }

    private void populateChannel() {
        Object[] nameColour = (Object[])this.channelSelection.getSelectedItem();
        String string = (String)nameColour[1];
        if (!this.nameMap.containsKey(string)) {
            return;
        }
        this.selectedChannelName = string;
        int channel = this.nameMap.get(string);
        if (channel < 0) {
            return;
        }
        ROIShapeStatsSimple pixels = this.pixelStats.get(this.coord).get(channel);
        if (pixels == null) {
            return;
        }
        Iterator<Point> pixelIterator = pixels.getPoints().iterator();
        if (!pixelIterator.hasNext()) {
            return;
        }
        Point point = pixelIterator.next();
        double minX = point.getX();
        double maxX = point.getX();
        double minY = point.getY();
        double maxY = point.getY();
        while (pixelIterator.hasNext()) {
            point = pixelIterator.next();
            minX = Math.min(minX, point.getX());
            maxX = Math.max(maxX, point.getX());
            minY = Math.min(minY, point.getY());
            maxY = Math.max(maxY, point.getY());
        }
        int sizeX = (int)(maxX - minX) + 1;
        int sizeY = (int)(maxY - minY + 1.0);
        Double[][] data = new Double[sizeX][sizeY];
        for (int i = 0; i < pixels.getPointsCount(); ++i) {
            point = pixels.getPoints().get(i);
            int x = (int)(point.getX() - minX);
            int y = (int)(point.getY() - minY);
            if (x >= sizeX || y >= sizeY) continue;
            data[x][y] = pixels.getValues()[i];
        }
        this.tableModel = new IntensityModel(data);
        this.intensityDialog.setModel(this.tableModel);
    }

    private void populateChannelSummaryTable(Coord3D coord) {
        ArrayList<String> statNames = new ArrayList<String>();
        ArrayList<String> channelNames = new ArrayList<String>();
        ROIFigure fig = this.shape.getFigure();
        int count = 0;
        statNames.add("Min");
        statNames.add("Max");
        statNames.add("Sum");
        statNames.add("Mean");
        statNames.add("Std Dev.");
        statNames.add("NumPixels");
        if (this.areaFigure(fig)) {
            this.addAreaStats(statNames);
        } else if (this.lineFigure(fig)) {
            this.addLineStats(statNames);
        } else if (this.pointFigure(fig)) {
            this.addPointStats(statNames);
        }
        Iterator<Integer> channelIterator = this.channelName.keySet().iterator();
        while (channelIterator.hasNext()) {
            channelNames.add(this.channelName.get(channelIterator.next()));
        }
        Double[][] data = new Double[this.channelName.size()][statNames.size()];
        channelIterator = this.channelName.keySet().iterator();
        count = 0;
        while (channelIterator.hasNext()) {
            int channel = channelIterator.next();
            this.populateSummaryColumn(fig, data, channel, count);
            ++count;
        }
        this.channelSummaryModel = new ChannelSummaryModel(statNames, channelNames, data);
        this.channelSummaryTable.setModel(this.channelSummaryModel);
    }

    private void populateSummaryColumn(ROIFigure fig, Double[][] data, int channel, int count) {
        data[count][0] = this.channelMin.get(channel);
        data[count][1] = this.channelMax.get(channel);
        data[count][2] = this.channelSum.get(channel);
        data[count][3] = this.channelMean.get(channel);
        data[count][4] = this.channelStdDev.get(channel);
        data[count][5] = fig.getSize();
        if (this.areaFigure(fig)) {
            this.addValuesForAreaFigure(fig, data, channel, count);
        } else if (this.lineFigure(fig)) {
            this.addValuesForLineFigure(fig, data, channel, count);
        } else if (this.pointFigure(fig)) {
            this.addValuesForPointFigure(fig, data, channel, count);
        }
    }

    private void addValuesForAreaFigure(ROIFigure fig, Double[][] data, int channel, int count) {
        Length l = AnnotationKeys.AREA.get(fig.getROIShape());
        data[count][6] = l != null ? l.getValue() : 0.0;
        data[count][7] = fig.getBounds().getX();
        data[count][8] = fig.getBounds().getY();
        l = AnnotationKeys.WIDTH.get(fig.getROIShape());
        data[count][9] = l != null ? l.getValue() : 0.0;
        l = AnnotationKeys.HEIGHT.get(fig.getROIShape());
        data[count][10] = l != null ? l.getValue() : 0.0;
        l = AnnotationKeys.CENTREX.get(fig.getROIShape());
        data[count][11] = l != null ? l.getValue() : 0.0;
        l = AnnotationKeys.CENTREY.get(fig.getROIShape());
        data[count][12] = l != null ? l.getValue() : 0.0;
    }

    private void addValuesForLineFigure(ROIFigure fig, Double[][] data, int channel, int count) {
        Length l = AnnotationKeys.STARTPOINTX.get(this.shape);
        data[count][6] = l != null ? l.getValue() : 0.0;
        l = AnnotationKeys.STARTPOINTY.get(this.shape);
        data[count][7] = l != null ? l.getValue() : 0.0;
        l = AnnotationKeys.ENDPOINTX.get(this.shape);
        data[count][8] = l != null ? l.getValue() : 0.0;
        l = AnnotationKeys.ENDPOINTY.get(this.shape);
        data[count][9] = l != null ? l.getValue() : 0.0;
        l = AnnotationKeys.CENTREX.get(this.shape);
        data[count][10] = l != null ? l.getValue() : 0.0;
        l = AnnotationKeys.CENTREY.get(this.shape);
        data[count][11] = l != null ? l.getValue() : 0.0;
    }

    private void addValuesForPointFigure(ROIFigure fig, Double[][] data, int channel, int count) {
        Length l = AnnotationKeys.CENTREX.get(this.shape);
        data[count][6] = l != null ? l.getValue() : 0.0;
        l = AnnotationKeys.CENTREY.get(this.shape);
        data[count][7] = l != null ? l.getValue() : 0.0;
    }

    private void addAreaStats(List<String> statNames) {
        statNames.add("Area");
        statNames.add("X Coord");
        statNames.add("Y Coord");
        statNames.add("Width");
        statNames.add("Height");
        statNames.add("X Center");
        statNames.add("Y Center");
    }

    private void addLineStats(List<String> statNames) {
        statNames.add("X1 Coord");
        statNames.add("Y1 Coord");
        statNames.add("X2 Coord");
        statNames.add("Y2 Coord");
        statNames.add("X Center");
        statNames.add("Y Center");
    }

    private void addPointStats(List<String> statNames) {
        statNames.add("X Center");
        statNames.add("Y Center");
    }

    private void interpretResults(Coord3D coord, int channel) {
        this.channelMin = this.minStats.get(coord);
        this.channelMax = this.maxStats.get(coord);
        this.channelMean = this.meanStats.get(coord);
        this.channelStdDev = this.stdDevStats.get(coord);
        this.channelSum = this.sumStats.get(coord);
        this.shape = this.shapeMap.get(coord);
    }

    private boolean areaFigure(ROIFigure fig) {
        MeasureBezierFigure bFig;
        if (fig instanceof MeasureEllipseFigure || fig instanceof MeasureRectangleFigure) {
            return true;
        }
        return fig instanceof MeasureBezierFigure && (bFig = (MeasureBezierFigure)fig).isClosed();
    }

    private boolean lineFigure(ROIFigure fig) {
        MeasureBezierFigure bFig;
        if (fig instanceof MeasureLineFigure || fig instanceof MeasureLineConnectionFigure) {
            return true;
        }
        return fig instanceof MeasureBezierFigure && !(bFig = (MeasureBezierFigure)fig).isClosed();
    }

    private boolean pointFigure(ROIFigure fig) {
        return fig instanceof MeasurePointFigure;
    }

    private void saveResults() {
        this.channelsSelectionForm = new ChannelSelectionForm(this.channelName);
        FileChooser chooser = this.view.createSaveToExcelChooser();
        chooser.addComponentToControls(this.channelsSelectionForm);
        if (chooser.showDialog() != 0) {
            return;
        }
        File file = chooser.getFormattedSelectedFile();
        List<Integer> channels = this.channelsSelectionForm.getUserSelection();
        if (channels == null || channels.size() == 0) {
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Save Results", " Please select at least a channel.");
            this.view.setStatus("No Channel selected to output.");
            return;
        }
        ExcelWriter writer = null;
        try {
            BufferedImage originalImage;
            writer = new ExcelWriter(file.getAbsolutePath());
            writer.openFile();
            writer.createSheet("Channel Summary");
            Iterator<Coord3D> coordMapIterator = this.shapeMap.keySet().iterator();
            int n = channels.size();
            if (this.channelSummarySelected(channels)) {
                this.outputSummary(writer, this.shapeMap);
            }
            if ((originalImage = this.model.getRenderedImage()) != null) {
                BufferedImage image = Factory.copyBufferedImage(originalImage);
                this.model.setAttributes(MeasurementAttributes.SHOWID, true);
                this.model.getDrawingView().print(image.getGraphics());
                this.model.setAttributes(MeasurementAttributes.SHOWID, false);
                try {
                    writer.addImageToWorkbook("ThumbnailImage", image);
                }
                catch (Exception e) {
                    Logger logger = MeasurementAgent.getRegistry().getLogger();
                    logger.error((Object)this, "Cannot write Image: " + e.toString());
                }
                int col = writer.getMaxColumn(0);
                writer.writeImage(0, col + 1, 256, 256, "ThumbnailImage");
            }
            if (this.channelSummarySelected(channels) && channels.size() != 1) {
                while (coordMapIterator.hasNext()) {
                    Coord3D currentCoord = coordMapIterator.next();
                    for (int i = 0; i < n; ++i) {
                        Integer channel = channels.get(i);
                        if (channel == ChannelSelectionForm.SUMMARYVALUE || !this.nameMap.containsKey(this.channelName.get(channel))) continue;
                        int rowIndex = 0;
                        String name = this.channelName.get(channel);
                        String sheet = CHANNEL_SHEET + name;
                        if (writer.setCurrentSheet(sheet) == null) {
                            writer.createSheet(sheet);
                        }
                        this.writeHeader(writer, rowIndex, currentCoord);
                        channel = this.nameMap.get(name);
                        this.writeData(writer, rowIndex, currentCoord, channel);
                    }
                }
            }
            writer.close();
        }
        catch (Exception e) {
            Logger logger = MeasurementAgent.getRegistry().getLogger();
            logger.error((Object)this, "Cannot save ROI results: " + e.toString());
            UserNotifier un = MeasurementAgent.getRegistry().getUserNotifier();
            String message = "An error occurred while trying to save the data.\nPlease try again.";
            if (e instanceof NumberFormatException) {
                message = "We only support the British/American style of representing numbers,\nusing a decimal point rather than a comma.";
            }
            un.notifyInfo("Save Results", message);
            file.delete();
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        Registry reg = MeasurementAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        un.notifyInfo("Save ROI results", "The ROI results have been successfully saved.");
    }

    private void printSummaryHeader(ExcelWriter writer, int rowIndex) {
        writer.writeElement(rowIndex, 0, "channel");
        writer.writeElement(rowIndex, 1, "zsection");
        writer.writeElement(rowIndex, 2, "time");
        for (int y = 0; y < this.channelSummaryTable.getRowCount(); ++y) {
            writer.writeElement(rowIndex, 3 + y, this.channelSummaryTable.getValueAt(y, 0));
        }
    }

    private void outputSummary(ExcelWriter writer, TreeMap<Coord3D, ROIShape> shapeMap) {
        int rowIndex = 0;
        this.printSummaryHeader(writer, rowIndex);
        ++rowIndex;
        Coord3D start = shapeMap.firstKey();
        Coord3D end = shapeMap.lastKey();
        ArrayList<Integer> channels = new ArrayList<Integer>(this.channelName.keySet());
        for (Integer c : channels) {
            Set<Coord3D> keys = shapeMap.keySet();
            for (Coord3D coord : keys) {
                this.populateData(coord, c);
                this.outputSummaryRow(writer, rowIndex, c, coord.getZSection(), coord.getTimePoint());
                ++rowIndex;
            }
        }
    }

    private void outputSummaryRow(ExcelWriter writer, int rowIndex, Integer channel, int z, int t) {
        String name = this.channelName.get(channel);
        writer.writeElement(rowIndex, 0, name);
        writer.writeElement(rowIndex, 1, "" + (z + 1));
        writer.writeElement(rowIndex, 2, "" + (t + 1));
        for (int y = 0; y < this.channelSummaryTable.getRowCount(); ++y) {
            String v;
            int col = this.getColumn(name);
            if (col == -1 || (v = (String)this.channelSummaryTable.getValueAt(y, col)) == null) continue;
            if (v.contains(".") && v.contains(",")) {
                v = v.replace(".", "");
                v = v.replace(",", ".");
            }
            writer.writeElement(rowIndex, 3 + y, new Double(v));
        }
    }

    private int getColumn(String name) {
        for (int i = 0; i < this.channelSummaryModel.getColumnCount(); ++i) {
            if (!this.channelSummaryModel.getColumnName(i).equals(name)) continue;
            return i;
        }
        return -1;
    }

    private boolean channelSummarySelected(List<Integer> selection) {
        for (Integer value : selection) {
            if (value != ChannelSelectionForm.SUMMARYVALUE) continue;
            return true;
        }
        return false;
    }

    private void writeHeader(ExcelWriter writer, int rowIndex, Coord3D currentCoord) {
        writer.writeElement(rowIndex, 0, "Image ");
        writer.writeElement(rowIndex, 1, this.model.getImageName());
        writer.writeElement(++rowIndex, 0, "Z ");
        writer.writeElement(rowIndex, 1, currentCoord.getZSection() + 1);
        writer.writeElement(++rowIndex, 0, "T ");
        writer.writeElement(rowIndex, 1, currentCoord.getTimePoint() + 1);
        ++rowIndex;
    }

    private void writeData(ExcelWriter writer, int rowIndex, Coord3D coord, int channel) {
        this.populateData(coord, channel);
        writer.writeTableToSheet(rowIndex, 0, this.tableModel);
    }

    private void showIntensityResults() {
        this.populateChannel();
        UIUtilities.setLocationRelativeToAndSizeToWindow(this, (Component)this.intensityDialog, this.intensityTableSize);
    }

    IntensityView(MeasurementViewerUI view, MeasurementViewerModel model, MeasurementViewerControl controller) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.view = view;
        this.model = model;
        this.controller = controller;
        this.selectedChannelName = "";
        this.initComponents();
        this.buildGUI();
    }

    String getComponentName() {
        return NAME;
    }

    Icon getComponentIcon() {
        IconManager icons = IconManager.getInstance();
        return icons.getIcon(27);
    }

    void onFigureRemoved() {
        this.channelSelection.setEnabled(false);
        this.showIntensityTable.setEnabled(false);
        this.saveButton.setEnabled(false);
        this.channelSelection.setVisible(false);
        this.channelSummaryTable.setVisible(false);
    }

    void displayAnalysisResults() {
        List<String> names;
        this.ROIStats = this.model.getAnalysisResults();
        if (this.ROIStats == null || this.ROIStats.size() == 0) {
            return;
        }
        this.state = State.ANALYSING;
        this.clearMaps();
        this.shapeStatsList = new TreeMap(new Coord3D());
        this.pixelStats = new TreeMap(new Coord3D());
        this.shapeMap = new TreeMap(new Coord3D());
        this.minStats = new TreeMap(new Coord3D());
        this.maxStats = new TreeMap(new Coord3D());
        this.meanStats = new TreeMap(new Coord3D());
        this.sumStats = new TreeMap(new Coord3D());
        this.stdDevStats = new TreeMap(new Coord3D());
        Iterator j = this.ROIStats.entrySet().iterator();
        this.channelName = new TreeMap<Integer, String>();
        this.nameMap = new LinkedHashMap<String, Integer>();
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int minT = Integer.MAX_VALUE;
        int maxT = Integer.MIN_VALUE;
        int cT = this.model.getDefaultT();
        int cZ = this.model.getDefaultZ();
        this.clearAllValues();
        List<ChannelData> metadata = this.model.getMetadata();
        HashSet<Figure> statsMissingFigures = new HashSet<Figure>();
        boolean hasData = false;
        while (j.hasNext()) {
            Map.Entry entry = j.next();
            this.shape = (ROIShape)entry.getKey();
            Coord3D c3D = this.shape.getCoord3D();
            if (c3D.getZSection() == cZ) {
                minT = Math.min(minT, c3D.getTimePoint());
                maxT = Math.max(maxT, c3D.getTimePoint());
            }
            if (c3D.getTimePoint() == cT) {
                minZ = Math.min(minZ, c3D.getZSection());
                maxZ = Math.max(maxZ, c3D.getZSection());
            }
            this.shapeMap.put(c3D, this.shape);
            if (this.shape.getFigure() instanceof MeasureTextFigure) {
                this.state = State.READY;
                return;
            }
            Map<AnalysisStatsWrapper.StatsType, Map> shapeStats = AnalysisStatsWrapper.convertStats((Map)entry.getValue());
            if (shapeStats != null) {
                this.shapeStatsList.put(c3D, shapeStats);
                this.minStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MIN));
                this.maxStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MAX));
                this.meanStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.MEAN));
                this.sumStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.SUM));
                this.stdDevStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.STDDEV));
                this.pixelStats.put(c3D, shapeStats.get((Object)AnalysisStatsWrapper.StatsType.PIXELDATA));
            }
            if (cT == c3D.getTimePoint() && cZ == c3D.getZSection()) {
                if (shapeStats != null) {
                    hasData = true;
                } else {
                    statsMissingFigures.add(this.shape.getFigure());
                }
            }
            this.channelName.clear();
            this.nameMap.clear();
            this.channelColour.clear();
            Iterator<ChannelData> i = metadata.iterator();
            names = new ArrayList<String>();
            while (i.hasNext()) {
                ChannelData channelData = i.next();
                int channel = channelData.getIndex();
                if (!this.model.isChannelActive(channel)) continue;
                Object name = channelData.getChannelLabeling();
                if (names.contains(name)) {
                    name = (String)name + " " + channel;
                }
                this.channelName.put(channel, (String)name);
                this.nameMap.put(this.channelName.get(channel), channel);
                this.channelColour.put(channel, (Color)this.model.getActiveChannels().get(channel));
            }
        }
        if (!hasData) {
            if (!statsMissingFigures.isEmpty()) {
                this.controller.analyseFigures(statsMissingFigures);
            } else {
                this.state = State.READY;
            }
            this.channelSummaryTable.setVisible(false);
            this.clearMaps();
            return;
        }
        if (this.channelName.size() != this.channelColour.size() || this.nameMap.size() == 0) {
            this.createComboBox();
            this.channelSelection.setVisible(this.channelSelection.getItemCount() > 0);
            names = this.channelSummaryModel.getRowNames();
            ArrayList<String> channelNames = new ArrayList<String>();
            Double[][] data = new Double[this.channelName.size()][names.size()];
            this.channelSummaryModel = new ChannelSummaryModel(names, channelNames, data);
            this.channelSummaryTable.setModel(this.channelSummaryModel);
            if (this.intensityDialog != null) {
                this.intensityDialog.setVisible(false);
            }
            this.state = State.READY;
            this.showIntensityTable.setEnabled(this.channelSelection.isVisible());
            this.saveButton.setEnabled(this.tableModel.getRowCount() > 0);
            return;
        }
        ++maxZ;
        ++minZ;
        ++maxT;
        ++minT;
        this.createComboBox();
        this.channelSelection.setVisible(this.channelSelection.getItemCount() > 0);
        this.showIntensityTable.setEnabled(this.channelSelection.isVisible());
        Object[] nameColour = (Object[])this.channelSelection.getSelectedItem();
        String string = (String)nameColour[1];
        this.selectedChannel = this.nameMap.get(string);
        this.zSlider.removeChangeListener(this);
        this.tSlider.removeChangeListener(this);
        this.zSlider.setMaximum(maxZ);
        this.zSlider.setMinimum(minZ);
        this.tSlider.setMaximum(maxT);
        this.tSlider.setMinimum(minT);
        this.zSlider.setVisible(maxZ != minZ);
        this.tSlider.setVisible(maxT != minT);
        this.tSlider.setValue(this.model.getCurrentView().getTimePoint() + 1);
        this.zSlider.setValue(this.model.getCurrentView().getZSection() + 1);
        this.zSlider.addChangeListener(this);
        this.tSlider.addChangeListener(this);
        this.coord = new Coord3D(this.zSlider.getValue() - 1, this.tSlider.getValue() - 1);
        this.shape = this.shapeMap.get(this.coord);
        this.populateData(this.coord, this.selectedChannel);
        this.formatPlane();
        this.saveButton.setEnabled(this.tableModel.getRowCount() > 0);
        this.state = State.READY;
    }

    void onFigureSelected() {
        Set selectedFigures = this.view.getDrawingView().getSelectedFigures();
        if (CollectionUtils.isEmpty((Collection)selectedFigures)) {
            boolean row = this.tableModel.getRowCount() > 1;
            this.showIntensityTable.setEnabled(row);
            this.channelSelection.setEnabled(row);
            this.saveButton.setEnabled(row);
        } else {
            boolean size = this.channelSelection.getModel().getSize() > 0;
            this.channelSelection.setEnabled(size);
            this.showIntensityTable.setEnabled(size);
            this.saveButton.setEnabled(size);
        }
    }

    void onAnalysed(boolean analyse) {
        if (!analyse) {
            this.onFigureSelected();
        } else {
            this.showIntensityTable.setEnabled(false);
            this.saveButton.setEnabled(false);
        }
        this.zSlider.setEnabled(!analyse);
        this.tSlider.setEnabled(!analyse);
        if (!analyse) {
            this.state = State.READY;
        }
    }

    @Override
    public int getIndex() {
        return 4;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.state == State.ANALYSING) {
            return;
        }
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 2: {
                this.populateChannel();
                break;
            }
            case 0: {
                this.saveResults();
                break;
            }
            case 1: {
                this.showIntensityResults();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object src = evt.getSource();
        if (src == this.zSlider || src == this.tSlider) {
            this.formatPlane();
            this.handleSliderReleased();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("oneKnobReleasedProperty".equals(name)) {
            this.handleSliderReleased();
        }
    }

    static enum State {
        ANALYSING,
        READY;

    }
}

