/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.events.iviewer.RendererUnloadedEvent;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.data.FSAccessException;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;

public class RenderingControlLoader
extends EditorLoader {
    public static final int LOAD = 0;
    public static final int RELOAD = 1;
    public static final int RESET = 2;
    private long pixelsID;
    private int index;
    private CallHandle handle;

    private void checkIndex(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported.");
    }

    public RenderingControlLoader(Editor viewer, SecurityContext ctx, long pixelsID, int index) {
        super(viewer, ctx);
        this.checkIndex(index);
        this.pixelsID = pixelsID;
        this.index = index;
    }

    @Override
    public void load() {
        this.handle = this.imView.loadRenderingControl(this.ctx, this.pixelsID, this.index, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleException(Throwable exc) {
        String msg = "The image could not be opened.\nThe image is not a valid image.";
        if (exc instanceof FSAccessException) {
            FSAccessException fsa = (FSAccessException)exc;
            if (fsa.getIndex() == 1) {
                msg = fsa.getMessage();
            }
        } else {
            String s = "Data Retrieval Failure: ";
            LogMessage log = new LogMessage();
            log.print(s);
            log.print(exc);
            this.registry.getLogger().error((Object)this, log);
        }
        if (this.registry.getAdminService().isConnected()) {
            this.registry.getUserNotifier().notifyInfo("Loading Rendering data", msg);
        }
        this.viewer.setRenderingControl(null);
        this.registry.getEventBus().post(new RendererUnloadedEvent(this.pixelsID));
    }

    @Override
    public void handleResult(Object result) {
        switch (this.index) {
            case 0: 
            case 1: 
            case 2: {
                this.viewer.setRenderingControl((RenderingControl)result);
            }
        }
    }
}

