/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.actions.RndAction;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ColorModelAction
extends RndAction
implements PropertyChangeListener {
    public static final String DESCRIPTION_RGB = "Switch between color and monochrome.";
    public static final String DESCRIPTION_GREY_SCALE = "Switch between color and monochrome.";
    private static final int GREY_SCALE_MODEL = 0;
    private static final int RGB_MODEL = 1;
    private IconManager icons;

    private void setActionDetails(int index) {
        switch (index) {
            default: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText("Switch between color and monochrome."));
                this.putValue("SmallIcon", this.icons.getIcon(68));
                break;
            }
            case 1: {
                this.putValue("ShortDescription", UIUtilities.formatToolTipText("Switch between color and monochrome."));
                this.putValue("SmallIcon", this.icons.getIcon(69));
            }
        }
    }

    private void handleColorModel() {
        String c = this.model.getColorModel();
        if ("greyscale".equals(c)) {
            this.setActionDetails(0);
        } else if ("rgb".equals(c)) {
            this.setActionDetails(1);
        }
    }

    public ColorModelAction(Renderer model) {
        super(model);
        this.setEnabled(true);
        this.icons = IconManager.getInstance();
        this.handleColorModel();
        model.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String c = this.model.getColorModel();
        if ("greyscale".equals(c)) {
            this.model.setColorModel("rgb", true);
        } else if ("rgb".equals(c)) {
            this.model.setColorModel("greyscale", true);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("colorModel".equals(name)) {
            this.handleColorModel();
        }
    }
}

