/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.UserProfileCanvas;
import org.openmicroscopy.shoola.agents.metadata.util.UploadPictureDialog;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.DataNode;
import org.openmicroscopy.shoola.agents.util.ui.PermissionsPane;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.Selectable;
import org.openmicroscopy.shoola.util.ui.SelectableComboBoxModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class UserProfile
extends JPanel
implements ActionListener,
ChangeListener,
DocumentListener,
PropertyChangeListener {
    private static final String PASSWORD_OLD = "Old password";
    private static final String PASSWORD_NEW = "New password";
    private static final String PASSWORD_CONFIRMATION = "Confirm password";
    private static final String PASSWORD_CHANGE_TITLE = "Change Password";
    private static final Image USER_PHOTO;
    private Map<String, JTextField> items;
    private JComboBox groupsBox;
    private JPasswordField passwordNew;
    private JPasswordField passwordConfirm;
    private JPasswordField oldPassword;
    private JButton passwordButton;
    private JButton manageButton;
    private JCheckBox adminBox;
    private JCheckBox activeBox;
    private JCheckBox ownerBox;
    private EditorModel model;
    private EditorUI view;
    private Map<String, String> details;
    private boolean groupOwner;
    private boolean admin;
    private boolean active;
    private PermissionsPane permissionsPane;
    private JTextField loginArea;
    private UserProfileCanvas userPicture;
    private JLabel changePhoto;
    private JButton deletePhoto;
    private JButton saveButton;
    private JPanel passwordPanel;

    private void changePassword() {
        if (!this.oldPassword.isVisible()) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.passwordNew.getPassword());
            String newPass = buf.toString();
            if (CommonsLangUtils.isBlank(newPass)) {
                UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
                un.notifyInfo(PASSWORD_CHANGE_TITLE, "Please enter the new password.");
                this.passwordNew.requestFocus();
                return;
            }
            this.passwordNew.setText("");
            this.model.resetPassword(newPass);
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.passwordNew.getPassword());
        String newPass = buf.toString();
        String pass = buf.toString();
        buf = new StringBuffer();
        buf.append(this.passwordConfirm.getPassword());
        String confirm = buf.toString();
        buf = new StringBuffer();
        buf.append(this.oldPassword.getPassword());
        String old = buf.toString();
        if (CommonsLangUtils.isBlank(old)) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "Please enter your old password.");
            this.oldPassword.requestFocus();
            return;
        }
        if (CommonsLangUtils.isBlank(newPass)) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "Please enter your new password.");
            this.passwordNew.requestFocus();
            return;
        }
        if (old.equals(newPass)) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "Your new and old passwords are the same.\nPlease enter a new password.");
            this.passwordNew.setText("");
            this.passwordConfirm.setText("");
            this.passwordNew.requestFocus();
            return;
        }
        if (pass == null || CommonsLangUtils.isBlank(confirm) || !pass.equals(confirm)) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyInfo(PASSWORD_CHANGE_TITLE, "The passwords entered do not match.\nPlease try again.");
            this.passwordNew.setText("");
            this.passwordConfirm.setText("");
            this.passwordNew.requestFocus();
            return;
        }
        this.model.changePassword(old, confirm);
    }

    private void manageGroup() {
    }

    private boolean canModifyPhoto() {
        Object object = this.model.getRefObject();
        if (!(object instanceof ExperimenterData)) {
            return false;
        }
        ExperimenterData exp = (ExperimenterData)object;
        ExperimenterData user = MetadataViewerAgent.getUserDetails();
        return exp.getId() == user.getId();
    }

    private void initComponents() {
        this.admin = false;
        this.active = false;
        this.groupOwner = false;
        this.userPicture = new UserProfileCanvas();
        this.userPicture.setBackground(UIUtilities.BACKGROUND_COLOR);
        IconManager icons = IconManager.getInstance();
        this.changePhoto = new JLabel("Change Photo");
        this.changePhoto.setToolTipText("Upload your photo.");
        this.changePhoto.setForeground(UIUtilities.HYPERLINK_COLOR);
        Font font = this.changePhoto.getFont();
        this.changePhoto.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        this.changePhoto.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.deletePhoto = new JButton(icons.getIcon(82));
        boolean b = this.canModifyPhoto();
        this.changePhoto.setVisible(b);
        this.deletePhoto.setToolTipText("Delete the photo.");
        this.deletePhoto.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.deletePhoto);
        this.deletePhoto.setVisible(false);
        this.loginArea = new JTextField();
        boolean a = MetadataViewerAgent.isEditUser();
        this.loginArea.setEnabled(a);
        this.loginArea.setEditable(a);
        this.adminBox = new JCheckBox();
        this.adminBox.setVisible(false);
        this.adminBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.ownerBox = new JCheckBox();
        this.ownerBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.activeBox = new JCheckBox();
        this.activeBox.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.activeBox.setVisible(false);
        this.passwordButton = new JButton("Change password");
        this.passwordButton.setEnabled(false);
        this.passwordButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.passwordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserProfile.this.changePassword();
            }
        });
        this.saveButton = new JButton("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupData g = UserProfile.this.getSelectedGroup();
                ExperimenterData exp = (ExperimenterData)UserProfile.this.model.getRefObject();
                if (g != null && exp.getDefaultGroup().getId() != g.getId()) {
                    UserProfile.this.model.fireAdminSaving(g, true);
                }
                UserProfile.this.view.saveData(true);
            }
        });
        this.manageButton = new JButton("Group");
        this.manageButton.setEnabled(false);
        this.manageButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.manageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserProfile.this.manageGroup();
            }
        });
        this.passwordPanel = new JPanel();
        this.passwordPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.passwordNew = new JPasswordField();
        this.passwordNew.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.passwordConfirm = new JPasswordField();
        this.passwordConfirm.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.oldPassword = new JPasswordField();
        this.oldPassword.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.items = new HashMap<String, JTextField>();
        ExperimenterData user = (ExperimenterData)this.model.getRefObject();
        List<GroupData> groups = user.getGroups();
        GroupData defaultGroup = user.getDefaultGroup();
        this.groupsBox = new JComboBox();
        this.groupsBox.setEnabled(MetadataViewerAgent.isEditUser() || this.model.isSelf());
        SelectableComboBoxModel m = new SelectableComboBoxModel();
        Iterator i = groups.iterator();
        Selectable<DataNode> selected = null;
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            if (this.model.isSystemGroup(g.getId(), "user")) continue;
            Selectable<DataNode> node = new Selectable<DataNode>(new DataNode(g), true);
            if (g.getId() == defaultGroup.getId()) {
                selected = node;
            }
            m.addElement(node);
        }
        this.groupsBox.setModel(m);
        if (selected != null) {
            this.groupsBox.setSelectedItem(selected);
        }
        this.groupsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UserProfile.this.hasDataToSave();
            }
        });
        this.permissionsPane = new PermissionsPane(defaultGroup.getPermissions(), UIUtilities.BACKGROUND_COLOR, this.model.isAdministrator());
        this.permissionsPane.disablePermissions();
        ExperimenterData logUser = this.model.getCurrentUser();
        if (MetadataViewerAgent.isEditUser()) {
            this.oldPassword.setVisible(false);
            this.adminBox.setVisible(true);
            this.activeBox.setVisible(true);
            this.adminBox.addChangeListener(this);
            this.active = user.isActive();
            this.activeBox.setSelected(this.active);
            this.activeBox.setEnabled(!this.model.isSelf() && !this.model.isSystemUser(user.getId()));
            this.activeBox.addChangeListener(this);
            this.admin = this.isUserAdministrator();
            this.adminBox.setSelected(this.admin);
            this.adminBox.setEnabled(!this.model.isSelf() && !this.model.isSystemUser(user.getId()) && MetadataViewerAgent.isFullAdministrator());
            this.ownerBox.addChangeListener(this);
            this.ownerBox.setEnabled(!this.model.isSystemUser(user.getId()));
        } else {
            this.ownerBox.setEnabled(false);
            this.passwordConfirm.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    UserProfile.this.handlePasswordEntered();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    UserProfile.this.handlePasswordEntered();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
        }
        this.passwordNew.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                UserProfile.this.handlePasswordEntered();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UserProfile.this.handlePasswordEntered();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        if (user.getId() == logUser.getId()) {
            MouseAdapter adapter = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    UserProfile.this.uploadPicture();
                }
            };
            this.changePhoto.addMouseListener(adapter);
            this.deletePhoto.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserProfile.this.model.deletePicture();
                    UserProfile.this.setUserPhoto(null);
                }
            });
            if (groups.size() > 1 && MetadataViewerAgent.isEditUser()) {
                this.groupsBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        GroupData g = UserProfile.this.getSelectedGroup();
                        UserProfile.this.permissionsPane.resetPermissions(g.getPermissions());
                        UserProfile.this.permissionsPane.disablePermissions();
                        UserProfile.this.setGroupOwner(g);
                        ExperimenterData exp = (ExperimenterData)UserProfile.this.model.getRefObject();
                        UserProfile.this.saveButton.setEnabled(exp.getDefaultGroup().getId() != g.getId());
                    }
                });
            }
        }
    }

    private GroupData getSelectedGroup() {
        Selectable item = (Selectable)this.groupsBox.getSelectedItem();
        if (item == null) {
            return null;
        }
        DataNode node = (DataNode)item.getObject();
        return (GroupData)node.getDataObject();
    }

    private boolean isUserAdministrator() {
        ExperimenterData user = (ExperimenterData)this.model.getRefObject();
        ExperimenterData loggedInUser = MetadataViewerAgent.getUserDetails();
        if (user.getId() == loggedInUser.getId()) {
            return MetadataViewerAgent.isEditUser();
        }
        List<GroupData> groups = user.getGroups();
        for (GroupData g : groups) {
            if (!this.model.isSystemGroup(g.getId(), "system")) continue;
            return true;
        }
        return false;
    }

    private void handlePasswordEntered() {
        char[] values = this.passwordNew.getPassword();
        if (this.oldPassword.isVisible()) {
            char[] oldValues = this.oldPassword.getPassword();
            char[] confirmValues = this.passwordConfirm.getPassword();
            if (values != null && oldValues != null && confirmValues != null) {
                this.passwordButton.setEnabled(values.length > 0 && oldValues.length > 0 && confirmValues.length == values.length);
            }
        } else {
            this.passwordButton.setEnabled(values != null && values.length > 0);
        }
    }

    private void uploadPicture() {
        UploadPictureDialog d = new UploadPictureDialog(MetadataViewerAgent.getRegistry().getTaskBar().getFrame());
        d.addPropertyChangeListener(this);
        d.pack();
        UIUtilities.centerAndShow(d);
    }

    private boolean setGroupOwner(GroupData group) {
        Object refObject = this.model.getRefObject();
        if (!(refObject instanceof ExperimenterData)) {
            return false;
        }
        ExperimenterData ref = (ExperimenterData)refObject;
        long userID = MetadataViewerAgent.getUserDetails().getId();
        Set<ExperimenterData> leaders = group.getLeaders();
        boolean isOwner = false;
        if (leaders != null) {
            for (ExperimenterData exp : leaders) {
                if (exp.getId() == ref.getId()) {
                    this.groupOwner = true;
                    this.ownerBox.setSelected(true);
                }
                if (exp.getId() != userID) continue;
                isOwner = true;
            }
        }
        return isOwner;
    }

    private JPanel buildProfileCanvas() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.userPicture);
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        JPanel bar = new JPanel();
        bar.setBackground(UIUtilities.BACKGROUND_COLOR);
        bar.setLayout(new FlowLayout(0));
        bar.add(this.changePhoto);
        bar.add(this.deletePhoto);
        p.add(bar);
        return p;
    }

    private JPanel buildContentPanel() {
        ExperimenterData user = (ExperimenterData)this.model.getRefObject();
        boolean editable = this.model.isUserOwner(user);
        if (!editable) {
            editable = MetadataViewerAgent.isEditUser();
        }
        this.details = EditorUtil.convertExperimenter(user);
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createTitledBorder("User"));
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        Iterator<Map.Entry<String, String>> i = this.details.entrySet().iterator();
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.fill = 2;
        content.add((Component)this.buildProfileCanvas(), c);
        ++c.gridy;
        c.gridx = 0;
        JComponent label = EditorUtil.getLabel("Login Name", true);
        label.setBackground(UIUtilities.BACKGROUND_COLOR);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.loginArea.setText(user.getUserName());
        this.loginArea.setEnabled(false);
        this.loginArea.setEditable(false);
        if (MetadataViewerAgent.isEditUser() && !this.model.isSystemUser(user.getId())) {
            this.loginArea.setEnabled(true);
            this.loginArea.getDocument().addDocumentListener(this);
        }
        content.add((Component)this.loginArea, c);
        while (i.hasNext()) {
            ++c.gridy;
            c.gridx = 0;
            Map.Entry<String, String> entry = i.next();
            String key = entry.getKey();
            String value = entry.getValue();
            label = EditorUtil.getLabel(key, "First Name".equals(key) || "Last Name".equals(key));
            JTextField area = new JTextField(value);
            area.setBackground(UIUtilities.BACKGROUND_COLOR);
            area.setEditable(editable);
            area.setEnabled(editable);
            if (editable) {
                area.getDocument().addDocumentListener(this);
            }
            this.items.put(key, area);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)area, c);
        }
        c.gridx = 0;
        ++c.gridy;
        label = EditorUtil.getLabel("Default Group", false);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        content.add((Component)this.groupsBox, c);
        ++c.gridy;
        content.add((Component)this.permissionsPane, c);
        c.gridx = 0;
        ++c.gridy;
        label = EditorUtil.getLabel("Group's owner", false);
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        content.add((Component)label, c);
        ++c.gridx;
        content.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 1.0;
        content.add((Component)this.ownerBox, c);
        if (this.activeBox.isVisible()) {
            c.gridx = 0;
            ++c.gridy;
            label = EditorUtil.getLabel("Active", false);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 1.0;
            content.add((Component)this.activeBox, c);
        }
        if (this.adminBox.isVisible()) {
            c.gridx = 0;
            ++c.gridy;
            label = EditorUtil.getLabel("Administrator", false);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)label, c);
            ++c.gridx;
            content.add(Box.createHorizontalStrut(5), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 0;
            c.weightx = 1.0;
            content.add((Component)this.adminBox, c);
        }
        c.gridx = 0;
        ++c.gridy;
        content.add(Box.createHorizontalStrut(10), c);
        ++c.gridy;
        label = UIUtilities.setTextFont("* indicates the required fields.", 2);
        label.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
        c.weightx = 0.0;
        content.add((Component)label, c);
        return content;
    }

    private JPanel buildPasswordPanel(String ldap) {
        this.passwordPanel.removeAll();
        if (CommonsLangUtils.isNotBlank(ldap)) {
            this.passwordPanel.setBorder(BorderFactory.createTitledBorder("LDAP"));
            this.passwordPanel.setLayout(new FlowLayout(0));
            this.passwordPanel.add(new JLabel(ldap));
            return this.passwordPanel;
        }
        JPanel content = new JPanel();
        content.setBackground(UIUtilities.BACKGROUND_COLOR);
        content.setBorder(BorderFactory.createTitledBorder(PASSWORD_CHANGE_TITLE));
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        if (MetadataViewerAgent.isEditUser()) {
            content.add((Component)UIUtilities.setTextFont(PASSWORD_NEW), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.passwordNew, c);
        } else {
            content.add((Component)UIUtilities.setTextFont(PASSWORD_OLD), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.oldPassword, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)UIUtilities.setTextFont(PASSWORD_NEW), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.passwordNew, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            content.add((Component)UIUtilities.setTextFont(PASSWORD_CONFIRMATION), c);
            ++c.gridx;
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            content.add((Component)this.passwordConfirm, c);
            ++c.gridy;
            c.gridx = 0;
        }
        this.passwordPanel = new JPanel();
        this.passwordPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.passwordPanel.setLayout(new BoxLayout(this.passwordPanel, 1));
        this.passwordPanel.add(content);
        JPanel buttonPanel = UIUtilities.buildComponentPanel(this.passwordButton);
        buttonPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.passwordPanel.add(buttonPanel);
        return this.passwordPanel;
    }

    private void showRequiredField() {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        un.notifyInfo("Edit User settings", "The required fields cannot be left blank.");
    }

    UserProfile(EditorModel model, EditorUI view) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.view = view;
        this.model = model;
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
    }

    void buildGUI() {
        ExperimenterData exp;
        BufferedImage photo;
        this.removeAll();
        this.initComponents();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.weightx = 1.0;
        this.add((Component)this.buildContentPanel(), c);
        if (this.model.isUserOwner(this.model.getRefObject()) || MetadataViewerAgent.isEditUser()) {
            ++c.gridy;
            JPanel buttonPanel = UIUtilities.buildComponentPanel(this.saveButton);
            buttonPanel.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.add((Component)buttonPanel, c);
            ++c.gridy;
            this.add(Box.createVerticalStrut(5), c);
            ++c.gridy;
            boolean ldap = this.model.isLDAP();
            this.loginArea.setEnabled(!ldap && MetadataViewerAgent.isEditUser());
            this.loginArea.setEditable(!ldap && MetadataViewerAgent.isEditUser());
            if (ldap) {
                this.model.fireLDAPDetailsLoading();
            } else {
                this.buildPasswordPanel(null);
            }
            this.add((Component)this.passwordPanel, c);
        }
        if ((photo = this.model.getUserPhoto((exp = (ExperimenterData)this.model.getRefObject()).getId())) == null) {
            this.setUserPhoto(null);
        } else {
            this.setUserPhoto(photo);
        }
        this.deletePhoto.setVisible(photo != null && this.canModifyPhoto());
    }

    void passwordChanged() {
        this.oldPassword.setText("");
        this.passwordNew.setText("");
        this.passwordConfirm.setText("");
    }

    boolean hasDataToSave() {
        Boolean b;
        this.saveButton.setEnabled(false);
        String text = this.loginArea.getText();
        if (CommonsLangUtils.isBlank(text)) {
            return false;
        }
        text = text.trim();
        ExperimenterData original = (ExperimenterData)this.model.getRefObject();
        if (this.details == null || original == null || this.getSelectedGroup() == null) {
            return false;
        }
        if (!text.equals(original.getUserName())) {
            this.saveButton.setEnabled(true);
            return true;
        }
        if (original.getDefaultGroup().getId() != this.getSelectedGroup().getId()) {
            this.saveButton.setEnabled(true);
            return true;
        }
        Iterator<Map.Entry<String, String>> i = this.details.entrySet().iterator();
        if (this.items.size() > 0) {
            String v;
            JTextField field;
            String key;
            for (Map.Entry<String, String> entry : this.details.entrySet()) {
                key = entry.getKey();
                field = this.items.get(key);
                if (field == null || !CommonsLangUtils.isBlank(v = field.getText()) || !"First Name".equals(key) && !"Last Name".equals(key)) continue;
                return false;
            }
            for (Map.Entry<String, String> entry : this.details.entrySet()) {
                key = entry.getKey();
                field = this.items.get(key);
                if (field == null || (v = field.getText()) == null) continue;
                v = v.trim();
                String value = entry.getValue();
                if (value == null) {
                    value = "";
                }
                if (v.equals(value)) continue;
                this.saveButton.setEnabled(true);
                return true;
            }
        }
        if ((b = Boolean.valueOf(this.ownerBox.isSelected())).compareTo(this.groupOwner) != 0) {
            this.saveButton.setEnabled(true);
            return true;
        }
        if (this.adminBox.isVisible() && (b = Boolean.valueOf(this.adminBox.isSelected())).compareTo(this.admin) != 0) {
            this.saveButton.setEnabled(true);
            return true;
        }
        if (this.activeBox.isVisible() && (b = Boolean.valueOf(this.activeBox.isSelected())).compareTo(this.active) != 0) {
            this.saveButton.setEnabled(true);
            return true;
        }
        return false;
    }

    Object getExperimenterToSave() {
        JTextField f;
        ExperimenterData original = (ExperimenterData)this.model.getRefObject();
        String v = this.loginArea.getText();
        if (v == null || v.trim().length() == 0) {
            this.showRequiredField();
        }
        if ((v = (f = this.items.get("E-mail")).getText()) == null || v.trim().length() == 0) {
            v = "";
        }
        original.setEmail(v);
        f = this.items.get("Institution");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setInstitution(v.trim());
        f = this.items.get("Last Name");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setLastName(v.trim());
        f = this.items.get("First Name");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setFirstName(v.trim());
        f = this.items.get("Middle Name");
        v = f.getText();
        if (v == null) {
            v = "";
        }
        original.setMiddleName(v.trim());
        GroupData g = null;
        String value = this.loginArea.getText().trim();
        UserCredentials uc = new UserCredentials(value, "");
        Boolean b = this.ownerBox.isSelected();
        boolean a = false;
        if (b.compareTo(this.groupOwner) != 0) {
            a = true;
            uc.setOwner(b);
            Object parent = this.model.getParentRootObject();
            if (parent instanceof GroupData) {
                HashMap<GroupData, Boolean> map = new HashMap<GroupData, Boolean>();
                map.put((GroupData)parent, b);
                uc.setGroupsOwner(map);
            }
        }
        if (this.adminBox.isVisible() && (b = Boolean.valueOf(this.adminBox.isSelected())).compareTo(this.admin) != 0) {
            a = true;
            uc.setAdministrator(b);
        }
        if (this.activeBox.isVisible() && (b = Boolean.valueOf(this.activeBox.isSelected())).compareTo(this.active) != 0) {
            a = true;
            uc.setActive(b);
        }
        if (!original.getUserName().equals(value)) {
            a = true;
        }
        if (MetadataViewerAgent.isEditUser()) {
            a = true;
        }
        if (a) {
            HashMap<ExperimenterData, UserCredentials> m = new HashMap<ExperimenterData, UserCredentials>();
            m.put(original, uc);
            AdminObject object = new AdminObject(g, m, 3);
            return object;
        }
        return original;
    }

    void setUserPhoto(BufferedImage image) {
        if (image == null) {
            this.userPicture.setImage(USER_PHOTO);
            this.deletePhoto.setVisible(false);
            return;
        }
        BufferedImage img = Factory.scaleBufferedImage(image, 32);
        this.userPicture.setImage(img);
        this.deletePhoto.setVisible(this.canModifyPhoto());
        this.repaint();
    }

    void setParentRootObject() {
        Object parentRootObject = this.model.getParentRootObject();
        if (parentRootObject instanceof GroupData) {
            this.setGroupOwner((GroupData)parentRootObject);
        }
    }

    void setLDAPDetails(String ldap) {
        this.loginArea.setEnabled(false);
        this.loginArea.setEditable(false);
        this.loginArea.getDocument().removeDocumentListener(this);
        this.buildPasswordPanel(ldap);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.buildGUI();
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.firePropertyChange("save", (Object)false, (Object)true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("uploadPhoto".equals(name)) {
            List l = (List)evt.getNewValue();
            if (l == null || l.size() != 2) {
                return;
            }
            File f = (File)l.get(0);
            if (f == null) {
                return;
            }
            this.model.uploadPicture(f, (String)l.get(1));
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    static {
        IconManager icons = IconManager.getInstance();
        USER_PHOTO = icons.getIcon(101).getImage();
    }
}

