/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.FigureActivityParam;
import org.openmicroscopy.shoola.env.data.model.FigureParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.FigureCreator;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class FigureActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CREATION = "Creating a figure";
    private static final String DESCRIPTION_CREATED = "Figure created";
    private static final String DESCRIPTION_CANCEL = "Figure creation cancelled";
    private FigureActivityParam parameters;

    public FigureActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, FigureActivityParam parameters) {
        super(viewer, registry, ctx);
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        this.initialize(DESCRIPTION_CREATION, parameters.getIcon());
    }

    @Override
    protected UserNotifierLoader createLoader() {
        this.loader = new FigureCreator(this.viewer, this.registry, this.ctx, this.parameters.getParameters(), this.parameters.getIds(), this.parameters.getObjectType(), this);
        return this.loader;
    }

    @Override
    protected void notifyActivityEnd() {
        this.type.setText(DESCRIPTION_CREATED);
        Object p = this.parameters.getParameters();
        if (p instanceof FigureParam) {
            DataObject data = ((FigureParam)p).getAnchor();
            if (data == null) {
                return;
            }
            String name = null;
            if (data instanceof ImageData) {
                name = "image: " + ((ImageData)data).getName();
            } else if (data instanceof DatasetData) {
                name = "dataset: " + ((DatasetData)data).getName();
            } else if (data instanceof ProjectData) {
                name = "project: " + ((ProjectData)data).getName();
            }
            if (name != null && this.messageLabel.getText().trim().length() == 0) {
                this.messageLabel.setText("Attached to " + name);
            }
        }
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
    }
}

