/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.visitor;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.agents.dataBrowser.Colors;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;

public class RowSelectionVisitor
implements ImageDisplayVisitor {
    private Point first;
    private Point last;
    private List<ImageDisplay> selected;
    private Colors colors;

    public RowSelectionVisitor(Rectangle a, Rectangle b, boolean collect) {
        if (a.y < b.y || a.y == b.y && a.x < b.x) {
            this.first = new Point(a.x, a.y);
            this.last = new Point(b.x, b.y);
        } else {
            this.first = new Point(b.x, b.y);
            this.last = new Point(a.x, a.y);
        }
        this.colors = Colors.getInstance();
        if (collect) {
            this.selected = new ArrayList<ImageDisplay>();
        }
    }

    public List<ImageDisplay> getSelected() {
        return this.selected;
    }

    @Override
    public void visit(ImageNode node) {
        Rectangle bounds = node.getBounds();
        if (bounds.y == this.first.y && bounds.x >= this.first.x && bounds.y < this.last.y || bounds.y > this.first.y && bounds.y < this.last.y || bounds.y == this.last.y && bounds.x <= this.last.x && bounds.y > this.first.y || bounds.y == this.first.y && bounds.y == this.last.y && bounds.x >= this.first.x && bounds.x <= this.last.x) {
            node.setHighlight(this.colors.getSelectedHighLight(node, false));
            if (this.selected != null) {
                this.selected.add(node);
            }
        } else {
            node.setHighlight(this.colors.getDeselectedHighLight(node));
        }
    }

    @Override
    public void visit(ImageSet node) {
    }
}

