/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.tree.TreeNode;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.CreateCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class CreateTopContainerAction
extends TreeViewerAction {
    public static final int PROJECT = 0;
    public static final int DATASET = 1;
    public static final int TAG = 2;
    public static final int SCREEN = 3;
    public static final int TAG_SET = 6;
    public static final int GROUP = 7;
    public static final int EXPERIMENTER = 8;
    private static final String NAME = "New...";
    private static final String NAME_PROJECT = "New Project...";
    private static final String NAME_DATASET = "New Dataset...";
    private static final String NAME_TAG = "New Tag...";
    private static final String NAME_TAG_SET = "New Tag Set...";
    private static final String NAME_SCREEN = "New Screen...";
    private static final String NAME_GROUP = "New Group...";
    private static final String NAME_EXPERIMENTER = "New User...";
    private static final String DESCRIPTION_TAG_SET = "Create a new Tag Set.";
    private static final String DESCRIPTION_TAG = "Create a new Tag.";
    private static final String DESCRIPTION_DATASET = "Create a new Dataset.";
    private static final String DESCRIPTION_PROJECT = "Create a new Project.";
    private static final String DESCRIPTION_SCREEN = "Create a new Screen.";
    private static final String DESCRIPTION_GROUP = "Create a new Group.";
    private static final String DESCRIPTION_EXPERIMENTER = "Create a new user.";
    private int nodeType;
    private boolean fromTopMenu = false;

    private void checkType(int value) {
        IconManager icons = IconManager.getInstance();
        switch (value) {
            case 0: {
                this.name = NAME_PROJECT;
                this.putValue("SmallIcon", icons.getIcon(4));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PROJECT));
                break;
            }
            case 1: {
                this.name = NAME_DATASET;
                this.putValue("SmallIcon", icons.getIcon(5));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_DATASET));
                break;
            }
            case 2: {
                this.name = NAME_TAG;
                this.putValue("SmallIcon", icons.getIcon(69));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TAG));
                break;
            }
            case 6: {
                this.name = NAME_TAG_SET;
                this.putValue("SmallIcon", icons.getIcon(71));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_TAG_SET));
                break;
            }
            case 3: {
                this.name = NAME_SCREEN;
                this.putValue("SmallIcon", icons.getIcon(75));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SCREEN));
                break;
            }
            case 7: {
                this.name = NAME_GROUP;
                this.putValue("SmallIcon", icons.getIcon(152));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_GROUP));
                break;
            }
            case 8: {
                this.name = NAME_EXPERIMENTER;
                this.putValue("SmallIcon", icons.getIcon(23));
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_EXPERIMENTER));
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported.");
            }
        }
    }

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            this.setEnabled(false);
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                if (browser.getBrowserType() != 6) {
                    this.setEnabled(TreeViewerAgent.canCreate());
                    break;
                }
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(false);
        if (this.nodeType == 7) {
            this.setEnabled(TreeViewerAgent.isEditGroup());
            return;
        }
        if (this.nodeType == 8) {
            this.setEnabled(TreeViewerAgent.isEditUser());
            return;
        }
        if (this.model.getDisplayMode() == 1 && (this.nodeType == 2 || this.nodeType == 6) && selectedDisplay != null) {
            TreeNode expNode;
            TreeNode[] nodes = selectedDisplay.getPath();
            if (nodes.length > 2 && ((TreeImageDisplay)(expNode = nodes[2])).getUserObject() instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)((TreeImageDisplay)expNode).getUserObject();
                this.setEnabled(exp.getId() == TreeViewerAgent.getUserDetails().getId());
            }
        } else if (this.nodeType != 8) {
            if (selectedDisplay != null) {
                Object ho = selectedDisplay.getUserObject();
                if (ho instanceof ExperimenterData) {
                    long id = TreeViewerAgent.getUserDetails().getId();
                    ExperimenterData exp = (ExperimenterData)ho;
                    this.setEnabled(exp.getId() == id || TreeViewerAgent.isEditUser());
                    return;
                }
                if (ho instanceof GroupData) {
                    this.setEnabled(this.model.getDisplayMode() == 0 && TreeViewerAgent.isEditGroup());
                    return;
                }
                this.setEnabled(this.model.canLink(ho));
            }
        } else if (TreeViewerAgent.isAdministrator()) {
            Browser browser = this.model.getSelectedBrowser();
            if (browser == null || selectedDisplay == null) {
                this.setEnabled(false);
                return;
            }
            Object ho = selectedDisplay.getUserObject();
            if (ho instanceof GroupData) {
                TreeImageDisplay[] selected = browser.getSelectedDisplays();
                this.setEnabled(selected.length == 1 && TreeViewerAgent.isEditGroup());
            } else {
                this.setEnabled(false);
            }
        }
    }

    @Override
    protected void onBrowserSelection(Browser browser) {
        if (browser == null) {
            this.setEnabled(false);
        }
    }

    public CreateTopContainerAction(TreeViewer model, int nodeType) {
        super(model);
        this.checkType(nodeType);
        this.nodeType = nodeType;
        this.onBrowserSelection(model.getSelectedBrowser());
    }

    public void setFromTopMenu(boolean fromTopMenu) {
        this.fromTopMenu = fromTopMenu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int n;
        if (this.nodeType == -1) {
            return;
        }
        boolean withParent = false;
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null && (n = browser.getSelectedDisplays().length) == 1) {
            TreeImageDisplay node = browser.getLastSelectedDisplay();
            Object uo = node.getUserObject();
            switch (this.nodeType) {
                case 1: {
                    if (!(uo instanceof ProjectData)) break;
                    withParent = this.model.canLink(uo);
                    break;
                }
                case 8: {
                    if (!(uo instanceof ExperimenterData)) break;
                    withParent = false;
                    break;
                }
                case 2: {
                    TagAnnotationData tag;
                    String ns;
                    if (!(uo instanceof TagAnnotationData) || (ns = (tag = (TagAnnotationData)uo).getNameSpace()) == null || !"openmicroscopy.org/omero/insight/tagset".equals(ns)) break;
                    withParent = this.model.canLink(tag);
                }
            }
        }
        if (!this.fromTopMenu) {
            withParent = false;
        }
        CreateCmd cmd = new CreateCmd(this.model, this.nodeType);
        cmd.setWithParent(withParent);
        cmd.execute();
    }
}

