/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import ome.system.UpgradeCheck;
import omero.ServerError;
import omero.api.IConfigPrx;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.AdminFacility;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.log.LogMessage;
import omero.log.Logger;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryFactory;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.AdminServiceImpl;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroDataServiceImpl;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroImageServiceImpl;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataServiceImpl;
import org.openmicroscopy.shoola.env.data.events.ConnectedEvent;
import org.openmicroscopy.shoola.env.data.events.ReloadRenderingEngine;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.views.DataViewsFactory;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.svc.proxy.ProxyUtil;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.ShutDownDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class DataServicesFactory {
    private static DataServicesFactory singleton;
    private JDialog connectionDialog;
    private boolean compatible;
    private Container container;
    private static Registry registry;
    private static OMEROGateway omeroGateway;
    private OmeroDataService ds;
    private OmeroImageService is;
    private OmeroMetadataService ms;
    private AdminService admin;

    public static DataServicesFactory getInstance(Container c) throws DSOutOfServiceException {
        if (c == null) {
            throw new NullPointerException();
        }
        if (singleton == null) {
            singleton = new DataServicesFactory(c);
        }
        return singleton;
    }

    private DataServicesFactory(Container c) throws DSOutOfServiceException {
        registry = c.getRegistry();
        this.container = c;
        omeroGateway = new OMEROGateway(this);
        this.ds = new OmeroDataServiceImpl(omeroGateway, registry);
        this.is = new OmeroImageServiceImpl(omeroGateway, registry);
        this.ms = new OmeroMetadataServiceImpl(omeroGateway, registry);
        this.admin = new AdminServiceImpl(omeroGateway, registry);
        RegistryFactory.linkOS(this.ds, registry);
        RegistryFactory.linkMS(this.ms, registry);
        RegistryFactory.linkAdmin(this.admin, registry);
        RegistryFactory.linkIS(this.is, registry);
        RegistryFactory.linkGateway(omeroGateway.getGateway(), registry);
        DataViewsFactory.initialize(c);
    }

    private float determineCompression(int connectionSpeed) {
        switch (connectionSpeed) {
            case 0: 
            case 1: {
                Float value = (Float)registry.lookup("/services/RE/compressionMedium");
                return value.floatValue();
            }
        }
        Float value = (Float)registry.lookup("/services/RE/compressionLow");
        return value.floatValue();
    }

    private int determineImageQuality(int connectionSpeed) {
        switch (connectionSpeed) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    UserCredentials getCredentials() {
        return (UserCredentials)registry.lookup("/user/credentials");
    }

    Integer getElapseTime() {
        return (Integer)registry.lookup("/services/NETWORK/timeout");
    }

    private void addListenerAndShow() {
        if (this.connectionDialog instanceof ShutDownDialog) {
            ShutDownDialog d = (ShutDownDialog)this.connectionDialog;
            d.setGateway(omeroGateway.getGateway());
            d.setCheckupTime(5);
        }
        this.connectionDialog.setModal(false);
        this.connectionDialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("closeNotification".equals(name)) {
                    DataServicesFactory.this.connectionDialog = null;
                    DataServicesFactory.this.exitApplication(true, true);
                } else if ("cancelNotification".equals(name)) {
                    DataServicesFactory.this.connectionDialog = null;
                    DataServicesFactory.this.reconnect();
                }
            }
        });
        this.connectionDialog.setModal(true);
        UIUtilities.centerAndShow(this.connectionDialog);
    }

    private void reconnect() {
        JFrame f = registry.getTaskBar().getFrame();
        Map<SecurityContext, Set<Long>> l = omeroGateway.getRenderingEngines();
        int alive = 0;
        for (SecurityContext ctx : l.keySet()) {
            try {
                if (!omeroGateway.getGateway().isAlive(ctx)) continue;
                ++alive;
            }
            catch (DSOutOfServiceException e) {
                registry.getLogger().error((Object)this, "Failed to reconnect " + e);
            }
        }
        if (alive == l.size()) {
            Iterator<Map.Entry<SecurityContext, Set<Long>>> i = l.entrySet().iterator();
            OmeroImageService svc = registry.getImageService();
            HashMap<SecurityContext, List<Long>> failures = new HashMap<SecurityContext, List<Long>>();
            while (i.hasNext()) {
                Map.Entry<SecurityContext, Set<Long>> entry = i.next();
                Iterator<Long> j = entry.getValue().iterator();
                SecurityContext ctx = entry.getKey();
                while (j.hasNext()) {
                    Long id = j.next();
                    try {
                        RenderingControl p = PixelsServicesFactory.getRenderingControl(registry, (long)id, false);
                        if (p.isShutDown()) continue;
                        registry.getLogger().debug((Object)this, "loading re " + id);
                        svc.reloadRenderingService(ctx, id);
                    }
                    catch (Exception e) {
                        ArrayList<Long> failure = (ArrayList<Long>)failures.get(ctx);
                        if (failure == null) {
                            failure = new ArrayList<Long>();
                            failures.put(ctx, failure);
                        }
                        registry.getLogger().debug((Object)this, "Failed to load re for " + id + " " + e);
                        failure.add(id);
                    }
                }
            }
            if (failures.size() > 0) {
                registry.getEventBus().post(new ReloadRenderingEngine(failures));
            }
            this.connectionDialog.setVisible(false);
            this.connectionDialog.dispose();
            this.connectionDialog = null;
        } else {
            String message = "A failure occurred while attempting to reconnect.\nThe application will now exit.";
            this.connectionDialog = new NotificationDialog(f, "Reconnection Failure", message, null);
            this.addListenerAndShow();
        }
    }

    int runAsPlugin() {
        Integer v = (Integer)this.container.getRegistry().lookup("Plugin");
        if (v == null) {
            return -1;
        }
        return v;
    }

    public void sessionExpiredExit(int index, Throwable exc) {
        if (this.connectionDialog != null && this.connectionDialog.isVisible()) {
            return;
        }
        if (exc != null) {
            LogMessage msg = new LogMessage();
            msg.print("Connection Error");
            msg.print(exc);
            registry.getLogger().debug((Object)this, msg);
        }
        JFrame f = registry.getTaskBar().getFrame();
        switch (index) {
            case 2: {
                String message = "The connection has been destroyed.\nThe application will now exit.";
                this.connectionDialog = new NotificationDialog(f, "Connection Refused", message, null);
                this.addListenerAndShow();
                break;
            }
            case 3: {
                String message = "The network is down.\n";
                this.connectionDialog = new ShutDownDialog(f, "Network down", message, -1);
                this.addListenerAndShow();
                break;
            }
            case 0: {
                this.connectionDialog = new ShutDownDialog(f, "Lost connection", "Trying to reconnect...", index);
                this.addListenerAndShow();
                break;
            }
            case 1: {
                String message = "The server is no longer running.\nPlease contact your system administrator.\nThe application will now exit.";
                this.connectionDialog = new NotificationDialog(f, "Connection Refused", message, null);
                this.addListenerAndShow();
            }
            case 4: {
                String message = "The server ran out of disk space.\nPlease contact your system administrator.\nThe application will now exit.";
                this.connectionDialog = new NotificationDialog(f, "Out of disk space.", message, null);
                this.addListenerAndShow();
            }
        }
    }

    public OmeroDataService getOS() {
        return this.ds;
    }

    public OmeroImageService getIS() {
        return this.is;
    }

    public OmeroMetadataService getMS() {
        return this.ms;
    }

    public AdminService getAdmin() {
        return this.admin;
    }

    public LoginService getLoginService() {
        return (LoginService)registry.lookup("/services/Login");
    }

    Logger getLogger() {
        return registry.getLogger();
    }

    private void resetKeys(List<String> keys) {
        LogMessage msg = new LogMessage();
        try {
            RegistryFactory.fillFromFile(this.container.getConfigFileRelative(), registry, keys);
            StringBuffer buffer = new StringBuffer();
            Iterator<String> i = keys.iterator();
            buffer.append("The following keys have been reset:");
            while (i.hasNext()) {
                buffer.append(i.next() + ", ");
            }
            msg.println(buffer.toString());
            registry.getLogger().debug((Object)this, msg);
        }
        catch (Exception e) {
            msg.println("Parsing error: " + e.getClass().getName() + " - " + e.getMessage());
            registry.getLogger().debug((Object)this, msg);
        }
    }

    public void connect(UserCredentials uc) throws DSOutOfServiceException {
        HashSet<GroupData> available;
        Registry agentReg;
        Map<String, String> props;
        List agents;
        LogMessage msg;
        String val;
        if (uc == null) {
            throw new NullPointerException("No user credentials.");
        }
        String name = (String)this.container.getRegistry().lookup("master");
        if (CommonsLangUtils.isBlank(name)) {
            name = "OMERO.insight";
        }
        uc.setApplicationName(name);
        uc.setCheckNetwork(true);
        ExperimenterData exp = omeroGateway.connect(uc);
        this.compatible = true;
        Object v = this.container.getRegistry().lookup("Version");
        String clientVersion = "";
        if (v != null && v instanceof String) {
            clientVersion = (String)v;
        }
        boolean useSessionKey = false;
        if (uc.getUser().getUsername().equals(omeroGateway.getSessionId(exp))) {
            useSessionKey = true;
            this.container.getRegistry().bind("SessionKey", Boolean.TRUE);
        }
        String version = omeroGateway.getServerVersion();
        IConfigPrx cs = omeroGateway.getGateway().getConfigService(new SecurityContext(exp.getGroupId()));
        try {
            val = cs.getConfigValue("omero.pixeldata.max_plane_width");
            if (val != null) {
                this.container.getRegistry().bind("/services/Thumbnailing/non_pyramid_max_plane_width", Integer.parseInt(val));
            }
            if ((val = cs.getConfigValue("omero.pixeldata.max_plane_height")) != null) {
                this.container.getRegistry().bind("/services/Thumbnailing/non_pyramid_max_plane_height", Integer.parseInt(val));
            }
            String checkname = name;
            if (name.startsWith("OMERO.")) {
                checkname = name.substring("OMERO.".length());
            }
            UpgradeCheck check = new UpgradeCheck(cs.getConfigValue("omero.upgrades.url"), clientVersion, checkname);
            check.run();
        }
        catch (ServerError e2) {
            msg = new LogMessage();
            msg.println("Server error: " + e2.serverExceptionClass + " - " + e2.message);
            registry.getLogger().debug((Object)this, msg);
        }
        try {
            val = cs.getConfigValue("omero.qa.feedback");
            if (val != null && !val.isEmpty()) {
                msg = new LogMessage();
                msg.println("Using URL defined server-side for feedback: " + val);
                registry.getLogger().debug((Object)this, msg);
                this.container.getRegistry().bind("/services/DEBUGGER/hostnameToken", val + "/qa/initial/");
                this.container.getRegistry().bind("/services/DEBUGGER/hostnameProcessing", val + "/qa/upload_processing/");
            } else {
                this.resetKeys(Arrays.asList("/services/DEBUGGER/hostnameToken", "/services/DEBUGGER/hostnameProcessing"));
            }
        }
        catch (ServerError e) {
            msg = new LogMessage();
            msg.println("Server error: " + e.serverExceptionClass + " - " + e.message);
            registry.getLogger().debug((Object)this, msg);
            this.resetKeys(Arrays.asList("/services/DEBUGGER/hostnameToken", "/services/DEBUGGER/hostnameProcessing"));
        }
        EventBus bus = this.container.getRegistry().getEventBus();
        bus.post(new ConnectedEvent());
        this.compatible = true;
        Map<String, String> info = ProxyUtil.collectOsInfoAndJavaVersion();
        msg = new LogMessage();
        msg.println("Server version: " + version);
        msg.println("Client version: " + clientVersion);
        for (Map.Entry<String, String> entry : info.entrySet()) {
            msg.println(entry.getKey() + ": " + entry.getValue());
        }
        registry.getLogger().info((Object)this, msg);
        registry.bind("/current_user/details", exp);
        registry.bind("/connection/speed", this.determineImageQuality(uc.getSpeedLevel()));
        try {
            agents = (List)registry.lookup("/agents");
            props = omeroGateway.getOmeroClientProperties(exp.getGroupId());
            for (String key : props.keySet()) {
                if (registry.lookup(key) == null) {
                    registry.bind(key, props.get(key));
                }
                for (Object agent : agents) {
                    agentReg = ((AgentInfo)agent).getRegistry();
                    if (agentReg == null || agentReg.lookup(key) != null) continue;
                    agentReg.bind(key, props.get(key));
                }
            }
        }
        catch (DSAccessException e1) {
            msg = new LogMessage("Could not load omero client properties from the server", (Throwable)e1);
            registry.getLogger().warn((Object)this, msg);
        }
        try {
            agents = (List)registry.lookup("/agents");
            props = omeroGateway.getServerProperties(exp.getGroupId());
            for (String key : props.keySet()) {
                if (registry.lookup(key) == null) {
                    registry.bind(key, props.get(key));
                }
                for (Object agent : agents) {
                    agentReg = ((AgentInfo)agent).getRegistry();
                    if (agentReg == null || agentReg.lookup(key) != null) continue;
                    agentReg.bind(key, props.get(key));
                }
            }
        }
        catch (DSAccessException e1) {
            msg = new LogMessage("Could not load omero client properties from the server", (Throwable)e1);
            registry.getLogger().warn((Object)this, msg);
        }
        ArrayList<ExperimenterData> exps = new ArrayList<ExperimenterData>();
        Object ldap = null;
        long gid = exp.getDefaultGroup().getId();
        SecurityContext ctx = new SecurityContext(gid);
        boolean canCreate = omeroGateway.canCreate(ctx);
        try {
            GroupData defaultGroup = null;
            registry.bind("canCreate", canCreate);
            Set<GroupData> groups = omeroGateway.getAvailableGroups(ctx, exp);
            registry.bind("/system/roles", omeroGateway.getSystemRoles(ctx));
            Iterator i = groups.iterator();
            available = new HashSet<GroupData>();
            while (i.hasNext()) {
                GroupData g = (GroupData)i.next();
                if (gid == g.getId()) {
                    defaultGroup = g;
                }
                if (!this.admin.isSecuritySystemGroup(g.getId())) {
                    available.add(g);
                    continue;
                }
                if (!this.admin.isSecuritySystemGroup(g.getId(), "system")) continue;
                available.add(g);
                uc.setAdministrator(true);
            }
            if (useSessionKey) {
                available.clear();
            }
            if (available.size() == 0) {
                if (defaultGroup != null) {
                    available.add(defaultGroup);
                } else {
                    available.add(exp.getDefaultGroup());
                }
            }
            registry.bind("/userGroup/details", available);
            ArrayList<Long> ids = new ArrayList<Long>();
            for (GroupData g : available) {
                Set<ExperimenterData> set = g.getExperimenters();
                for (ExperimenterData e : set) {
                    if (ids.contains(e.getId())) continue;
                    ids.add(e.getId());
                    exps.add(e);
                }
            }
            registry.bind("/users/details", exps);
            registry.bind("/users/administrator", uc.isAdministrator());
            try {
                List privs = DataServicesFactory.omeroGateway.getGateway().getAdminService((SecurityContext)ctx).getEventContext().adminPrivileges;
                registry.bind("/fulladministrator", omeroGateway.getGateway().getFacility(AdminFacility.class).isFullAdmin(ctx));
                registry.bind("/users/edit", privs.contains("ModifyUser"));
                registry.bind("/groups/edit", privs.contains("ModifyGroup"));
                registry.bind("/groups/add", privs.contains("ModifyGroupMembership"));
                registry.bind("/groups/move", privs.contains("Chgrp"));
                registry.bind("/scripts/upload", privs.contains("WriteScriptRepo"));
                registry.bind("/users/sudo", privs.contains("Sudo"));
            }
            catch (Exception e1) {
                registry.bind("/fulladministrator", false);
                registry.bind("/users/edit", false);
                registry.bind("/groups/edit", false);
                registry.bind("/groups/add", false);
                registry.bind("/groups/move", false);
                msg = new LogMessage("Could not retrieve admin privileges.", (Throwable)e1);
                registry.getLogger().warn((Object)this, msg);
            }
        }
        catch (DSAccessException e) {
            throw new DSOutOfServiceException("Cannot retrieve groups", e);
        }
        List agents2 = (List)registry.lookup("/agents");
        Iterator kk = agents2.iterator();
        Boolean b = (Boolean)registry.lookup("/services/SERVER/BinaryAvailable");
        String url = (String)registry.lookup("HelpOnLineSearch");
        while (kk.hasNext()) {
            AgentInfo agentInfo = (AgentInfo)kk.next();
            if (!agentInfo.isActive()) continue;
            Registry reg = agentInfo.getRegistry();
            reg.bind("canCreate", canCreate);
            reg.bind("/current_user/details", exp);
            reg.bind("/userGroup/details", available);
            reg.bind("/users/details", exps);
            reg.bind("/users/administrator", uc.isAdministrator());
            reg.bind("/connection/speed", this.determineImageQuality(uc.getSpeedLevel()));
            reg.bind("/services/SERVER/BinaryAvailable", b);
            reg.bind("HelpOnLineSearch", url);
            reg.bind("/fulladministrator", registry.lookup("/fulladministrator"));
            reg.bind("/users/edit", registry.lookup("/users/edit"));
            reg.bind("/groups/edit", registry.lookup("/groups/edit"));
            reg.bind("/groups/move", registry.lookup("/groups/move"));
            reg.bind("/groups/add", registry.lookup("/groups/add"));
            reg.bind("/users/sudo", registry.lookup("/users/sudo"));
            reg.bind("/scripts/upload", registry.lookup("/scripts/upload"));
            reg.bind("omero.client.import.offline.enabled", registry.lookup("omero.client.import.offline.enabled"));
            reg.bind("omero.client.import.mde.enabled", registry.lookup("omero.client.import.mde.enabled"));
        }
    }

    public boolean isConnected() {
        return omeroGateway.isConnected();
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public void shutdown(SecurityContext ctx) {
        try {
            if (omeroGateway != null) {
                omeroGateway.logout();
            }
            PixelsServicesFactory.shutDownRenderingControls(this.container.getRegistry());
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage("Could not properly shutdown OMERO connection", (Throwable)e);
            this.container.getRegistry().getLogger().error((Object)this, msg);
        }
        singleton = null;
        omeroGateway = null;
    }

    public void exitApplication(boolean forceQuit, boolean exit) {
        if (!forceQuit) {
            AgentInfo agentInfo;
            List agents = (List)registry.lookup("/agents");
            Iterator i = agents.iterator();
            i = agents.iterator();
            ArrayList<AgentInfo> notTerminated = new ArrayList<AgentInfo>();
            while (i.hasNext()) {
                agentInfo = (AgentInfo)i.next();
                if (!agentInfo.isActive()) continue;
                Agent a = agentInfo.getAgent();
                if (a.canTerminate()) {
                    a.terminate();
                    continue;
                }
                notTerminated.add(agentInfo);
            }
            if (notTerminated.size() > 0) {
                i = notTerminated.iterator();
                StringBuffer buffer = new StringBuffer();
                while (i.hasNext()) {
                    agentInfo = (AgentInfo)i.next();
                    buffer.append(agentInfo.getName());
                    buffer.append("\n");
                }
                String message = "The following components could not be closed safely:\n" + buffer.toString() + "\nPlease check.";
                String title = "Exit Application";
                Environment env = (Environment)registry.lookup("/env");
                if (env != null && env.isRunAsPlugin()) {
                    title = "Exit Plugin";
                }
                MessageBox box = new MessageBox(registry.getTaskBar().getFrame(), title, message, (Icon)IconManager.getInstance().getIcon(51));
                box.setNoText("OK");
                box.setYesText("Force Quit");
                box.setSize(400, 250);
                if (!env.isRunAsPlugin() && box.centerMsgBox() == 0) {
                    return;
                }
            }
        }
        this.shutdown(null);
        if (exit) {
            this.container.exit();
        }
        singleton = null;
    }

    public void removeGroup(SecurityContext ctx) throws Exception {
        omeroGateway.removeGroup(ctx);
    }

    public void checkServicesStatus() {
        PixelsServicesFactory.checkRenderingControls(this.container.getRegistry());
    }
}

