/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.NotRegisteredException;
import Ice.ObjectFactory;
import java.util.HashMap;
import java.util.Map;

public final class ObjectFactoryManager {
    private Map<String, ObjectFactory> _factoryMap = new HashMap<String, ObjectFactory>();

    public synchronized void add(ObjectFactory factory, String id) {
        ObjectFactory o = this._factoryMap.get(id);
        if (o != null) {
            AlreadyRegisteredException ex = new AlreadyRegisteredException();
            ex.id = id;
            ex.kindOfObject = "object factory";
            throw ex;
        }
        this._factoryMap.put(id, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String id) {
        ObjectFactory factory = null;
        ObjectFactoryManager objectFactoryManager = this;
        synchronized (objectFactoryManager) {
            factory = this._factoryMap.get(id);
            if (factory == null) {
                NotRegisteredException ex = new NotRegisteredException();
                ex.id = id;
                ex.kindOfObject = "object factory";
                throw ex;
            }
            this._factoryMap.remove(id);
        }
        factory.destroy();
    }

    public synchronized ObjectFactory find(String id) {
        return this._factoryMap.get(id);
    }

    ObjectFactoryManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Map<String, ObjectFactory> oldMap = null;
        ObjectFactoryManager objectFactoryManager = this;
        synchronized (objectFactoryManager) {
            oldMap = this._factoryMap;
            this._factoryMap = new HashMap<String, ObjectFactory>();
        }
        for (ObjectFactory factory : oldMap.values()) {
            factory.destroy();
        }
    }
}

