/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import omero.gateway.model.ExperimenterData;
import org.apache.commons.collections4.CollectionUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchComponent;
import org.openmicroscopy.shoola.agents.util.finder.FinderFactory;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.SeparatorPane;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.ExperimenterContext;
import org.openmicroscopy.shoola.util.ui.search.GroupContext;
import org.openmicroscopy.shoola.util.ui.search.SearchContext;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;
import org.openmicroscopy.shoola.util.ui.search.SearchUtil;

public class SearchPanel
extends JPanel {
    public static final String ITEM_ACQUISITIONDATE = "Acquisition date";
    public static final String ITEM_IMPORTDATE = "Import date";
    private static final String TYPE_TITLE = "Type";
    private static final int AREA_COLUMNS = 12;
    private static final String DATE_TOOLTIP = "<html>Please select a date from the drop-down menu or enter<br> a date in the format YYYY-MM-DD (e. g. 2014-07-10)</html>";
    public static final String DATE_TYPE_TOOLTIP = "Select the type of date (Acquisition date applies to images only)";
    private JTextField fullTextArea;
    private JXDatePicker fromDate;
    private JXDatePicker toDate;
    private JButton clearDate;
    private SearchComponent model;
    private Map<Integer, JCheckBox> scopes;
    private Map<Integer, JCheckBox> types;
    private JButton helpBasicButton;
    private JPanel basicSearchComp;
    private JPanel searchFor;
    private JComboBox groupsBox;
    private JComboBox usersBox;
    private JComboBox dateBox;

    private JComboBox createGroupBox() {
        List<GroupContext> groups = this.model.getGroups();
        Object[] values = new Object[groups.size() + 1];
        values[0] = new GroupContext("All groups", Integer.MAX_VALUE);
        int j = 1;
        Iterator<GroupContext> i = groups.iterator();
        while (i.hasNext()) {
            values[j] = i.next();
            ++j;
        }
        return new JComboBox<Object>(values);
    }

    private void initComponents() {
        this.usersBox = new JComboBox();
        this.groupsBox = this.createGroupBox();
        this.scopes = new HashMap<Integer, JCheckBox>(this.model.getNodes().size());
        this.types = new HashMap<Integer, JCheckBox>(this.model.getTypes().size());
        IconManager icons = IconManager.getInstance();
        this.fromDate = UIUtilities.createDatePicker(true, "yyyy-MM-dd");
        this.fromDate.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.fromDate.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Date d = (Date)evt.getNewValue();
                if (d != null) {
                    UserNotifier un;
                    if (d.after(new Date())) {
                        un = DataBrowserAgent.getRegistry().getUserNotifier();
                        un.notifyWarning("Invalid Date", "Selecting a future 'From' date doesn't make any sense.");
                        SearchPanel.this.fromDate.setDate(null);
                    }
                    if (SearchPanel.this.toDate.getDate() != null && d.after(SearchPanel.this.toDate.getDate())) {
                        un = DataBrowserAgent.getRegistry().getUserNotifier();
                        un.notifyWarning("Invalid Date", "Cannot set a 'From' date which is more recent than the 'To' date.");
                        SearchPanel.this.fromDate.setDate(null);
                    }
                }
            }
        });
        this.fromDate.setToolTipText(DATE_TOOLTIP);
        this.toDate = UIUtilities.createDatePicker(true, "yyyy-MM-dd");
        this.toDate.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.toDate.setToolTipText(DATE_TOOLTIP);
        this.toDate.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Date d = (Date)evt.getNewValue();
                if (d != null && SearchPanel.this.fromDate.getDate() != null && d.before(SearchPanel.this.fromDate.getDate())) {
                    UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
                    un.notifyWarning("Invalid Date", "Cannot set a 'To' date which is prior to the 'From' date.");
                    SearchPanel.this.toDate.setDate(null);
                }
            }
        });
        this.clearDate = new JButton(icons.getIcon(74));
        this.clearDate.setToolTipText("Reset the dates");
        UIUtilities.unifiedButtonLookAndFeel(this.clearDate);
        this.clearDate.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.clearDate.setActionCommand("7");
        this.clearDate.addActionListener(this.model);
        this.fullTextArea = new JTextField(12);
        this.fullTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Object source = e.getSource();
                if (source != SearchPanel.this.fullTextArea) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        SearchPanel.this.model.search();
                    }
                }
            }
        });
        this.helpBasicButton = new JButton(icons.getIcon(76));
        this.helpBasicButton.setToolTipText("Search Tips.");
        this.helpBasicButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this.helpBasicButton);
        this.helpBasicButton.addActionListener(this.model);
        this.helpBasicButton.setActionCommand("3");
        SearchContext ctx = this.model.getSearchContext();
        if (ctx == null) {
            return;
        }
    }

    public void resetDate() {
        this.toDate.setDate(null);
        this.fromDate.setDate(null);
    }

    private JPanel buildTimeRange() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.add(UIUtilities.setTextFont("From: "));
        p.add((Component)this.fromDate);
        p.add(UIUtilities.setTextFont("To: "));
        p.add((Component)this.toDate);
        p.add(this.clearDate);
        return p;
    }

    private JPanel buildFields() {
        List<SearchObject> nodes = this.model.getNodes();
        int m = nodes.size();
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.gridy = 1;
        List<Integer> ctxNodes = null;
        SearchContext ctx = this.model.getSearchContext();
        if (ctx != null) {
            ctxNodes = ctx.getContext();
        }
        if (ctxNodes == null) {
            for (int i = 0; i < m; ++i) {
                SearchObject n = nodes.get(i);
                JCheckBox box = new JCheckBox(n.getDescription());
                box.setBackground(UIUtilities.BACKGROUND_COLOR);
                if (i % 2 == 0) {
                    ++c.gridy;
                }
                p.add((Component)box, c);
                this.scopes.put(n.getIndex(), box);
            }
        } else {
            for (int i = 0; i < m; ++i) {
                SearchObject n = nodes.get(i);
                JCheckBox box = new JCheckBox(n.getDescription());
                box.setBackground(UIUtilities.BACKGROUND_COLOR);
                box.setSelected(ctxNodes.contains(n.getIndex()));
                if (i % 2 == 0) {
                    ++c.gridy;
                }
                p.add((Component)box, c);
                this.scopes.put(n.getIndex(), box);
            }
        }
        ++c.gridy;
        UIUtilities.setBoldTitledBorder("Restrict by Field", p);
        return p;
    }

    private JPanel buildScope() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)new JLabel("Groups:"), c);
        c.gridx = 1;
        p.add((Component)this.groupsBox, c);
        this.groupsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SearchPanel.this.updateUsersBox();
            }
        });
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)new JLabel("Data owned by:"), c);
        c.gridx = 1;
        p.add((Component)this.usersBox, c);
        UIUtilities.setBoldTitledBorder("Scope", p);
        return p;
    }

    private void updateUsersBox() {
        this.updateUsersBox(false);
    }

    private void updateUsersBox(boolean reset) {
        ExperimenterContext me = new ExperimenterContext(this.getUserDetails());
        ExperimenterContext all = new ExperimenterContext("All", Integer.MAX_VALUE);
        ExperimenterContext selected = this.usersBox.getSelectedIndex() != -1 && !reset ? (ExperimenterContext)this.usersBox.getSelectedItem() : null;
        this.usersBox.removeAllItems();
        ArrayList<ExperimenterContext> items = new ArrayList<ExperimenterContext>();
        items.add(all);
        items.add(me);
        if (this.groupsBox.getSelectedIndex() > -1) {
            GroupContext groupContext = (GroupContext)this.groupsBox.getSelectedItem();
            ArrayList<GroupContext> groupContexts = new ArrayList<GroupContext>();
            if (groupContext.getId() == Integer.MAX_VALUE) {
                for (int i = 0; i < this.groupsBox.getItemCount(); ++i) {
                    groupContext = (GroupContext)this.groupsBox.getItemAt(i);
                    if (groupContext.getId() == Integer.MAX_VALUE) continue;
                    groupContexts.add(groupContext);
                }
            } else {
                groupContexts.add(groupContext);
            }
            for (GroupContext gc : groupContexts) {
                for (ExperimenterContext exp : gc.getExperimenters()) {
                    if (items.contains(exp)) continue;
                    items.add(exp);
                }
            }
        }
        for (ExperimenterContext item : items) {
            this.usersBox.addItem(item);
        }
        if (selected != null && items.contains(selected)) {
            this.usersBox.setSelectedItem(selected);
        } else {
            this.usersBox.setSelectedItem(me);
        }
    }

    private JPanel buildType() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 3, 3, 3);
        List<SearchObject> nodes = this.model.getTypes();
        List<Integer> ctxNodes = null;
        SearchContext ctx = this.model.getSearchContext();
        if (ctx != null) {
            ctxNodes = ctx.getType();
        }
        int m = nodes.size();
        c.weightx = 1.0;
        if (ctxNodes == null) {
            for (int i = 0; i < m; ++i) {
                SearchObject n = nodes.get(i);
                JCheckBox box = new JCheckBox(n.getDescription());
                box.setBackground(UIUtilities.BACKGROUND_COLOR);
                box.setSelected(true);
                p.add((Component)box, c);
                if (i % 2 == 0) {
                    ++c.gridy;
                }
                this.types.put(n.getIndex(), box);
            }
        } else {
            for (int i = 0; i < m; ++i) {
                SearchObject n = nodes.get(i);
                JCheckBox box = new JCheckBox(n.getDescription());
                box.setBackground(UIUtilities.BACKGROUND_COLOR);
                box.setSelected(ctxNodes.contains(n.getIndex()));
                p.add((Component)box, c);
                if (i % 2 == 0) {
                    ++c.gridy;
                }
                this.types.put(n.getIndex(), box);
            }
        }
        UIUtilities.setBoldTitledBorder(TYPE_TITLE, p);
        return p;
    }

    private JPanel buildBasicSearchComp() {
        this.basicSearchComp = new JPanel();
        this.basicSearchComp.setBackground(UIUtilities.BACKGROUND_COLOR);
        UIUtilities.setBoldTitledBorder("Search", this.basicSearchComp);
        this.basicSearchComp.setLayout(new BoxLayout(this.basicSearchComp, 0));
        this.basicSearchComp.add(this.fullTextArea);
        this.basicSearchComp.add(this.helpBasicButton);
        return this.basicSearchComp;
    }

    private JPanel buildSearchFor() {
        if (this.searchFor == null) {
            this.searchFor = new JPanel();
            this.searchFor.setBackground(UIUtilities.BACKGROUND_COLOR);
            this.searchFor.setLayout(new BoxLayout(this.searchFor, 1));
        }
        this.searchFor.removeAll();
        this.searchFor.add(this.buildBasicSearchComp());
        return this.searchFor;
    }

    private JPanel buildDate() {
        JPanel p = new JPanel();
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.dateBox = new JComboBox();
        this.dateBox.setToolTipText(DATE_TYPE_TOOLTIP);
        this.dateBox.addItem(ITEM_IMPORTDATE);
        this.dateBox.addItem(ITEM_ACQUISITIONDATE);
        p.add(this.dateBox);
        ++c.gridy;
        p.add((Component)this.buildTimeRange(), c);
        UIUtilities.setBoldTitledBorder("Date", p);
        return p;
    }

    private void buildGUI() {
        this.setBorder(null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)this.buildSearchFor(), c);
        SeparatorPane sep = new SeparatorPane();
        sep.setBackground(UIUtilities.BACKGROUND_COLOR);
        ++c.gridy;
        this.add((Component)sep, c);
        JPanel typePanel = this.buildType();
        ++c.gridy;
        this.add((Component)typePanel, c);
        JPanel fieldsPanel = this.buildFields();
        ++c.gridy;
        this.add((Component)fieldsPanel, c);
        JPanel scopePanel = this.buildScope();
        ++c.gridy;
        this.add((Component)scopePanel, c);
        JPanel datePanel = this.buildDate();
        ++c.gridy;
        this.add((Component)datePanel, c);
        this.updateUsersBox();
    }

    SearchPanel(SearchComponent model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    public void reset() {
        this.updateUsersBox(true);
        this.resetDate();
        this.setTerms(Collections.emptyList());
        for (Map.Entry<Integer, JCheckBox> scope : this.scopes.entrySet()) {
            scope.getValue().setSelected(false);
        }
        for (Map.Entry<Integer, JCheckBox> type : this.types.entrySet()) {
            type.getValue().setSelected(true);
        }
    }

    Timestamp getFromDate() {
        Date d = this.fromDate.getDate();
        if (d == null) {
            return null;
        }
        return new Timestamp(d.getTime());
    }

    Timestamp getToDate() {
        Date d = this.toDate.getDate();
        if (d == null) {
            return null;
        }
        return new Timestamp(d.getTime());
    }

    String getDateType() {
        return (String)this.dateBox.getSelectedItem();
    }

    List<Integer> getScope() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Integer key : this.scopes.keySet()) {
            JCheckBox box = this.scopes.get(key);
            if (!box.isSelected()) continue;
            list.add(key);
        }
        return list;
    }

    List<Integer> getType() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Integer key : this.types.keySet()) {
            JCheckBox box = this.types.get(key);
            if (!box.isSelected()) continue;
            list.add(key);
        }
        return list;
    }

    void setTerms(List<String> terms) {
        if (CollectionUtils.isEmpty(terms)) {
            return;
        }
        StringBuffer text = new StringBuffer();
        Iterator<String> i = terms.iterator();
        while (i.hasNext()) {
            text.append(i.next());
            if (!i.hasNext()) continue;
            text.append(" ");
        }
        this.fullTextArea.setText(text.toString());
    }

    String getQuery() {
        return this.fullTextArea.getText();
    }

    String[] getQueryTerms() {
        List<String> l;
        String text = this.fullTextArea.getText();
        if (CommonsLangUtils.isNotBlank(text) && (l = SearchUtil.splitTerms(text)).size() > 0) {
            return l.toArray(new String[0]);
        }
        l = SearchUtil.splitTerms(text);
        if (l.size() > 0) {
            return l.toArray(new String[0]);
        }
        return null;
    }

    private ExperimenterData getUserDetails() {
        return (ExperimenterData)FinderFactory.getRegistry().lookup("/current_user/details");
    }

    long getGroupId() {
        long result = Integer.MAX_VALUE;
        if (this.groupsBox.getSelectedIndex() >= 0) {
            GroupContext g = (GroupContext)this.groupsBox.getSelectedItem();
            result = g.getId();
        }
        return result;
    }

    long getUserId() {
        long result = -1L;
        if (this.usersBox.getSelectedIndex() >= 0) {
            ExperimenterContext u = (ExperimenterContext)this.usersBox.getSelectedItem();
            result = u.getId() == Integer.MAX_VALUE ? -1L : u.getId();
        }
        return result;
    }
}

