/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class SelectableMenuItem<T>
extends JMenuItem {
    public static final String SELECTION_PROPERTY;
    private static final Icon DEFAULT_SELECTED;
    private static final Icon DEFAULT_DESELECTED;
    private Icon checkedIcon;
    private Icon uncheckedIcon;
    private boolean checkable;
    private boolean fireProperty = true;
    private T object;

    public SelectableMenuItem(Icon selectedIcon, Icon deselectedIcon, boolean selectable) {
        this(selectedIcon, deselectedIcon, false, "", selectable);
    }

    public SelectableMenuItem(Icon selectedIcon, Icon deselectedIcon, String text, boolean selectable) {
        this(selectedIcon, deselectedIcon, false, text, selectable);
    }

    public SelectableMenuItem(Icon checkedIcon, Icon uncheckedIcon, boolean checked, boolean checkable) {
        this(checkedIcon, uncheckedIcon, checked, "", checkable);
    }

    public SelectableMenuItem(boolean selected, String text, boolean selectable) {
        this(DEFAULT_SELECTED, DEFAULT_DESELECTED, selected, text, selectable);
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 500 && this.checkable) {
            this.setChecked(!this.isChecked());
            this.repaint();
            for (ActionListener l : this.getActionListeners()) {
                l.actionPerformed(new ActionEvent(this, 1001, ""));
            }
        }
    }

    public SelectableMenuItem(Icon checkedIcon, Icon uncheckedIcon, boolean checked, String text, boolean checkable) {
        super(text);
        this.checkedIcon = checkedIcon;
        this.uncheckedIcon = uncheckedIcon;
        this.fireProperty = false;
        this.setChecked(checked);
        this.fireProperty = true;
        this.checkable = checkable;
    }

    public boolean isChecked() {
        return this.getIcon() == this.checkedIcon;
    }

    public void setChecked(boolean b) {
        if (b) {
            this.setIcon(this.checkedIcon);
        } else {
            this.setIcon(this.uncheckedIcon);
        }
        if (this.fireProperty) {
            this.firePropertyChange(SELECTION_PROPERTY, !b, b);
        }
    }

    public void setChecked(boolean b, boolean fireProperty) {
        if (b) {
            this.setIcon(this.checkedIcon);
        } else {
            this.setIcon(this.uncheckedIcon);
        }
        if (fireProperty) {
            this.firePropertyChange(SELECTION_PROPERTY, !b, b);
        }
    }

    static {
        IconManager icons = IconManager.getInstance();
        DEFAULT_DESELECTED = icons.getIcon(157);
        DEFAULT_SELECTED = icons.getIcon(156);
        SELECTION_PROPERTY = "SelectableMenuItem.SELECTION_PROPERTY";
    }
}

