/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import ome.tools.hibernate.ListAsSQLArrayUserType;

public class SqlArray<T>
implements Array {
    public static final ListAsSQLArrayUserType.ArrayFactory FACTORY = new ListAsSQLArrayUserType.ArrayFactory(){

        @Override
        public Array BOOLEAN(Connection conn, List<Boolean> value) {
            return new BOOLEAN(value);
        }

        @Override
        public Array DATE(Connection conn, List<Date> value) {
            return new DATE(value);
        }

        @Override
        public Array DOUBLE(Connection conn, List<Double> value) {
            return new DOUBLE(value);
        }

        @Override
        public Array FLOAT(Connection conn, List<Float> value) {
            return new FLOAT(value);
        }

        @Override
        public Array INTEGER(Connection conn, List<Integer> value) {
            return new INTEGER(value);
        }

        @Override
        public Array STRING(Connection conn, List<String> value) throws SQLException {
            return new STRING(value);
        }

        @Override
        public Array STRING2(Connection conn, List<String[]> value) throws SQLException {
            return new STRING2(value);
        }
    };
    private List<T> data;
    private int baseType;
    private String baseTypeName = null;
    private static GregorianCalendar calendar = null;

    protected SqlArray(List<T> data, int baseType) {
        this.data = data;
        this.baseType = baseType;
    }

    protected SqlArray(List<T> data, int baseType, String baseTypeName) {
        this(data, baseType);
        this.baseTypeName = baseTypeName;
    }

    @Override
    public String getBaseTypeName() {
        if (this.baseTypeName != null) {
            return this.baseTypeName;
        }
        throw new RuntimeException("No baseTypeName");
    }

    @Override
    public int getBaseType() {
        return this.baseType;
    }

    @Override
    public Object getArray() {
        return this.data.toArray();
    }

    @Override
    public Object getArray(long index, int count) {
        int lastIndex = count - (int)index;
        if (lastIndex > this.data.size()) {
            lastIndex = this.data.size();
        }
        return this.data.subList((int)(index - 1L), lastIndex).toArray();
    }

    @Override
    public Object getArray(Map<String, Class<?>> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getArray(long arg0, int arg1, Map<String, Class<?>> arg2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long index, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long arg0, int arg1, Map<String, Class<?>> arg2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() {
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('{');
        boolean first = true;
        block6: for (T t : this.data) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            if (t == null) {
                result.append("null");
                continue;
            }
            switch (this.baseType) {
                case -7: 
                case 16: {
                    result.append((Boolean)t != false ? "true" : "false");
                    continue block6;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    result.append(t);
                    continue block6;
                }
                case 12: {
                    if (t instanceof String[]) {
                        String[] arr = (String[])t;
                        result.append('{');
                        for (int i = 0; i < arr.length; ++i) {
                            if (i > 0) {
                                result.append(",");
                            }
                            this.appendString(result, arr[i]);
                        }
                        result.append('}');
                        continue block6;
                    }
                    String s = (String)t;
                    this.appendString(result, s);
                    continue block6;
                }
                case 93: {
                    Date d = (Date)t;
                    result.append('\'');
                    this.appendDate(result, d);
                    result.append(d);
                    result.append('\'');
                    continue block6;
                }
            }
            throw new UnsupportedOperationException("Unsupported type " + this.baseType + " / " + this.getBaseTypeName());
        }
        result.append('}');
        return result.toString();
    }

    private void appendString(StringBuilder result, String s) {
        result.append('\"');
        for (int p = 0; p < s.length(); ++p) {
            char ch = s.charAt(p);
            if (ch == '\u0000') {
                throw new IllegalArgumentException("Zero bytes may not occur in string parameters.");
            }
            if (ch == '\\' || ch == '\"') {
                result.append('\\');
            }
            result.append(ch);
        }
        result.append('\"');
    }

    protected void appendDate(StringBuilder sb, Date date) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.setTime(date);
        int l_year = calendar.get(1);
        int l_yearlen = String.valueOf(l_year).length();
        for (int i = 4; i > l_yearlen; --i) {
            sb.append("0");
        }
        sb.append(l_year);
        sb.append('-');
        int l_month = calendar.get(2) + 1;
        if (l_month < 10) {
            sb.append('0');
        }
        sb.append(l_month);
        sb.append('-');
        int l_day = calendar.get(5);
        if (l_day < 10) {
            sb.append('0');
        }
        sb.append(l_day);
        sb.append(' ');
        int hours = calendar.get(11);
        if (hours < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        int minutes = calendar.get(12);
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        sb.append(':');
        int seconds = calendar.get(13);
        if (seconds < 10) {
            sb.append('0');
        }
        sb.append(seconds);
        if (date instanceof Timestamp) {
            Timestamp t = (Timestamp)date;
            char[] decimalStr = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
            char[] nanoStr = Integer.toString(t.getNanos()).toCharArray();
            System.arraycopy(nanoStr, 0, decimalStr, decimalStr.length - nanoStr.length, nanoStr.length);
            sb.append('.');
            sb.append(decimalStr, 0, 6);
        }
        int offset = (calendar.get(15) + calendar.get(16)) / 60000;
        int absoff = Math.abs(offset);
        int hours2 = absoff / 60;
        int mins = absoff - hours2 * 60;
        sb.append(offset >= 0 ? "+" : "-");
        if (hours2 < 10) {
            sb.append('0');
        }
        sb.append(hours2);
        if (mins < 10) {
            sb.append('0');
        }
        sb.append(mins);
        if (calendar.get(0) == 0) {
            sb.append(" BC");
        }
    }

    public static class DATE
    extends SqlArray<Date> {
        public DATE(List<Date> data) {
            super(data, 93);
        }
    }

    public static class STRING2
    extends SqlArray<String[]> {
        public STRING2(List<String[]> data) {
            super(data, 12, "text");
        }
    }

    public static class STRING
    extends SqlArray<String> {
        public STRING(List<String> data) {
            super(data, 12, "text");
        }
    }

    public static class DOUBLE
    extends SqlArray<Double> {
        public DOUBLE(List<Double> data) {
            super(data, 8);
        }
    }

    public static class FLOAT
    extends SqlArray<Float> {
        public FLOAT(List<Float> data) {
            super(data, 6);
        }
    }

    public static class INTEGER
    extends SqlArray<Integer> {
        public INTEGER(List<Integer> data) {
            super(data, 4);
        }
    }

    public static class BOOLEAN
    extends SqlArray<Boolean> {
        public BOOLEAN(List<Boolean> data) {
            super(data, -7);
        }
    }
}

