/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import java.util.ArrayList;
import loci.poi.hssf.record.ExternSheetSubRecord;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class ExternSheetRecord
extends Record {
    public static final short sid = 23;
    private short field_1_number_of_REF_sturcutres;
    private ArrayList field_2_REF_structures;

    public ExternSheetRecord() {
        this.field_2_REF_structures = new ArrayList();
    }

    public ExternSheetRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 23) {
            throw new RecordFormatException("NOT An ExternSheet RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_2_REF_structures = new ArrayList();
        this.field_1_number_of_REF_sturcutres = in.readShort();
        for (int i = 0; i < this.field_1_number_of_REF_sturcutres; ++i) {
            ExternSheetSubRecord rec = new ExternSheetSubRecord(in);
            this.field_2_REF_structures.add(rec);
        }
    }

    public void setNumOfREFStructures(short numStruct) {
        this.field_1_number_of_REF_sturcutres = numStruct;
    }

    public short getNumOfREFStructures() {
        return this.field_1_number_of_REF_sturcutres;
    }

    public void addREFRecord(ExternSheetSubRecord rec) {
        this.field_2_REF_structures.add(rec);
    }

    public int getNumOfREFRecords() {
        return this.field_2_REF_structures.size();
    }

    public ExternSheetSubRecord getREFRecordAt(int elem) {
        ExternSheetSubRecord result = (ExternSheetSubRecord)this.field_2_REF_structures.get(elem);
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[EXTERNSHEET]\n");
        buffer.append("   numOfRefs     = ").append(this.getNumOfREFStructures()).append("\n");
        for (int k = 0; k < this.getNumOfREFRecords(); ++k) {
            buffer.append("refrec         #").append(k).append('\n');
            buffer.append(this.getREFRecordAt(k).toString());
            buffer.append("----refrec     #").append(k).append('\n');
        }
        buffer.append("[/EXTERNSHEET]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)23);
        LittleEndian.putShort(data, 2 + offset, (short)(2 + this.getNumOfREFRecords() * 6));
        LittleEndian.putShort(data, 4 + offset, this.getNumOfREFStructures());
        int pos = 6;
        for (int k = 0; k < this.getNumOfREFRecords(); ++k) {
            ExternSheetSubRecord record = this.getREFRecordAt(k);
            System.arraycopy(record.serialize(), 0, data, pos + offset, 6);
            pos += 6;
        }
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 6 + this.getNumOfREFRecords() * 6;
    }

    @Override
    public short getSid() {
        return 23;
    }
}

