/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.draw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.ArrowTip;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.BezierTool;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.ConnectionTool;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.DefaultDrawing;
import org.jhotdraw.draw.DefaultDrawingEditor;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.DiamondFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.ElbowLiner;
import org.jhotdraw.draw.EllipseFigure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.LineFigure;
import org.jhotdraw.draw.RectangleFigure;
import org.jhotdraw.draw.RoundRectangleFigure;
import org.jhotdraw.draw.TextAreaFigure;
import org.jhotdraw.draw.TextAreaTool;
import org.jhotdraw.draw.TextFigure;
import org.jhotdraw.draw.TextTool;
import org.jhotdraw.draw.TriangleFigure;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.MoveToBackAction;
import org.jhotdraw.draw.action.MoveToFrontAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.ToggleGridAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.action.ZoomAction;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingPanel
extends JPanel {
    private UndoRedoManager undoManager;
    private Drawing drawing;
    private DrawingEditor editor;
    private JToolBar attributesToolbar;
    private JToolBar creationToolbar;
    private JPanel jPanel1;
    private JScrollPane scrollPane;
    private ButtonGroup toolButtonGroup;
    private DefaultDrawingView view;

    public DrawingPanel() {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        this.initComponents();
        this.undoManager = new UndoRedoManager();
        this.editor = new DefaultDrawingEditor();
        this.editor.add(this.view);
        this.addCreationButtonsTo(this.creationToolbar, this.editor);
        ButtonFactory.addAttributesButtonsTo(this.attributesToolbar, this.editor);
        JPopupButton pb = new JPopupButton();
        pb.setItemFont(UIManager.getFont("MenuItem.font"));
        labels.configureToolBarButton(pb, "actions");
        pb.add(new DuplicateAction());
        pb.addSeparator();
        pb.add(new GroupAction(this.editor));
        pb.add(new UngroupAction(this.editor));
        pb.addSeparator();
        pb.add(new MoveToFrontAction(this.editor));
        pb.add(new MoveToBackAction(this.editor));
        pb.addSeparator();
        pb.add(new CutAction());
        pb.add(new CopyAction());
        pb.add(new PasteAction());
        pb.add(new SelectAllAction());
        pb.add(new SelectSameAction(this.editor));
        pb.addSeparator();
        pb.add(this.undoManager.getUndoAction());
        pb.add(this.undoManager.getRedoAction());
        pb.addSeparator();
        pb.add(new ToggleGridAction(this.editor));
        JMenu m = new JMenu(labels.getString("zoom"));
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.1, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.25, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.5, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 0.75, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 1.0, null));
        m.add(rbmi);
        rbmi.setSelected(true);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 1.25, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 1.5, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 2.0, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 3.0, null));
        m.add(rbmi);
        group.add(rbmi);
        rbmi = new JRadioButtonMenuItem(new ZoomAction(this.editor, 4.0, null));
        m.add(rbmi);
        group.add(rbmi);
        pb.add(m);
        pb.setFocusable(false);
        this.creationToolbar.addSeparator();
        this.creationToolbar.add(pb);
        DefaultDrawing drawing = new DefaultDrawing();
        this.view.setDrawing(drawing);
        drawing.addUndoableEditListener(this.undoManager);
    }

    public void setDrawing(Drawing d) {
        this.undoManager.discardAllEdits();
        this.view.getDrawing().removeUndoableEditListener(this.undoManager);
        this.view.setDrawing(d);
        d.addUndoableEditListener(this.undoManager);
    }

    public Drawing getDrawing() {
        return this.view.getDrawing();
    }

    public DrawingView getView() {
        return this.view;
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    private void initComponents() {
        this.toolButtonGroup = new ButtonGroup();
        this.scrollPane = new JScrollPane();
        this.view = new DefaultDrawingView();
        this.jPanel1 = new JPanel();
        this.creationToolbar = new JToolBar();
        this.attributesToolbar = new JToolBar();
        this.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.view);
        this.add((Component)this.scrollPane, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.creationToolbar.setFloatable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.creationToolbar, gridBagConstraints);
        this.attributesToolbar.setFloatable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.attributesToolbar, gridBagConstraints);
        this.add((Component)this.jPanel1, "South");
    }

    private void addCreationButtonsTo(JToolBar tb, DrawingEditor editor) {
        this.addDefaultCreationButtonsTo(tb, editor, ButtonFactory.createDrawingActions(editor), ButtonFactory.createSelectionActions(editor));
    }

    public void addDefaultCreationButtonsTo(JToolBar tb, DrawingEditor editor, Collection<Action> drawingActions, Collection<Action> selectionActions) {
        ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels");
        ButtonFactory.addSelectionToolTo(tb, editor, drawingActions, selectionActions);
        tb.addSeparator();
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new RectangleFigure()), "createRectangle", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new RoundRectangleFigure()), "createRoundRectangle", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new EllipseFigure()), "createEllipse", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new DiamondFigure()), "createDiamond", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new TriangleFigure()), "createTriangle", labels);
        ButtonFactory.addToolTo(tb, editor, new CreationTool(new LineFigure()), "createLine", labels);
        CreationTool ct = new CreationTool(new LineFigure());
        ButtonFactory.addToolTo(tb, editor, ct, "createArrow", labels);
        AbstractAttributedFigure af = (AbstractAttributedFigure)ct.getPrototype();
        AttributeKeys.END_DECORATION.basicSet(af, new ArrowTip(0.35, 12.0, 11.3));
        ButtonFactory.addToolTo(tb, editor, new ConnectionTool(new LineConnectionFigure()), "createLineConnection", labels);
        ConnectionTool cnt = new ConnectionTool(new LineConnectionFigure());
        ButtonFactory.addToolTo(tb, editor, cnt, "createElbowConnection", labels);
        ConnectionFigure lc = cnt.getPrototype();
        lc.setLiner(new ElbowLiner());
        ButtonFactory.addToolTo(tb, editor, new BezierTool(new BezierFigure()), "createScribble", labels);
        ButtonFactory.addToolTo(tb, editor, new BezierTool(new BezierFigure(true)), "createPolygon", labels);
        ButtonFactory.addToolTo(tb, editor, new TextTool(new TextFigure()), "createText", labels);
        ButtonFactory.addToolTo(tb, editor, new TextAreaTool(new TextAreaFigure()), "createTextArea", labels);
    }
}

