/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.finder;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.util.ui.RegExFactory;

public class RegExVisitor
implements TreeImageDisplayVisitor {
    private Color color = Color.RED;
    private Set<TreeImageDisplay> foundNodes;
    private Pattern pattern;
    private Finder model;

    private String getName(Object userObject) {
        if (userObject instanceof ProjectData) {
            return ((ProjectData)userObject).getName();
        }
        if (userObject instanceof DatasetData) {
            return ((DatasetData)userObject).getName();
        }
        if (userObject instanceof ImageData) {
            return ((ImageData)userObject).getName();
        }
        if (userObject instanceof ImageData) {
            return ((ImageData)userObject).getName();
        }
        if (userObject instanceof PlateData) {
            return ((PlateData)userObject).getName();
        }
        if (userObject instanceof ScreenData) {
            return ((ScreenData)userObject).getName();
        }
        return null;
    }

    private String getDescription(Object userObject) {
        if (userObject instanceof ProjectData) {
            return ((ProjectData)userObject).getDescription();
        }
        if (userObject instanceof DatasetData) {
            return ((DatasetData)userObject).getDescription();
        }
        if (userObject instanceof ImageData) {
            return ((ImageData)userObject).getDescription();
        }
        return null;
    }

    private String getAnnotation(Object userObject) {
        Set annotations = null;
        if (userObject instanceof DatasetData) {
            annotations = ((DatasetData)userObject).getAnnotations();
        } else if (userObject instanceof ImageData) {
            annotations = ((ImageData)userObject).getAnnotations();
        }
        if (annotations == null || annotations.size() == 0) {
            return null;
        }
        AnnotationData data = (AnnotationData)annotations.toArray()[0];
        if (data == null) {
            return null;
        }
        return null;
    }

    private void setFoundNode(TreeImageDisplay node) {
        String description;
        String name;
        Object userObject = node.getUserObject();
        Color c = null;
        int style = 0;
        if (this.model.isNameSelected() && (name = this.getName(userObject)) != null && RegExFactory.find(this.pattern, name)) {
            this.foundNodes.add(node);
            c = this.color;
            style = 1;
        }
        if (this.model.isDescriptionSelected() && (description = this.getDescription(userObject)) != null && RegExFactory.find(this.pattern, description)) {
            this.foundNodes.add(node);
            c = this.color;
            style = 1;
        }
        if (this.model.isAnnotationSelected()) {
            String s = this.getAnnotation(userObject);
            if (s == null) {
                return;
            }
            if (RegExFactory.find(this.pattern, s)) {
                this.foundNodes.add(node);
                c = this.color;
                style = 1;
            }
        }
        node.setHighLight(c);
        node.setFontStyle(style);
    }

    public RegExVisitor(Finder model, Pattern pattern) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("No pattern.");
        }
        this.model = model;
        this.pattern = pattern;
        this.foundNodes = new HashSet<TreeImageDisplay>();
    }

    public Set getFoundNodes() {
        return this.foundNodes;
    }

    @Override
    public void visit(TreeImageNode node) {
        this.setFoundNode(node);
    }

    @Override
    public void visit(TreeImageSet node) {
        this.setFoundNode(node);
    }
}

