/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.finder;

import java.util.Collection;
import javax.swing.JFrame;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.util.finder.AdvancedFinder;
import org.openmicroscopy.shoola.agents.util.finder.Finder;
import org.openmicroscopy.shoola.agents.util.finder.QuickFinder;
import org.openmicroscopy.shoola.env.config.Registry;

public class FinderFactory {
    private static final FinderFactory singleton = new FinderFactory();
    private Registry registry;
    private Finder finder;

    public static AdvancedFinder getAdvancedFinder(Registry reg, Collection<GroupData> groups) {
        return FinderFactory.getAdvancedFinder(reg, groups, null);
    }

    public static AdvancedFinder getAdvancedFinder(Registry reg, Collection<GroupData> groups, DataObject refObject) {
        if (FinderFactory.singleton.registry == null) {
            FinderFactory.singleton.registry = reg;
        }
        return (AdvancedFinder)singleton.createFinder(groups, refObject);
    }

    public static QuickFinder getQuickFinder(Registry ctx) {
        return FinderFactory.getQuickFinder(ctx, null);
    }

    public static QuickFinder getQuickFinder(Registry ctx, DataObject refObject) {
        if (FinderFactory.singleton.registry == null) {
            FinderFactory.singleton.registry = ctx;
        }
        return (QuickFinder)singleton.createQuickFinder(refObject);
    }

    public static Registry getRegistry() {
        return FinderFactory.singleton.registry;
    }

    public static JFrame getRefFrame() {
        return FinderFactory.singleton.registry.getTaskBar().getFrame();
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)FinderFactory.singleton.registry.lookup("/current_user/details");
    }

    private FinderFactory() {
    }

    private Finder createFinder(Collection<GroupData> groups, DataObject refObject) {
        if (this.finder != null) {
            return this.finder;
        }
        this.finder = new AdvancedFinder(groups);
        return this.finder;
    }

    private Finder createQuickFinder(DataObject refObject) {
        return new QuickFinder();
    }
}

