/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import omero.gateway.model.PermissionData;
import org.openmicroscopy.shoola.env.ui.RefWindow;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PermissionsPane
extends JPanel
implements ActionListener {
    public static final String PERMISSIONS_CHANGE_PROPERTY = "permissionsChange";
    private static final String WARNING_TITLE = "Permissions Downgrade";
    private static final String WARNING = " Changing group to Private unlinks data from other users'\n containers and unlinks other users' annotations from data.\n The change to Private will abort if different users' data\n is too closely related to be separated. Make the change?";
    private static final String RW_WARNING = "Read-Write groups allow members to delete other members' data.\nSee documentation about 'OMERO permissions' for full details.";
    private JRadioButton readOnlyGroupBox;
    private JRadioButton readAnnotateGroupBox;
    private JRadioButton readWriteGroupBox;
    private JRadioButton privateBox;
    private JRadioButton publicBox;
    private JCheckBox readOnlyPublicBox;
    private JLabel label;
    private boolean allowDowngrade;
    private boolean admin;
    private int originalPermissions;
    private int currentPermissions;
    private boolean warningMessageShown = false;

    private void setPermissions(int permissions) {
        this.currentPermissions = permissions;
        switch (permissions) {
            case 0: {
                this.privateBox.setSelected(true);
                break;
            }
            case 1: {
                this.readOnlyGroupBox.setSelected(true);
                break;
            }
            case 2: {
                this.readAnnotateGroupBox.setSelected(true);
                break;
            }
            case 3: {
                this.readWriteGroupBox.setSelected(true);
                break;
            }
            case 4: {
                this.readOnlyPublicBox.setSelected(true);
                this.publicBox.setSelected(true);
                break;
            }
            case 5: {
                this.publicBox.setSelected(true);
                this.readOnlyPublicBox.setEnabled(true);
            }
        }
    }

    private void initComponents(int permissions) {
        this.originalPermissions = permissions;
        this.allowDowngrade = true;
        this.label = new JLabel();
        Font f = this.label.getFont();
        this.label.setFont(f.deriveFont(2, f.getSize() - 2));
        this.readOnlyGroupBox = new JRadioButton("Read-Only");
        this.readOnlyGroupBox.setToolTipText("Collaborators can only read your data.");
        this.readAnnotateGroupBox = new JRadioButton("Read-Annotate");
        this.readAnnotateGroupBox.setToolTipText("Collaborators can read and annotate your data.");
        this.readWriteGroupBox = new JRadioButton("Read-Write");
        this.readWriteGroupBox.setToolTipText("Collaborators can read, annotate, delete, etc., your data.");
        this.readWriteGroupBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PermissionsPane.this.readWriteGroupBox.isSelected() && !PermissionsPane.this.warningMessageShown) {
                    JOptionPane.showMessageDialog(PermissionsPane.this, PermissionsPane.RW_WARNING, "Warning", 2, IconManager.getInstance().getIcon(29));
                    PermissionsPane.this.warningMessageShown = true;
                }
            }
        });
        this.readOnlyGroupBox.setSelected(true);
        this.readOnlyPublicBox = new JCheckBox("Read-Only");
        this.privateBox = new JRadioButton("Private");
        this.publicBox = new JRadioButton("Public");
        ButtonGroup group = new ButtonGroup();
        group.add(this.privateBox);
        group.add(this.publicBox);
        group.add(this.readOnlyGroupBox);
        group.add(this.readAnnotateGroupBox);
        group.add(this.readWriteGroupBox);
        this.setPermissions(permissions);
        this.readOnlyGroupBox.setBackground(this.getBackground());
        this.readOnlyPublicBox.setBackground(this.getBackground());
        this.privateBox.setBackground(this.getBackground());
        this.readAnnotateGroupBox.setBackground(this.getBackground());
        this.readWriteGroupBox.setBackground(this.getBackground());
        this.publicBox.setBackground(this.getBackground());
        this.label.setBackground(this.getBackground());
        this.publicBox.addActionListener(this);
        this.privateBox.addActionListener(this);
        this.readOnlyGroupBox.addActionListener(this);
        this.readAnnotateGroupBox.addActionListener(this);
    }

    private JPanel buildCollaborative() {
        JPanel p = new JPanel(new GridLayout(2, 2));
        p.setBackground(this.getBackground());
        p.add(this.readOnlyGroupBox);
        p.add(this.readAnnotateGroupBox);
        p.add(this.readWriteGroupBox);
        return p;
    }

    private void buildGUI() {
        JPanel p = new JPanel();
        p.setBackground(this.getBackground());
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 2, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = -1;
        c.fill = 0;
        c.weightx = 0.0;
        JPanel row = new JPanel();
        row.setBackground(this.getBackground());
        row.add(this.privateBox);
        p.add((Component)row, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 2;
        p.add((Component)this.buildCollaborative(), c);
        JPanel content = new JPanel();
        content.setBackground(this.getBackground());
        content.setLayout(new BoxLayout(content, 1));
        JPanel lp = UIUtilities.buildComponentPanel(this.label);
        lp.setBackground(this.getBackground());
        content.add(lp);
        content.add(p);
        this.setLayout(new FlowLayout(0));
        this.add(content);
    }

    private void initialize(int permissions, Color background, boolean admin) {
        if (background != null) {
            this.setBackground(background);
        }
        this.admin = admin;
        this.initComponents(permissions);
        this.buildGUI();
    }

    public PermissionsPane(boolean admin) {
        this(0, admin);
    }

    public PermissionsPane(Color background, boolean admin) {
        this(0, background, admin);
    }

    public PermissionsPane(int permissions, boolean admin) {
        this(permissions, null, admin);
    }

    public PermissionsPane(int permissions, Color background, boolean admin) {
        this.initialize(permissions, background, admin);
    }

    public PermissionsPane(PermissionData permissions, boolean admin) {
        this(permissions, null, admin);
    }

    public PermissionsPane(PermissionData permissions, Color background, boolean admin) {
        int level = 0;
        if (permissions != null) {
            level = permissions.getPermissionsLevel();
        }
        this.initialize(level, background, admin);
    }

    public void resetPermissions(PermissionData permissions) {
        if (permissions == null) {
            return;
        }
        this.removeAll();
        this.initialize(permissions.getPermissionsLevel(), this.getBackground(), this.admin);
        this.revalidate();
        this.repaint();
    }

    public int getPermissions() {
        if (this.privateBox.isSelected()) {
            return 0;
        }
        if (this.readAnnotateGroupBox.isSelected()) {
            return 2;
        }
        if (this.readOnlyGroupBox.isSelected()) {
            return 1;
        }
        if (this.readOnlyPublicBox.isSelected()) {
            return 4;
        }
        if (this.readWriteGroupBox.isSelected()) {
            return 3;
        }
        return -1;
    }

    public void displayWarningText() {
        this.label.setText(WARNING);
        this.repaint();
    }

    public void allowDowngrade(boolean downgrade) {
        this.allowDowngrade = downgrade;
    }

    public void disablePermissions() {
        this.publicBox.removeActionListener(this);
        this.privateBox.removeActionListener(this);
        this.readOnlyGroupBox.setEnabled(false);
        this.readOnlyPublicBox.setEnabled(false);
        this.readAnnotateGroupBox.setEnabled(false);
        this.readWriteGroupBox.setEnabled(false);
        this.privateBox.setEnabled(false);
        this.publicBox.setEnabled(false);
        this.publicBox.addActionListener(this);
        this.privateBox.addActionListener(this);
        this.removeAll();
        switch (this.getPermissions()) {
            case 0: {
                this.add(this.privateBox);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                JPanel p = this.buildCollaborative();
                this.add(p);
                break;
            }
            case 4: 
            case 5: {
                JPanel p = new JPanel();
                p.setBackground(this.getBackground());
                p.add(this.publicBox);
                p.add(this.readOnlyPublicBox);
                this.add(p);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.publicBox.removeActionListener(this);
        this.privateBox.removeActionListener(this);
        this.readOnlyGroupBox.removeActionListener(this);
        this.readAnnotateGroupBox.removeActionListener(this);
        this.readWriteGroupBox.removeActionListener(this);
        if (this.privateBox != null) {
            this.privateBox.setEnabled(enabled);
        }
        if (this.publicBox != null) {
            this.publicBox.setEnabled(enabled);
        }
        if (this.readOnlyGroupBox != null) {
            this.readOnlyGroupBox.setEnabled(enabled);
        }
        if (this.readOnlyPublicBox != null) {
            this.readOnlyPublicBox.setEnabled(enabled);
        }
        if (this.readWriteGroupBox != null) {
            this.readWriteGroupBox.setEnabled(enabled);
        }
        if (this.readAnnotateGroupBox != null) {
            this.readAnnotateGroupBox.setEnabled(enabled);
        }
        this.publicBox.addActionListener(this);
        this.privateBox.addActionListener(this);
        this.readOnlyGroupBox.addActionListener(this);
        this.readAnnotateGroupBox.addActionListener(this);
        this.readWriteGroupBox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (!this.allowDowngrade && this.privateBox == src && this.originalPermissions > 0) {
            MessageBox d = new MessageBox(new RefWindow(), WARNING_TITLE, WARNING);
            if (d.centerMsgBox() == 1) {
                this.firePropertyChange(PERMISSIONS_CHANGE_PROPERTY, -1, this.getPermissions());
            } else {
                this.setPermissions(this.currentPermissions);
            }
            this.currentPermissions = this.getPermissions();
            return;
        }
        this.currentPermissions = this.getPermissions();
        if (this.readOnlyGroupBox == src || this.readAnnotateGroupBox == src || this.privateBox == src || this.readWriteGroupBox == src) {
            this.firePropertyChange(PERMISSIONS_CHANGE_PROPERTY, -1, this.getPermissions());
            return;
        }
        this.readWriteGroupBox.setEnabled(false);
        this.readOnlyGroupBox.setEnabled(false);
        this.readAnnotateGroupBox.setEnabled(false);
        this.firePropertyChange(PERMISSIONS_CHANGE_PROPERTY, -1, this.getPermissions());
    }
}

