/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class PixelsDataLoader
extends BatchCallTree {
    public static final int SET = 1;
    public static final int SIZE = 2;
    private long pixelsID;
    private Object result;
    private BatchCall loadCall;
    private SecurityContext ctx;

    private BatchCall makePixelsBatchCall() {
        return new BatchCall("Loading pixels: "){

            @Override
            public void doCall() throws Exception {
                OmeroImageService rds = PixelsDataLoader.this.context.getImageService();
                PixelsDataLoader.this.result = rds.loadPixels(PixelsDataLoader.this.ctx, PixelsDataLoader.this.pixelsID);
            }
        };
    }

    private BatchCall makePixelsSizeBatchCall() {
        return new BatchCall("Loading pixels: "){

            @Override
            public void doCall() throws Exception {
                OmeroImageService rds = PixelsDataLoader.this.context.getImageService();
                PixelsDataLoader.this.result = rds.isLargeImage(PixelsDataLoader.this.ctx, PixelsDataLoader.this.pixelsID);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public PixelsDataLoader(SecurityContext ctx, long pixelsID, int index) {
        this.pixelsID = pixelsID;
        this.ctx = ctx;
        switch (index) {
            case 1: {
                this.loadCall = this.makePixelsBatchCall();
                break;
            }
            case 2: {
                this.loadCall = this.makePixelsSizeBatchCall();
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }
}

