/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import javax.swing.Icon;
import omero.cmd.GraphException;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.ProcessReport;
import org.openmicroscopy.shoola.env.data.model.TransferableActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.DataObjectTransfer;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class DataTransferActivity
extends ActivityComponent {
    private static final String DESCRIPTION_START = "Moving data ";
    private static final String DESCRIPTION_END = "Move completed";
    private static final String DESCRIPTION_ERROR = "Unable to transfer data";
    private static final String DESCRIPTION_CANCEL = "Move cancelled";
    private TransferableActivityParam parameters;

    public DataTransferActivity(UserNotifier viewer, Registry registry, TransferableActivityParam parameters) {
        super(viewer, registry, null);
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters not valid.");
        }
        this.parameters = parameters;
        String name = parameters.getGroupName();
        StringBuffer buffer = new StringBuffer();
        buffer.append(DESCRIPTION_START);
        if (name != null && name.length() > 0) {
            buffer.append("to ");
            buffer.append(name);
        }
        this.initialize(buffer.toString(), parameters.getIcon());
        int n = parameters.getNumber();
        String end = "";
        if (n > 1) {
            end = "s";
        }
        this.messageLabel.setText("move " + n + " object" + end);
    }

    @Override
    protected UserNotifierLoader createLoader() {
        this.loader = new DataObjectTransfer(this.viewer, this.registry, this.parameters.getObject(), (ActivityComponent)this);
        return this.loader;
    }

    @Override
    protected void notifyActivityEnd() {
        if (this.result instanceof ProcessReport) {
            this.type.setText(DESCRIPTION_ERROR);
            GraphException ex = ((ProcessReport)this.result).getGraphException();
            if (ex != null) {
                this.messageLabel.setText(this.messageLabel.getText() + " - " + ex.message);
            }
            this.notifyActivityError();
        } else {
            this.type.setText(DESCRIPTION_END);
            Icon icon = this.parameters.getIcon();
            if (icon != null) {
                this.iconLabel.setIcon(icon);
            }
        }
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
        Icon icon = this.parameters.getFailureIcon();
        if (icon != null) {
            this.iconLabel.setIcon(icon);
        }
    }
}

