/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class CSVFilter
extends CustomizedFileFilter {
    public static final String CSV = "csv";
    public static final String TSV = "tsv";
    public static final String[] extensions = new String[2];
    private static final String description;

    @Override
    public String getMIMEType() {
        return "text/csv";
    }

    @Override
    public String getExtension() {
        return CSV;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    @Override
    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        CSVFilter.extensions[0] = CSV;
        CSVFilter.extensions[1] = TSV;
        StringBuffer s = new StringBuffer();
        s.append("Comma/Tab Separated Value (");
        for (int i = 0; i < extensions.length; ++i) {
            s.append("*." + extensions[i]);
            if (i >= extensions.length - 1) continue;
            s.append(", ");
        }
        s.append(")");
        description = s.toString();
    }
}

