/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.TableResult;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.PlateSaver;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailFieldsLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.DecoratorVisitor;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.WellGridElement;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourObject;

class WellsModel
extends DataBrowserModel {
    private int rows;
    private int columns;
    private Dimension wellDimension;
    private List<ImageDisplay> wellNodes;
    private Set<CellDisplay> cells;
    private int fieldsNumber;
    private int defaultFieldIndex;
    private int rowSequenceIndex;
    private int columnSequenceIndex;
    private List<WellGridElement> validWells;
    private boolean withThumbnails;
    private List<WellSampleNode> selectedNodes;

    private List<ImageDisplay> sortByRow(Set nodes) {
        ArrayList<ImageDisplay> l = new ArrayList<ImageDisplay>();
        if (nodes == null) {
            return l;
        }
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            l.add((ImageDisplay)i.next());
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                WellData w1 = (WellData)((WellImageSet)o1).getHierarchyObject();
                WellData w2 = (WellData)((WellImageSet)o2).getHierarchyObject();
                int n1 = w1.getRow();
                int n2 = w2.getRow();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                } else if (n1 == n2) {
                    int c2;
                    int c1 = w1.getColumn();
                    if (c1 < (c2 = w2.getColumn().intValue())) {
                        v = -1;
                    } else if (c1 > c2) {
                        v = 1;
                    }
                }
                return v;
            }
        };
        Collections.sort(l, c);
        return l;
    }

    private Color createColor(WellData data) {
        int red = data.getRed();
        int green = data.getGreen();
        int blue = data.getBlue();
        int alpha = data.getAlpha();
        if (red < 0 || green < 0 || blue < 0 || alpha < 0) {
            return null;
        }
        if (red > 255 || green > 255 || blue > 255 || alpha > 255) {
            return null;
        }
        return new Color(red, green, blue, alpha);
    }

    private boolean isSameDescription(String d1, String d2) {
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null && d2 != null) {
            return false;
        }
        if (d1 != null && d2 == null) {
            return false;
        }
        if (d1 != null && d2 != null) {
            String t1 = d1.trim();
            String t2 = d2.trim();
            if (t1 != null && t2 != null) {
                return t1.equals(t2);
            }
            return false;
        }
        return false;
    }

    private void handleCellSelection(CellDisplay cell, WellImageSet well, List<DataObject> results) {
        String description = cell.getDescription();
        Color c = cell.getHighlight();
        WellData data = (WellData)well.getHierarchyObject();
        data.setWellType(description);
        well.setDescription(description);
        results.add(data);
        if (c == null || !cell.isSpecified()) {
            data.setRed(null);
        } else {
            data.setRed(c.getRed());
            data.setGreen(c.getGreen());
            data.setBlue(c.getBlue());
            data.setAlpha(c.getAlpha());
        }
        well.setHighlight(c);
    }

    WellsModel(SecurityContext ctx, Object parent, Collection<WellData> wells, boolean withThumbnails) {
        super(ctx);
        CellDisplay cell;
        int k;
        Object rowSequence;
        Object columnSequence;
        ColourObject co;
        if (wells == null) {
            throw new IllegalArgumentException("No wells.");
        }
        this.withThumbnails = withThumbnails;
        this.selectedNodes = new ArrayList<WellSampleNode>();
        this.wellDimension = null;
        this.parent = parent;
        this.wellNodes = this.sortByRow(DataBrowserTranslator.transformHierarchy(wells));
        PlateData plate = (PlateData)parent;
        this.columnSequenceIndex = plate.getColumnSequenceIndex();
        this.rowSequenceIndex = plate.getRowSequenceIndex();
        this.defaultFieldIndex = plate.getDefaultSample();
        if (this.defaultFieldIndex < 0) {
            this.defaultFieldIndex = 0;
        }
        HashSet<ImageNode> samples = new HashSet<ImageNode>();
        this.cells = new HashSet<CellDisplay>();
        this.rows = -1;
        this.columns = -1;
        Iterator<ImageDisplay> j = this.wellNodes.iterator();
        HashMap<Integer, ColourObject> cMap = new HashMap<Integer, ColourObject>();
        HashMap<Integer, ColourObject> rMap = new HashMap<Integer, ColourObject>();
        this.validWells = new ArrayList<WellGridElement>();
        int minRow = -1;
        int minColumn = -1;
        while (j.hasNext()) {
            ColourObject newco;
            Color color;
            WellImageSet wellImageSet = (WellImageSet)j.next();
            int row = wellImageSet.getRow();
            int column = wellImageSet.getColumn();
            WellData data = (WellData)wellImageSet.getHierarchyObject();
            String type = data.getWellType();
            if (cMap.containsKey(column)) {
                co = (ColourObject)cMap.get(column);
                color = this.createColor(data);
                if (!UIUtilities.isSameColors(co.color, color, true) || !this.isSameDescription(co.description, type)) {
                    co.color = null;
                    co.description = null;
                    cMap.put(column, co);
                }
            } else {
                newco = new ColourObject();
                newco.color = this.createColor(data);
                newco.description = type;
                cMap.put(column, newco);
            }
            if (rMap.containsKey(row)) {
                co = (ColourObject)rMap.get(row);
                color = this.createColor(data);
                if (!UIUtilities.isSameColors(co.color, color, true) || !this.isSameDescription(co.description, type)) {
                    co.color = null;
                    co.description = null;
                    rMap.put(row, co);
                }
            } else {
                newco = new ColourObject();
                newco.color = this.createColor(data);
                newco.description = type;
                rMap.put(row, newco);
            }
            if (row > this.rows) {
                this.rows = row;
            }
            if (column > this.columns) {
                this.columns = column;
            }
            if (minRow < 0 || minRow > row) {
                minRow = row;
            }
            if (minColumn < 0 || minColumn > column) {
                minColumn = column;
            }
            columnSequence = "";
            if (this.columnSequenceIndex == 1) {
                columnSequence = UIUtilities.LETTERS.get(column + 1);
            } else if (this.columnSequenceIndex == 0) {
                columnSequence = "" + (column + 1);
            }
            rowSequence = "";
            if (this.rowSequenceIndex == 1) {
                rowSequence = UIUtilities.LETTERS.get(row + 1);
            } else if (this.rowSequenceIndex == 0) {
                rowSequence = "" + (row + 1);
            }
            wellImageSet.setCellDisplay((String)columnSequence, (String)rowSequence);
            int f = wellImageSet.getNumberOfSamples();
            if (this.fieldsNumber < f) {
                this.fieldsNumber = f;
            }
            wellImageSet.setSelectedWellSample(this.defaultFieldIndex);
            ImageNode selected = wellImageSet.getSelectedWellSample();
            wellImageSet.formatWellSampleTitle();
            samples.add(selected);
            boolean b = false;
            if (wellImageSet.isSampleValid()) {
                this.wellDimension = selected.getThumbnail().getOriginalSize();
                b = true;
            }
            this.validWells.add(new WellGridElement(row, column, b));
        }
        if (minRow >= 0 || minColumn >= 0) {
            for (WellImageSet wellImageSet : this.wellNodes) {
                if (minRow > 0) {
                    wellImageSet.setIndentRow(minRow);
                }
                if (minColumn > 0) {
                    wellImageSet.setIndentColumn(minColumn);
                }
                if (wellImageSet.getRow() != minRow && wellImageSet.getColumn() != minColumn) continue;
                wellImageSet.formatWellSampleTitle();
            }
        }
        ++this.columns;
        ++this.rows;
        for (k = 1; k <= this.columns; ++k) {
            columnSequence = "";
            if (this.columnSequenceIndex == 1) {
                columnSequence = UIUtilities.LETTERS.get(k + 1);
            } else if (this.columnSequenceIndex == 0) {
                columnSequence = "" + k;
            }
            cell = new CellDisplay(k - 1, (String)columnSequence);
            co = (ColourObject)cMap.get(k - 1);
            if (co == null) continue;
            cell.setHighlight(co.color);
            cell.setDescription(co.description != null ? co.description : "");
        }
        for (k = 1; k <= this.rows; ++k) {
            rowSequence = "";
            if (this.rowSequenceIndex == 1) {
                rowSequence = UIUtilities.LETTERS.get(k);
            } else if (this.rowSequenceIndex == 0) {
                rowSequence = "" + k;
            }
            cell = new CellDisplay(k - 1, (String)rowSequence, 0);
            co = (ColourObject)rMap.get(k - 1);
            if (co == null) continue;
            cell.setHighlight(co.color);
            cell.setDescription(co.description != null ? co.description : "");
        }
        this.browser = BrowserFactory.createBrowser(samples);
        this.browser.accept(new DecoratorVisitor(this.getCurrentUser().getId()));
        this.layoutBrowser(3);
        if (this.wellDimension == null) {
            this.wellDimension = new Dimension(96, 96);
        }
    }

    void clearThumbnails(Collection ids) {
        for (ImageDisplay i : this.wellNodes) {
            WellImageSet wi = (WellImageSet)i;
            for (WellSampleNode n : wi.getWellSamples()) {
                WellSampleData wsd = (WellSampleData)n.getHierarchyObject();
                if (!CollectionUtils.isEmpty((Collection)ids) && !ids.contains(wsd.getImage().getId())) continue;
                n.getThumbnail().flush();
            }
        }
    }

    int getColumnSequenceIndex() {
        if (this.columnSequenceIndex == 1) {
            return 0;
        }
        return 1;
    }

    int getRowSequenceIndex() {
        if (this.rowSequenceIndex == 1) {
            return 0;
        }
        return 1;
    }

    List<WellGridElement> getValidWells() {
        return this.validWells;
    }

    int getFieldsNumber() {
        return this.fieldsNumber;
    }

    int getDefaultFieldIndex() {
        return this.defaultFieldIndex;
    }

    void setSelectedWell(WellSampleNode node) {
        this.setSelectedWells(Arrays.asList(node));
    }

    void setSelectedWells(List<WellSampleNode> nodes) {
        this.selectedNodes.clear();
        if (!CollectionUtils.isEmpty(nodes)) {
            this.selectedNodes.addAll(nodes);
        }
    }

    WellSampleNode getSelectedWell() {
        if (CollectionUtils.isEmpty(this.selectedNodes)) {
            return null;
        }
        return this.selectedNodes.get(0);
    }

    List<WellSampleNode> getSelectedWells() {
        return this.selectedNodes;
    }

    void viewField(int index) {
        WellSampleNode selected;
        if (index < 0 || index >= this.fieldsNumber) {
            return;
        }
        this.defaultFieldIndex = index;
        HashSet<ImageDisplay> samples = new HashSet<ImageDisplay>();
        List<ImageDisplay> l = this.getNodes();
        Iterator<ImageDisplay> i = l.iterator();
        int row = -1;
        int col = -1;
        Collection<ImageDisplay> c = this.browser.getSelectedDisplays();
        HashMap<Integer, Integer> location = new HashMap<Integer, Integer>();
        if (c != null && c.size() > 0) {
            for (ImageDisplay object : c) {
                if (!(object instanceof WellSampleNode)) continue;
                selected = (WellSampleNode)object;
                location.put(selected.getRow(), selected.getColumn());
            }
        }
        ArrayList<ImageDisplay> nodes = new ArrayList<ImageDisplay>();
        while (i.hasNext()) {
            WellImageSet well = (WellImageSet)i.next();
            well.setSelectedWellSample(index);
            selected = (WellSampleNode)well.getSelectedWellSample();
            row = selected.getRow();
            if (location.containsKey(row)) {
                col = (Integer)location.get(row);
                if (selected.getColumn() == col) {
                    nodes.add(selected);
                }
            }
            samples.add(selected);
        }
        samples.addAll(this.cells);
        this.browser.refresh(samples, nodes);
        this.layoutBrowser(3);
        PlateData plate = (PlateData)this.parent;
        long userID = DataBrowserAgent.getUserDetails().getId();
        if (plate.getOwner().getId() == userID) {
            plate.setDefaultSample(this.defaultFieldIndex);
            ArrayList<DataObject> list = new ArrayList<DataObject>();
            list.add(plate);
            PlateSaver loader = new PlateSaver(this.component, this.ctx, list);
            ((DataBrowserLoader)loader).load();
        }
    }

    @Override
    void setTabularData(List<TableResult> data) {
        List<ImageDisplay> nodes = this.getNodes();
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        for (WellImageSet wellImageSet : nodes) {
            wellImageSet.setTabularData(data);
        }
    }

    void setSelectedCell(CellDisplay cell) {
        if (cell == null) {
            return;
        }
        ArrayList<DataObject> results = new ArrayList<DataObject>();
        List<ImageDisplay> l = this.getNodes();
        Iterator<ImageDisplay> i = l.iterator();
        int index = cell.getIndex();
        if (cell.getType() == 1) {
            while (i.hasNext()) {
                WellImageSet well = (WellImageSet)i.next();
                if (well.getColumn() != index) continue;
                this.handleCellSelection(cell, well, results);
            }
        } else {
            while (i.hasNext()) {
                WellImageSet well = (WellImageSet)i.next();
                if (well.getRow() != index) continue;
                this.handleCellSelection(cell, well, results);
            }
        }
        if (results.size() > 0) {
            PlateSaver loader = new PlateSaver(this.component, this.ctx, results);
            ((DataBrowserLoader)loader).load();
        }
    }

    int getRows() {
        return this.rows;
    }

    int getColumns() {
        return this.columns;
    }

    WellImageSet getWell(int row, int column) {
        List<ImageDisplay> l = this.getNodes();
        for (WellImageSet wellImageSet : l) {
            if (wellImageSet.getColumn() != column || wellImageSet.getRow() != row) continue;
            return wellImageSet;
        }
        return null;
    }

    DataBrowserLoader createFieldsLoader(List<Point> fields) {
        List<ImageDisplay> l = this.getNodes();
        Iterator<ImageDisplay> i = l.iterator();
        HashMultimap images = HashMultimap.create();
        while (i.hasNext()) {
            ImageSet node = (ImageSet)i.next();
            if (!(node instanceof WellImageSet)) continue;
            WellImageSet wis = (WellImageSet)node;
            Point targetField = null;
            for (Point p : fields) {
                if ((double)wis.getRow() != p.getX() || (double)wis.getColumn() != p.getY()) continue;
                targetField = p;
                break;
            }
            if (targetField == null) continue;
            List<WellSampleNode> nodes = wis.getWellSamples();
            for (WellSampleNode n : nodes) {
                WellSampleData data = (WellSampleData)n.getHierarchyObject();
                if (data.getId() < 0L) {
                    Thumbnail thumb = n.getThumbnail();
                    thumb.setValid(false);
                    thumb.setFullScaleThumb(Factory.createDefaultImageThumbnail(this.wellDimension.width, this.wellDimension.height));
                    continue;
                }
                images.put((Object)targetField, (Object)data.getImage());
            }
        }
        if (images.size() == 0) {
            return null;
        }
        return new ThumbnailFieldsLoader(this.component, this.ctx, (Multimap<Point, ImageData>)images);
    }

    @Override
    protected List<DataBrowserLoader> createDataLoader(boolean refresh, Collection ids) {
        if (!this.withThumbnails) {
            return null;
        }
        List<ImageDisplay> l = this.getNodes();
        Iterator<ImageDisplay> i = l.iterator();
        ArrayList<ImageData> images = new ArrayList<ImageData>();
        while (i.hasNext()) {
            ImageSet node = (ImageSet)i.next();
            if (!(node instanceof WellImageSet)) continue;
            ImageNode selected = ((WellImageSet)node).getSelectedWellSample();
            WellSampleData data = (WellSampleData)selected.getHierarchyObject();
            if (data.getId() < 0L) {
                Thumbnail thumb = selected.getThumbnail();
                thumb.setValid(false);
                thumb.setFullScaleThumb(Factory.createDefaultImageThumbnail(this.wellDimension.width, this.wellDimension.height));
                continue;
            }
            ImageData img = data.getImage();
            if (!CollectionUtils.isEmpty((Collection)ids) && !ids.contains(img.getId())) continue;
            images.add(data.getImage());
        }
        if (images.size() == 0) {
            return null;
        }
        return this.createThumbnailsLoader(this.sorter.sort(images));
    }

    @Override
    protected int getType() {
        return 5;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return this.wellNodes;
    }
}

