/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class DataComponent
extends JComponent
implements DocumentListener {
    public static final Border EDIT_BORDER = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
    public static final String DATA_MODIFIED_PROPERTY = "dataModified";
    private JLabel label;
    private JComponent area;
    private boolean setField;
    private boolean dirty = false;
    private Object value;

    private Object getValue() {
        if (this.area instanceof JComboBox) {
            JComboBox c = (JComboBox)this.area;
            return c.getSelectedItem();
        }
        if (this.area instanceof JTextComponent) {
            JTextComponent c = (JTextComponent)this.area;
            return c.getText();
        }
        return null;
    }

    private void notifyDataToSave() {
        this.dirty = true;
        Object v = this.getValue();
        if (this.value != null && this.value.equals(v)) {
            this.dirty = false;
        }
        this.firePropertyChange(DATA_MODIFIED_PROPERTY, (Object)(!this.dirty ? 1 : 0), (Object)this.dirty);
    }

    public DataComponent(JLabel label, JComponent area) {
        this.label = label;
        this.area = area;
        this.setField = true;
        label.setLabelFor(area);
        this.value = this.getValue();
    }

    public void setSetField(boolean setField) {
        this.setField = setField;
        if (!setField && this.area instanceof JTextComponent) {
            this.area.setBorder(EDIT_BORDER);
        }
    }

    public boolean isSetField() {
        return this.setField;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public JComponent getArea() {
        if (this.area instanceof JComboBox) {
            JPanel p = UIUtilities.buildComponentPanel(this.area, 0, 0);
            p.setBackground(this.area.getBackground());
            return p;
        }
        return this.area;
    }

    public Object getAreaValue() {
        return this.getValue();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void attachListener(PropertyChangeListener listener) {
        this.addPropertyChangeListener(listener);
        if (this.area instanceof JComboBox) {
            JComboBox c = (JComboBox)this.area;
            c.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataComponent.this.notifyDataToSave();
                }
            });
        } else if (this.area instanceof JTextComponent) {
            JTextComponent c = (JTextComponent)this.area;
            c.getDocument().addDocumentListener(this);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.area.setEnabled(enabled);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.notifyDataToSave();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.notifyDataToSave();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }
}

