/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.targets;

import ome.formats.importer.targets.ImportTarget;
import ome.formats.importer.targets.ModelImportTarget;
import ome.formats.importer.targets.TemplateImportTarget;
import omero.model.IObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetBuilder {
    private static final Logger log = LoggerFactory.getLogger(TargetBuilder.class);
    private String target;
    private Class<? extends ImportTarget> type;

    public TargetBuilder parse(String string) {
        String prefix;
        if (this.target != null) {
            throw new IllegalStateException(String.format("Only one target supported: old=%s new=%s", this.target, string));
        }
        this.target = string;
        int firstColon = string.indexOf(":");
        if (firstColon >= 0) {
            prefix = string.substring(0, firstColon);
            Class<?> klass = this.tryClass(prefix);
            if (klass != null) {
                if (ImportTarget.class.isAssignableFrom(klass)) {
                    this.type = klass;
                    return this;
                }
                if (IObject.class.isAssignableFrom(klass)) {
                    this.type = ModelImportTarget.class;
                    return this;
                }
            }
            if ((klass = this.tryClass("omero.model." + prefix)) != null && IObject.class.isAssignableFrom(klass)) {
                this.type = ModelImportTarget.class;
                return this;
            }
        } else {
            throw new IllegalStateException(String.format("Target string not valid: %s", string));
        }
        if (!prefix.equals("regex") && !prefix.equals("")) {
            throw new IllegalStateException(String.format("Target string not valid: %s", string));
        }
        this.type = TemplateImportTarget.class;
        return this;
    }

    public ImportTarget build() {
        ImportTarget inst = null;
        try {
            inst = this.type.newInstance();
        }
        catch (Exception e) {
            log.warn("Failed to instantiate for: {}", (Object)this.target, (Object)e);
            throw new RuntimeException("Could not create ImportTarget: " + this.target, e);
        }
        inst.init(this.target);
        return inst;
    }

    protected Class<?> tryClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException e) {
            log.debug(e.getMessage());
            return null;
        }
    }
}

