/*
 * Decompiled with CFR 0.152.
 */
package ome.system.utests;

import ome.system.UpgradeCheck;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UpgradeCheckTest {
    String version = "1.2.3";
    UpgradeCheck check;

    @Test
    public void testNoActionOnNull() {
        this.check = new UpgradeCheck(null, this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertFalse((boolean)this.check.isExceptionThrown());
    }

    @Test
    public void testNoActionOnEmpty() {
        this.check = new UpgradeCheck("", this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertFalse((boolean)this.check.isExceptionThrown());
    }

    @Test
    public void testSlowResponse() {
        this.check = new UpgradeCheck("http://127.0.0.1:8000", this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertTrue((boolean)this.check.isExceptionThrown());
    }

    @Test
    public void testSlowResponse2() {
        this.check = new UpgradeCheck("http://127.0.0.1:9998", this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertTrue((boolean)this.check.isExceptionThrown());
    }

    @Test
    public void testBadIp() {
        this.check = new UpgradeCheck("200.200.200.200", this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertTrue((boolean)this.check.isExceptionThrown());
    }

    @Test
    public void testWrongVersion() {
        this.check = new UpgradeCheck("200.200.200.200", "XYZ" + this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertTrue((boolean)this.check.isExceptionThrown());
    }

    @Test(enabled=false)
    public void testBadUrl1() {
        this.check = new UpgradeCheck("http://foo", "XYZ" + this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertTrue((boolean)this.check.isExceptionThrown());
    }

    @Test
    public void testBadUrl2() {
        this.check = new UpgradeCheck("file://dev/null", "XYZ" + this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertTrue((boolean)this.check.isExceptionThrown());
    }

    @Test
    public void testBadUrl3() {
        this.check = new UpgradeCheck("abcp", "XYZ" + this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertTrue((boolean)this.check.isExceptionThrown());
    }

    @Test
    public void testBadUrl4() {
        this.check = new UpgradeCheck("abc://bar", "XYZ" + this.version, "test");
        this.check.run();
        Assert.assertFalse((boolean)this.check.isUpgradeNeeded());
        Assert.assertTrue((boolean)this.check.isExceptionThrown());
    }
}

