/*
 * Decompiled with CFR 0.152.
 */
package ome.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import ome.api.IAdmin;
import ome.api.IQuery;
import ome.api.IUpdate;
import ome.model.IObject;
import ome.model.annotations.DatasetAnnotationLink;
import ome.model.annotations.ImageAnnotationLink;
import ome.model.annotations.TagAnnotation;
import ome.model.containers.Dataset;
import ome.model.containers.DatasetImageLink;
import ome.model.containers.Project;
import ome.model.containers.ProjectDatasetLink;
import ome.model.core.Image;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.system.EventContext;
import ome.system.Login;
import ome.system.ServiceFactory;
import ome.util.ShallowCopy;

public class CreatePojosFixture {
    protected IAdmin iAdmin;
    protected IQuery iQuery;
    protected IUpdate iUpdate;
    protected boolean init = false;
    protected List<IObject> toAdd = new ArrayList<IObject>();
    protected List<IObject> needId = new ArrayList<IObject>();
    public String TESTER;
    public Experimenter e;
    public ExperimenterGroup g;
    public Project pr9090;
    public Project pr9091;
    public Project pr9092;
    public Project pu9990;
    public Project pu9991;
    public Project pu9992;
    public Dataset dr7070;
    public Dataset dr7071;
    public Dataset dr7072;
    public Dataset du7770;
    public Dataset du7771;
    public Dataset du7772;
    public Image ir5050;
    public Image ir5051;
    public Image ir5052;
    public Image iu5550;
    public Image iu5551;
    public Image iu5552;
    public Image iu5580;
    public Image iu5581;
    public Image iu5582;
    public Image iu5583;
    public Image iu5584;
    public Image iu5585;
    public Image iu5586;
    public Image iu5587;
    public Image iu5588;

    public static CreatePojosFixture withNewUser(ServiceFactory sf) {
        CreatePojosFixture fixture = new CreatePojosFixture();
        IAdmin rootAdmin = sf.getAdminService();
        String G_NAME = UUID.randomUUID().toString();
        fixture.g = new ExperimenterGroup();
        fixture.g.setName(G_NAME);
        fixture.g.setLdap(false);
        fixture.g = new ExperimenterGroup(rootAdmin.createGroup(fixture.g), false);
        fixture.TESTER = "TESTER-" + UUID.randomUUID().toString();
        fixture.e = new Experimenter();
        fixture.e.setOmeName(fixture.TESTER);
        fixture.e.setFirstName("Mr.");
        fixture.e.setLastName("Allen");
        fixture.e.setLdap(false);
        fixture.e = new Experimenter(rootAdmin.createUser(fixture.e, G_NAME), false);
        Login testLogin = new Login(fixture.TESTER, "ome", G_NAME, "Test");
        ServiceFactory factory = new ServiceFactory(testLogin);
        fixture.setServices(factory);
        fixture.init = true;
        return fixture;
    }

    private CreatePojosFixture() {
    }

    public CreatePojosFixture(ServiceFactory factory) {
        this.setServices(factory);
        EventContext ec = this.iAdmin.getEventContext();
        this.e = new Experimenter(ec.getCurrentUserId(), false);
        this.g = new ExperimenterGroup(ec.getCurrentGroupId(), false);
        this.TESTER = ec.getCurrentUserName();
        this.init = true;
    }

    private void setServices(ServiceFactory factory) {
        this.iAdmin = factory.getAdminService();
        this.iQuery = factory.getQueryService();
        this.iUpdate = factory.getUpdateService();
    }

    public void createAllPojos() throws Exception {
        this.init();
        this.projects();
        this.datasets();
        this.pdlinks();
        this.images();
        this.dilinks();
        this.annotations();
    }

    public void deleteAllPojos() throws Exception {
        for (int i = this.toAdd.size() - 1; i >= 0; --i) {
            this.iUpdate.deleteObject(this.toAdd.get(i));
        }
        this.iAdmin.deleteExperimenter(this.e);
    }

    public void init() {
        if (!this.init) {
            // empty if block
        }
    }

    public void pdi() {
        this.projects();
        this.datasets();
        this.images();
        this.pdlinks();
        this.dilinks();
    }

    public void projects() {
        this.init();
        this.pr9090 = this.project(null, "root project without links");
        this.pr9091 = this.project(null, "root project with own annotations");
        this.pr9092 = this.project(null, "root project with foreign annotations");
        this.pu9990 = this.project(this.e, "user project without links");
        this.pu9991 = this.project(this.e, "user project with own annotations");
        this.pu9992 = this.project(this.e, "user project with foreign annotations");
        this.saveAndClear();
    }

    public void datasets() {
        this.init();
        this.dr7070 = this.dataset(null, "root dataset without links");
        this.dr7071 = this.dataset(null, "root dataset with own annotations");
        this.dr7072 = this.dataset(null, "root dataset with foreign annotations");
        this.du7770 = this.dataset(this.e, "user dataset without links");
        this.du7771 = this.dataset(this.e, "user dataset with own annotations");
        this.du7772 = this.dataset(this.e, "user dataset with foreign annotations");
        this.saveAndClear();
    }

    public void pdlinks() {
        this.init();
        this.pdlink(this.pr9091, this.dr7071);
        this.pdlink(this.pr9092, this.dr7071);
        this.pdlink(this.pr9091, this.dr7072);
        this.pdlink(this.pr9092, this.dr7072);
        this.pdlink(this.pu9991, this.du7771);
        this.pdlink(this.pu9992, this.du7771);
        this.pdlink(this.pu9991, this.du7772);
        this.pdlink(this.pu9992, this.du7772);
        this.saveAndClear();
    }

    public void images() {
        this.init();
        this.ir5050 = this.image(null, "");
        this.ir5051 = this.image(null, "");
        this.ir5052 = this.image(null, "");
        this.iu5550 = this.image(this.e, "");
        this.iu5551 = this.image(this.e, "");
        this.iu5552 = this.image(this.e, "");
        this.iu5580 = this.image(this.e, "");
        this.iu5581 = this.image(this.e, "");
        this.iu5582 = this.image(this.e, "");
        this.iu5583 = this.image(this.e, "");
        this.iu5584 = this.image(this.e, "");
        this.iu5585 = this.image(this.e, "");
        this.iu5586 = this.image(this.e, "");
        this.iu5587 = this.image(this.e, "");
        this.iu5588 = this.image(this.e, "");
        this.saveAndClear();
    }

    public void dilinks() {
        this.init();
        this.dilink(null, this.dr7071, this.ir5051);
        this.dilink(null, this.dr7071, this.ir5052);
        this.dilink(this.e, this.dr7072, this.ir5051);
        this.dilink(this.e, this.dr7072, this.ir5052);
        this.dilink(null, this.du7771, this.iu5551);
        this.dilink(null, this.du7771, this.iu5552);
        this.dilink(this.e, this.du7772, this.iu5551);
        this.dilink(this.e, this.du7772, this.iu5552);
        this.saveAndClear();
    }

    public void annotations() {
        this.init();
        this.datasetann(null, this.dr7071, "roots annotation");
        this.datasetann(this.e, this.dr7072, "users annotation");
        this.datasetann(null, this.du7771, "roots annotation");
        this.datasetann(this.e, this.du7772, "users annotation");
        this.imageann(null, this.ir5051, "roots annotation");
        this.imageann(this.e, this.ir5052, "users annotation");
        this.imageann(null, this.iu5551, "roots annotation");
        this.imageann(this.e, this.iu5552, "users annotation");
        this.saveAndClear();
    }

    protected <T extends IObject> T push(T obj) {
        this.toAdd.add(obj);
        T copy = new ShallowCopy().copy(obj);
        copy.unload();
        this.needId.add(copy);
        return copy;
    }

    protected void saveAndClear() {
        IObject[] retVal = this.iUpdate.saveAndReturnArray(this.toAdd.toArray(new IObject[this.toAdd.size()]));
        IObject[] unloaded = this.needId.toArray(new IObject[this.needId.size()]);
        for (int i = 0; i < retVal.length; ++i) {
            unloaded[i].setId(retVal[i].getId());
        }
        this.toAdd.clear();
        this.needId.clear();
    }

    protected Project project(Experimenter owner, String name) {
        Project p = new Project();
        p.getDetails().setOwner(owner);
        p.setName(name);
        p = this.push(p);
        return p;
    }

    protected Dataset dataset(Experimenter owner, String name) {
        Dataset d = new Dataset();
        d.getDetails().setOwner(owner);
        d.setName(name);
        d = this.push(d);
        return d;
    }

    protected ProjectDatasetLink pdlink(Project prj, Dataset ds) {
        ProjectDatasetLink link = new ProjectDatasetLink();
        link.link(prj, ds);
        link = this.push(link);
        return link;
    }

    protected Image image(Experimenter e, String name) {
        Image i = new Image();
        i.getDetails().setOwner(e);
        i.setName(name);
        i = this.push(i);
        return i;
    }

    protected DatasetImageLink dilink(Experimenter user, Dataset ds, Image i) {
        DatasetImageLink link = new DatasetImageLink();
        link.link(ds, i);
        link.getDetails().setOwner(user);
        link = this.push(link);
        return link;
    }

    protected DatasetAnnotationLink datasetann(Experimenter user, Dataset d, String name) {
        TagAnnotation dann = new TagAnnotation();
        dann.setNs(name);
        dann.getDetails().setOwner(user);
        DatasetAnnotationLink link = new DatasetAnnotationLink();
        link.link(d.proxy(), dann);
        link = this.push(link);
        return link;
    }

    protected ImageAnnotationLink imageann(Experimenter user, Image i, String name) {
        TagAnnotation iann = new TagAnnotation();
        iann.setNs(name);
        iann.getDetails().setOwner(user);
        ImageAnnotationLink link = new ImageAnnotationLink();
        link.link(i.proxy(), iann);
        link = this.push(link);
        return link;
    }

    public List<Long> asIdList(IObject ... iobjs) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (IObject i : iobjs) {
            list.add(i.getId());
        }
        return list;
    }
}

