/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.util.Collection;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ThumbnailLoader
extends DataBrowserLoader {
    public static final int EXPERIMENTER = 1;
    public static final int FS_FILE = 2;
    public static final int IMAGE = 0;
    private int max;
    private Collection<DataObject> objects;
    private int type;
    private boolean thumbnail;
    private CallHandle handle;

    public ThumbnailLoader(DataBrowser viewer, SecurityContext ctx, Collection<DataObject> objects, int type, int max) {
        this(viewer, ctx, objects, true, type, max);
    }

    public ThumbnailLoader(DataBrowser viewer, SecurityContext ctx, Collection<DataObject> objects, int max) {
        this(viewer, ctx, objects, true, 0, max);
    }

    public ThumbnailLoader(DataBrowser viewer, SecurityContext ctx, Collection<DataObject> objects, boolean thumbnail, int type, int max) {
        super(viewer, ctx);
        if (objects == null) {
            throw new IllegalArgumentException("Collection shouldn't be null.");
        }
        this.type = type < 0 ? 0 : type;
        this.objects = objects;
        this.thumbnail = thumbnail;
        if (max < objects.size()) {
            max = objects.size();
        }
        this.max = max;
    }

    @Override
    public void load() {
        long userID = -1L;
        this.handle = this.thumbnail ? this.hiBrwView.loadThumbnails(this.ctx, this.objects, 96, 96, userID, this.type, this) : this.hiBrwView.loadThumbnails(this.ctx, this.objects, 288, 288, userID, this.type, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        if (this.viewer.getState() == 5) {
            return;
        }
        String status = fe.getStatus();
        int percDone = fe.getPercentDone();
        if (this.thumbnail) {
            if (status == null) {
                String string = status = percDone == 100 ? "Done" : "";
            }
            if (this.type == 1) {
                List l = (List)fe.getPartialResult();
                if (!CollectionUtils.isEmpty((Collection)l)) {
                    for (ThumbnailData td : l) {
                        Object ref = td.getRefObject();
                        if (ref == null) {
                            ref = td.getImageID();
                        }
                        this.viewer.setThumbnail(ref, td.getThumbnail(), td.isValidImage(), this.max);
                    }
                }
            } else {
                ThumbnailData td = (ThumbnailData)fe.getPartialResult();
                if (td != null) {
                    Object ref = td.getRefObject();
                    if (ref == null) {
                        ref = td.getImageID();
                    }
                    this.viewer.setThumbnail(ref, td.getThumbnail(), td.isValidImage(), this.max);
                }
            }
        } else {
            if (status == null) {
                status = percDone == 100 ? "Done" : "";
            }
            this.viewer.setSlideViewStatus(status, percDone);
            ThumbnailData td = (ThumbnailData)fe.getPartialResult();
            if (td != null) {
                Object ref = td.getRefObject();
                if (ref == null) {
                    ref = td.getImageID();
                }
                this.viewer.setSlideViewImage(td.getImageID(), td.getThumbnail());
            }
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void onEnd() {
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Thumbnail Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Thumbnail Retrieval Failure", s, exc);
    }
}

