/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter;

import java.util.Collection;
import omero.gateway.SecurityContext;
import omero.gateway.model.TagAnnotationData;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.fsimporter.DataImporterLoader;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.event.AgentEventListener;

public class TagsLoader
extends DataImporterLoader {
    private CallHandle handle;
    private boolean loadAll;

    public TagsLoader(Importer viewer, SecurityContext ctx, boolean loadAll) {
        super(viewer, ctx);
        this.loadAll = loadAll;
    }

    @Override
    public void load() {
        long userID = this.getCurrentUserID();
        if (this.loadAll) {
            userID = -1L;
        }
        this.handle = this.mhView.loadExistingAnnotations(this.ctx, TagAnnotationData.class, userID, (AgentEventListener)this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 3) {
            return;
        }
        this.viewer.setExistingTags((Collection)result);
    }

    @Override
    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
    }
}

