/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout;

import java.io.File;
import java.util.List;
import java.util.UUID;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleTreeElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.ModuleContentParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExportAsTemplateFile {
    String fName;

    public ExportAsTemplateFile(String fileName) {
        this.fName = fileName;
    }

    public void export(DefaultMutableTreeNode tree, List<String> filter) {
        Document doc = this.generateXML(tree, filter);
        if (doc != null) {
            this.saveXML(doc, this.fName);
        }
    }

    private void saveXML(Document doc, String fileName) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource domSource = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(new File(fileName));
            transformer.transform(domSource, streamResult);
        }
        catch (TransformerConfigurationException e) {
            String s = "[MDE] can't saveXML ";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        catch (TransformerException e) {
            String s = "[MDE] saveXML ";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
        }
    }

    private Document generateXML(DefaultMutableTreeNode tree, List<String> filter) {
        Document document = null;
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element rootElem = document.createElement("MDETemplate");
            document.appendChild(rootElem);
            this.generateRoot_XMLElem(tree, document, filter, rootElem);
        }
        catch (Exception e) {
            String s = "[MDE] Cannot generate template xml";
            LogMessage msg = new LogMessage();
            msg.print(s);
            msg.print((Throwable)e);
            ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
        }
        return document;
    }

    private void generateRoot_XMLElem(DefaultMutableTreeNode node, Document document, List<String> filter, Element rootElem) {
        if (node == null) {
            return;
        }
        if ((ModuleTreeElement)node.getUserObject() != null) {
            String objectType = ((ModuleTreeElement)node.getUserObject()).getType();
            if (objectType.equals("OME-Model")) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.generateRoot_XMLElem((DefaultMutableTreeNode)node.getChildAt(i), document, filter, rootElem);
                }
            } else {
                Element objPre = this.generateObjectPre_XMLElem(node, document, filter, rootElem);
                if (objPre != null) {
                    Element rootObj = document.createElement("ObjectTreeRoot");
                    rootObj.setAttribute("ID", String.valueOf(((ModuleTreeElement)node.getUserObject()).getChildIndex()));
                    rootObj.setAttribute("Type", objectType);
                    rootObj.setAttribute("UUID", objPre.getAttribute("UUID"));
                    rootElem.appendChild(rootObj);
                    rootElem.appendChild(objPre);
                }
            }
        }
    }

    private Element generateObjectPre_XMLElem(DefaultMutableTreeNode node, Document doc, List<String> filter, Element root) {
        if (node == null) {
            return null;
        }
        String objectType = ((ModuleTreeElement)node.getUserObject()).getType();
        if (!ModuleController.getInstance().configurationExists(objectType)) {
            return null;
        }
        ModuleContentParser mc_parser = new ModuleContentParser();
        Element nodeObj = mc_parser.createXMLElem(((ModuleTreeElement)node.getUserObject()).getData(), String.valueOf(((ModuleTreeElement)node.getUserObject()).getChildIndex()), doc, "ObjectPre", filter.contains(objectType));
        nodeObj.setAttribute("UUID", String.valueOf(this.generateUniqueID()));
        if (nodeObj != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Element childObj = this.generateObjectPre_XMLElem((DefaultMutableTreeNode)node.getChildAt(i), doc, filter, root);
                if (childObj == null) continue;
                nodeObj.appendChild(this.generateChild_XMLElem(childObj, doc));
                root.appendChild(childObj);
            }
            root.appendChild(nodeObj);
        }
        return nodeObj;
    }

    private Element generateChild_XMLElem(Element childObj, Document doc) {
        Element child = doc.createElement("ObjectChild");
        child.setAttribute("UUID", childObj.getAttribute("UUID"));
        child.setAttribute("ID", childObj.getAttribute("ID"));
        child.setAttribute("Type", childObj.getAttribute("Type"));
        return child;
    }

    private String generateUniqueID() {
        UUID idOne = UUID.randomUUID();
        return idOne.toString();
    }
}

