/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util.player;

import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;

public abstract class Player
implements ActionListener,
ChangeListener {
    public static final int START = 0;
    public static final int STOP = 1;
    public static final int PAUSE = 2;
    protected static final int DELAY = 1000;
    protected static final int INITIAL_DELAY = 0;
    protected ImViewer model;
    protected Timer timer;
    protected int state;
    protected int historyState;
    protected int delay;

    protected abstract void onPlayerStateChange();

    public Player(ImViewer model) {
        if (model == null) {
            throw new IllegalArgumentException("Model cannot be null.");
        }
        this.model = model;
        this.state = -1;
        this.delay = 1000;
        model.addChangeListener(this);
        this.timer = new Timer(1000, this);
        this.timer.setInitialDelay(100);
        this.timer.setCoalesce(true);
    }

    public void setPlayerState(int state) {
        switch (state) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("State not supported.");
            }
        }
        if (this.state == state) {
            return;
        }
        this.historyState = this.state;
        this.state = state;
        this.onPlayerStateChange();
    }

    public void setDelay(int v) {
        if (v == 0) {
            return;
        }
        this.delay = 1000 / v;
        this.timer.setDelay(this.delay);
    }

    public int getState() {
        return this.state;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int s = this.model.getState();
        if (s == 7) {
            this.setPlayerState(1);
        } else if (s == 3) {
            if (this.state == 0) {
                this.timer.stop();
            }
        } else if (s == 6 && this.state == 0) {
            this.timer.start();
        }
    }
}

