/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import omero.gateway.SecurityContext;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.ChannelAcquisitionData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.FilesetData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageAcquisitionData;
import omero.gateway.model.ImageData;
import omero.gateway.model.InstrumentData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.PermissionData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.RatingAnnotationData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TextualAnnotationData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.gateway.model.XMLAnnotationData;
import omero.log.LogMessage;
import omero.model.OriginalFile;
import omero.model.PlaneInfo;
import omero.model.PlateAcquisition;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.metadata.AcquisitionDataLoader;
import org.openmicroscopy.shoola.agents.metadata.AnalysisResultsFileLoader;
import org.openmicroscopy.shoola.agents.metadata.AttachmentsLoader;
import org.openmicroscopy.shoola.agents.metadata.ChannelDataLoader;
import org.openmicroscopy.shoola.agents.metadata.ChannelDataSaver;
import org.openmicroscopy.shoola.agents.metadata.DiskSpaceLoader;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.EnumerationLoader;
import org.openmicroscopy.shoola.agents.metadata.FileAnnotationChecker;
import org.openmicroscopy.shoola.agents.metadata.FileLoader;
import org.openmicroscopy.shoola.agents.metadata.FilesetLoader;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.ImageSizeLoader;
import org.openmicroscopy.shoola.agents.metadata.InstrumentDataLoader;
import org.openmicroscopy.shoola.agents.metadata.LDAPLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.OriginalMetadataLoader;
import org.openmicroscopy.shoola.agents.metadata.PasswordEditor;
import org.openmicroscopy.shoola.agents.metadata.PlaneInfoLoader;
import org.openmicroscopy.shoola.agents.metadata.ROILoader;
import org.openmicroscopy.shoola.agents.metadata.RenderingControlLoader;
import org.openmicroscopy.shoola.agents.metadata.ScriptLoader;
import org.openmicroscopy.shoola.agents.metadata.ScriptsLoader;
import org.openmicroscopy.shoola.agents.metadata.TagsLoader;
import org.openmicroscopy.shoola.agents.metadata.UserPhotoLoader;
import org.openmicroscopy.shoola.agents.metadata.UserPhotoUploader;
import org.openmicroscopy.shoola.agents.metadata.browser.Browser;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.agents.metadata.editor.ImportType;
import org.openmicroscopy.shoola.agents.metadata.rnd.Renderer;
import org.openmicroscopy.shoola.agents.metadata.rnd.RendererFactory;
import org.openmicroscopy.shoola.agents.metadata.util.AnalysisResultsItem;
import org.openmicroscopy.shoola.agents.metadata.util.DataToSave;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.AnnotationLinkData;
import org.openmicroscopy.shoola.env.data.model.DeletableObject;
import org.openmicroscopy.shoola.env.data.model.DeleteActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadArchivedActivityParam;
import org.openmicroscopy.shoola.env.data.model.EnumerationObject;
import org.openmicroscopy.shoola.env.data.model.SaveAsParam;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.file.modulo.ModuloInfo;
import org.openmicroscopy.shoola.util.file.modulo.ModuloParser;
import org.openmicroscopy.shoola.util.ui.component.ObservableComponent;

class EditorModel {
    static long DEFAULT_MAX_EXPORT_SIZE = 144000000L;
    static final int ALL = 0;
    static final int ME = 1;
    static final int OTHER = 2;
    static final int DEFAULT_CHANNEL = 0;
    private static final List<String> EXCLUDED_FILE_NS = new ArrayList<String>();
    private MetadataViewer parent;
    private Editor component;
    private Object refObject;
    private Object parentRefObject;
    private Object gpRefObject;
    private Map<Long, List> textualAnnotationsByUsers;
    private List textualAnnotationsByDate;
    private List<EditorLoader> loaders;
    private Collection existingTags;
    private Collection existingAttachments;
    private Map emissionsWavelengths;
    private ViewerSorter sorter;
    private Browser browser;
    private ImageAcquisitionData imageAcquisitionData;
    private InstrumentData instrumentData;
    private Map<String, List<EnumerationObject>> channelEnumerations;
    private Map<String, List<EnumerationObject>> imageEnumerations;
    private Map<Integer, ChannelAcquisitionData> channelAcquisitionDataMap;
    private Map<Integer, Collection> channelPlaneInfoMap;
    private Renderer renderer;
    private List<AnnotationData> toDelete;
    private Map<Long, ScriptObject> scripts;
    private List<ScriptObject> scriptsWithUI;
    private FileAnnotationData originalMetadata;
    private Map<AnalysisResultsItem, EditorLoader> resultsLoader;
    private Map<Long, BufferedImage> usersPhoto;
    private boolean largeImage;
    private Collection<FilesetData> set;

    private void fireLargeImageLoading() {
        ImageData img = null;
        if (this.refObject instanceof ImageData) {
            img = (ImageData)this.refObject;
        } else if (this.refObject instanceof WellSampleData) {
            img = ((WellSampleData)this.refObject).getImage();
        }
        PixelsData data = img.getDefaultPixels();
        if (data == null) {
            this.largeImage = false;
            return;
        }
        ImageSizeLoader loader = new ImageSizeLoader(this.component, this.parent.getSecurityContext(), data.getId());
        loader.load();
    }

    private void downloadFiles(File folder, boolean override) {
        UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
        FileAnnotationData fa = (FileAnnotationData)this.getRefObject();
        OriginalFile f = (OriginalFile)fa.getContent();
        IconManager icons = IconManager.getInstance();
        DownloadActivityParam activity = new DownloadActivityParam(f, folder, icons.getIcon(76));
        un.notifyActivity(this.getSecurityContext(), activity);
        List l = this.parent.getRelatedNodes();
        if (l == null) {
            return;
        }
        for (Object o : l) {
            if (!(o instanceof FileAnnotationData)) continue;
            fa = (FileAnnotationData)o;
            f = (OriginalFile)fa.getContent();
            if (f.isLoaded()) {
                activity = new DownloadActivityParam(f, folder, icons.getIcon(76));
            } else {
                long id = fa.getId();
                Environment env = (Environment)MetadataViewerAgent.getRegistry().lookup("/env");
                Object path = env.getOmeroFilesHome();
                path = (String)path + File.separator + fa.getFileName();
                activity = new DownloadActivityParam(id, 1, new File((String)path), icons.getIcon(76));
            }
            activity.setFileName(fa.getFileName());
            un.notifyActivity(this.getSecurityContext(), activity);
        }
    }

    private void downloadImages(File file, boolean override) {
        ArrayList<DataObject> images = new ArrayList<DataObject>();
        List<DataObject> l = this.getSelectedObjects();
        if (!CollectionUtils.isEmpty(l)) {
            Iterator<DataObject> i = l.iterator();
            ArrayList<Long> filesetIds = new ArrayList<Long>();
            while (i.hasNext()) {
                DataObject o = i.next();
                if (!this.isArchived(o)) continue;
                ImageData image = (ImageData)o;
                long id = image.getFilesetId();
                if (id < 0L) {
                    images.add(image);
                    continue;
                }
                if (filesetIds.contains(id)) continue;
                images.add(image);
                filesetIds.add(id);
            }
        }
        if (!CollectionUtils.isEmpty(images)) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            IconManager icons = IconManager.getInstance();
            ImageIcon icon = icons.getIcon(76);
            SecurityContext ctx = this.getSecurityContext();
            DownloadArchivedActivityParam p = new DownloadArchivedActivityParam(file, images, icon);
            p.setOverride(override);
            un.notifyActivity(ctx, p);
        }
    }

    private void sortAnnotationByDate(List annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Timestamp t1 = ((AnnotationData)o1).getLastModified();
                Timestamp t2 = ((AnnotationData)o2).getLastModified();
                long n1 = t1.getTime();
                long n2 = t2.getTime();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                }
                return -v;
            }
        };
        Collections.sort(annotations, c);
    }

    private List sortPlane(Collection nodes) {
        ArrayList l = new ArrayList();
        if (nodes == null) {
            return l;
        }
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            l.add(i.next());
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                PlaneInfo i1 = (PlaneInfo)o1;
                PlaneInfo i2 = (PlaneInfo)o2;
                int t1 = i1.getTheT().getValue();
                int t2 = i2.getTheT().getValue();
                int v = 0;
                if (t1 < t2) {
                    v = -1;
                } else if (t1 > t2) {
                    v = 1;
                }
                return v;
            }
        };
        Collections.sort(l, c);
        return l;
    }

    private void sortEnumerations(List<EnumerationObject> enumerations) {
        if (enumerations == null || enumerations.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = ((EnumerationObject)o1).getValue();
                String s2 = ((EnumerationObject)o2).getValue();
                int v = 0;
                int result = s1.toLowerCase().compareTo(s2.toLowerCase());
                if (result < 0) {
                    v = -1;
                } else if (result > 0) {
                    v = 1;
                }
                return v;
            }
        };
        Collections.sort(enumerations, c);
    }

    private void fireExperimenterPhotoLoading() {
        if (this.refObject instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)this.refObject;
            if (this.usersPhoto == null || !this.usersPhoto.containsKey(exp.getId())) {
                UserPhotoLoader loader = new UserPhotoLoader(this.component, this.parent.getSecurityContext(), exp);
                loader.load();
            }
        }
    }

    private GroupData getGroup(long groupId) {
        Collection groups = MetadataViewerAgent.getAvailableUserGroups();
        if (groups == null) {
            return null;
        }
        for (GroupData group : groups) {
            if (group.getId() != groupId) continue;
            return group;
        }
        return null;
    }

    private boolean canRetrieveAll() {
        if (!MetadataViewerAgent.canCreate()) {
            return false;
        }
        if (!this.canAnnotate()) {
            return false;
        }
        GroupData group = this.getGroup(this.getRefObjectGroupID());
        if (group == null) {
            return false;
        }
        switch (group.getPermissions().getPermissionsLevel()) {
            case 1: {
                if (MetadataViewerAgent.isAdministrator()) {
                    return true;
                }
                Set<ExperimenterData> leaders = group.getLeaders();
                Iterator<ExperimenterData> i = leaders.iterator();
                long userID = this.getCurrentUser().getId();
                while (i.hasNext()) {
                    ExperimenterData exp = i.next();
                    if (exp.getId() != userID) continue;
                    return true;
                }
                return false;
            }
            case 0: {
                return false;
            }
        }
        return true;
    }

    private boolean canDeleteLink(Object data, StructuredDataResults result) {
        if (!(data instanceof DataObject)) {
            return false;
        }
        DataObject d = (DataObject)data;
        if (result == null) {
            return false;
        }
        Collection<AnnotationLinkData> links = result.getAnnotationLinks();
        if (links == null) {
            return false;
        }
        for (AnnotationLinkData link : links) {
            if (d.getId() != link.getChild().getId()) continue;
            return link.canDelete();
        }
        return false;
    }

    EditorModel(Object refObject, MetadataViewer parent) {
        if (refObject == null) {
            throw new IllegalArgumentException("No object set.");
        }
        this.parent = parent;
        this.refObject = refObject;
        this.loaders = new ArrayList<EditorLoader>();
        this.sorter = new ViewerSorter();
    }

    void deleteAnnotation(AnnotationData annotation) {
        if (annotation == null) {
            return;
        }
        if (this.toDelete == null) {
            this.toDelete = new ArrayList<AnnotationData>();
        }
        this.toDelete.add(annotation);
    }

    List<AnnotationData> getAnnotationToDelete() {
        return this.toDelete;
    }

    boolean isMultiSelection() {
        return !this.parent.isSingleMode();
    }

    ObservableComponent getObservable() {
        return this.parent;
    }

    void setBrowser(Browser browser) {
        this.browser = browser;
    }

    Browser getBrowser() {
        return this.browser;
    }

    void initialize(Editor component) {
        this.component = component;
    }

    boolean isPermissionsShowable() {
        Object ref = this.getRefObject();
        if (ref == null) {
            return false;
        }
        return ref instanceof ProjectData || ref instanceof DatasetData;
    }

    PermissionData getRefObjectPermissions() {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            return ((DataObject)ref).getPermissions();
        }
        return null;
    }

    String getRefObjectName() {
        return this.getObjectName(this.getPrimarySelect());
    }

    String getObjectName(Object ref) {
        String name = "";
        if (ref instanceof ImageData) {
            name = ((ImageData)ref).getName();
        } else if (ref instanceof DatasetData) {
            name = ((DatasetData)ref).getName();
        } else if (ref instanceof ProjectData) {
            name = ((ProjectData)ref).getName();
        } else if (ref instanceof TagAnnotationData || ref instanceof TermAnnotationData) {
            name = ((AnnotationData)ref).getContentAsString();
        } else if (ref instanceof ScreenData) {
            name = ((ScreenData)ref).getName();
        } else if (ref instanceof PlateData) {
            name = ((PlateData)ref).getName();
        } else if (ref instanceof PlateAcquisitionData) {
            name = ((PlateAcquisitionData)ref).getLabel();
        } else if (ref instanceof FileAnnotationData) {
            name = ((FileAnnotationData)ref).getFileName();
        } else if (ref instanceof WellSampleData) {
            WellSampleData ws = (WellSampleData)ref;
            ImageData img = ws.getImage();
            if (img != null && img.getId() >= 0L) {
                name = img.getName();
            }
        } else if (ref instanceof FileData) {
            name = ((FileData)ref).getName();
        }
        if (name == null) {
            return "";
        }
        return name.trim();
    }

    String getObjectTypeAsString(Object ref) {
        if (ref instanceof ImageData) {
            return "Image";
        }
        if (ref instanceof DatasetData) {
            return "Dataset";
        }
        if (ref instanceof ProjectData) {
            return "Project";
        }
        if (ref instanceof ScreenData) {
            return "Screen";
        }
        if (ref instanceof PlateData) {
            return "Plate";
        }
        if (this.refObject instanceof PlateAcquisitionData) {
            return "Plate Run";
        }
        if (this.refObject instanceof FileAnnotationData) {
            return "File";
        }
        if (this.refObject instanceof WellSampleData) {
            return "Field";
        }
        if (this.refObject instanceof WellData) {
            return "Well";
        }
        if (this.refObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)this.refObject;
            if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                return "Tag Set";
            }
            return "Tag";
        }
        if (this.refObject instanceof FileData) {
            FileData f = (FileData)this.refObject;
            if (f.isDirectory()) {
                return "Folder";
            }
            return "File";
        }
        if (this.refObject instanceof TermAnnotationData) {
            return "Term";
        }
        if (this.refObject instanceof XMLAnnotationData) {
            return "XML file";
        }
        if (this.refObject instanceof LongAnnotationData || this.refObject instanceof DoubleAnnotationData) {
            return "Numerical value";
        }
        if (this.refObject instanceof BooleanAnnotationData) {
            return "Boolean value";
        }
        return "";
    }

    String getRefObjectDescription() {
        String description = "";
        Object ref = this.getPrimarySelect();
        if (ref instanceof ImageData) {
            description = ((ImageData)ref).getDescription();
        } else if (ref instanceof DatasetData) {
            description = ((DatasetData)ref).getDescription();
        } else if (ref instanceof ProjectData) {
            description = ((ProjectData)ref).getDescription();
        } else if (ref instanceof ScreenData) {
            description = ((ScreenData)ref).getDescription();
        } else if (ref instanceof PlateData) {
            description = ((PlateData)ref).getDescription();
        } else if (ref instanceof PlateAcquisitionData) {
            description = ((PlateAcquisitionData)ref).getDescription();
        } else if (ref instanceof TagAnnotationData) {
            description = ((TagAnnotationData)ref).getTagDescription();
        } else if (ref instanceof WellData) {
            description = "";
        } else if (ref instanceof WellSampleData) {
            ImageData img = ((WellSampleData)ref).getImage();
            if (!CommonsLangUtils.isEmpty(img.getDescription())) {
                description = img.getDescription();
            }
        } else if (ref instanceof FileData) {
            description = null;
        }
        if (description == null) {
            return "";
        }
        return description.trim();
    }

    long getRefObjectID() {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            return ((DataObject)ref).getId();
        }
        return -1L;
    }

    long getRefObjectGroupID() {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            return ((DataObject)ref).getGroupId();
        }
        return -1L;
    }

    boolean isSelf() {
        Object ref = this.getRefObject();
        if (!(ref instanceof ExperimenterData)) {
            return false;
        }
        ExperimenterData exp = this.getCurrentUser();
        return exp.getId() == this.getRefObjectID();
    }

    Object getRefObject() {
        return this.refObject;
    }

    Object getPrimarySelect() {
        if (!this.isMultiSelection()) {
            return this.getRefObject();
        }
        List list = this.parent.getRelatedNodes();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return this.getRefObject();
        }
        return list.get(0);
    }

    boolean canEdit() {
        return this.canEdit(this.refObject);
    }

    boolean canEdit(Object data) {
        if (!MetadataViewerAgent.canCreate()) {
            return false;
        }
        if (!(data instanceof DataObject)) {
            return false;
        }
        DataObject d = (DataObject)data;
        return d.canEdit();
    }

    boolean canLink() {
        return this.canLink(this.refObject);
    }

    boolean canLink(Object data) {
        if (!MetadataViewerAgent.canCreate()) {
            return false;
        }
        switch (this.getDisplayMode()) {
            case 0: {
                if (data instanceof DataObject) {
                    return ((DataObject)data).canLink();
                }
                return false;
            }
        }
        return EditorUtil.isUserOwner(data, this.getLoggedInUserID());
    }

    boolean canAnnotate() {
        return this.canAnnotate(this.refObject);
    }

    boolean canAnnotate(Object data) {
        if (!MetadataViewerAgent.canCreate()) {
            return false;
        }
        if (!(data instanceof DataObject)) {
            return false;
        }
        DataObject d = (DataObject)data;
        return d.canAnnotate();
    }

    boolean canDelete() {
        return this.canDelete(this.refObject);
    }

    boolean canDelete(Object data) {
        if (!MetadataViewerAgent.canCreate()) {
            return false;
        }
        if (!(data instanceof DataObject)) {
            return false;
        }
        DataObject d = (DataObject)data;
        return d.canDelete();
    }

    boolean canDeleteLink(Object data) {
        if (!MetadataViewerAgent.canCreate()) {
            return false;
        }
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return false;
        }
        for (Map.Entry<DataObject, StructuredDataResults> e : r.entrySet()) {
            if (!this.canDeleteLink(data, e.getValue())) continue;
            return true;
        }
        return false;
    }

    boolean isModulo(Object data) {
        if (!(data instanceof XMLAnnotationData)) {
            return false;
        }
        XMLAnnotationData d = (XMLAnnotationData)data;
        ModuloParser parser = new ModuloParser(d.getText());
        try {
            parser.parse();
            return !CollectionUtils.isEmpty(parser.getModulos());
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.append((CharSequence)"Error while reading modulo annotation.");
            msg.print((Throwable)e);
            MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            return false;
        }
    }

    boolean isAcrossGroups() {
        List<DataObject> l = this.getSelectedObjects();
        if (l == null || l.size() == 0) {
            return false;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DataObject data : l) {
            if (ids.contains(data.getGroupId())) continue;
            ids.add(data.getGroupId());
        }
        return ids.size() > 1;
    }

    boolean canAddAnnotationLink() {
        if (!this.canAnnotate()) {
            return false;
        }
        if (!this.isMultiSelection()) {
            return true;
        }
        List l = this.parent.getRelatedNodes();
        if (l == null) {
            return false;
        }
        Iterator i = l.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            DataObject data = (DataObject)i.next();
            if (data instanceof GroupData || data instanceof ExperimenterData || ids.contains(data.getGroupId())) continue;
            ids.add(data.getGroupId());
        }
        return ids.size() <= 1;
    }

    boolean canDeleteAnnotationLink() {
        if (!MetadataViewerAgent.canCreate()) {
            return false;
        }
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return false;
        }
        for (Map.Entry<DataObject, StructuredDataResults> e : r.entrySet()) {
            StructuredDataResults data = e.getValue();
            Collection<AnnotationLinkData> links = data.getAnnotationLinks();
            if (links == null) continue;
            Iterator<AnnotationLinkData> j = links.iterator();
            while (j.hasNext()) {
                if (!j.next().canDelete()) continue;
                return true;
            }
        }
        return false;
    }

    boolean isUserOwner(Object object) {
        DataObject f;
        long id = this.getLoggedInUserID();
        if (object == null) {
            return false;
        }
        if (object instanceof ExperimenterData) {
            return ((ExperimenterData)object).getId() == id;
        }
        if (!(object instanceof DataObject)) {
            return false;
        }
        if ((object instanceof FileData || object instanceof ImageData) && (f = (DataObject)object).getId() < 0L) {
            return id == this.getLoggedInUserID();
        }
        return EditorUtil.isUserOwner(object, id);
    }

    boolean isLinkOwner(Object annotation) {
        Map<DataObject, StructuredDataResults> data = this.getAllStructuredData();
        if (data == null) {
            return false;
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> j = data.entrySet().iterator();
        DataObject ann = (DataObject)annotation;
        long id = this.getLoggedInUserID();
        while (j.hasNext()) {
            Map.Entry<DataObject, StructuredDataResults> e = j.next();
            Collection<AnnotationLinkData> links = e.getValue().getAnnotationLinks();
            if (links == null) continue;
            for (AnnotationLinkData link : links) {
                if (link.getChild().getId() != ann.getId() || link.getOwner().getId() != id) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAnnotatedByOther(DataObject data) {
        if (data == null) {
            return false;
        }
        List<ExperimenterData> annotators = this.getAnnotators(data);
        if (annotators == null || annotators.size() == 0) {
            return false;
        }
        if (annotators.size() == 1) {
            ExperimenterData exp = annotators.get(0);
            long id = this.getLoggedInUserID();
            return exp.getId() != id;
        }
        return true;
    }

    List<ExperimenterData> getAnnotators(Object annotation) {
        return this.getAnnotators(null, annotation);
    }

    List<ExperimenterData> getAnnotators(DataObject ref, Object annotation) {
        ArrayList<ExperimenterData> list = new ArrayList<ExperimenterData>();
        Map<DataObject, StructuredDataResults> data = this.getAllStructuredData();
        if (data == null) {
            return list;
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> j = data.entrySet().iterator();
        DataObject ann = (DataObject)annotation;
        ArrayList<Long> ids = new ArrayList<Long>();
        while (j.hasNext()) {
            Collection<AnnotationLinkData> links;
            Map.Entry<DataObject, StructuredDataResults> e = j.next();
            if (ref == null) {
                links = e.getValue().getAnnotationLinks();
                if (links == null) continue;
                for (AnnotationLinkData link : links) {
                    if (link.getChild().getId() != ann.getId() || ids.contains(link.getOwner().getId())) continue;
                    list.add(link.getOwner());
                    ids.add(link.getOwner().getId());
                }
                continue;
            }
            if (ref.getId() != e.getKey().getId()) continue;
            links = e.getValue().getAnnotationLinks();
            if (links == null) break;
            for (AnnotationLinkData link : links) {
                if (link.getChild().getId() != ann.getId() || ids.contains(link.getOwner().getId())) continue;
                list.add(link.getOwner());
                ids.add(link.getOwner().getId());
            }
            break;
        }
        return list;
    }

    List<Object> getLinks(int level, AnnotationData ho) {
        Map<DataObject, StructuredDataResults> data = this.getAllStructuredData();
        if (data == null) {
            return null;
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> j = data.entrySet().iterator();
        ArrayList<Object> results = new ArrayList<Object>();
        long userID = this.getCurrentUser().getId();
        while (j.hasNext()) {
            Map.Entry<DataObject, StructuredDataResults> e = j.next();
            Collection<AnnotationLinkData> links = e.getValue().getAnnotationLinks();
            if (links == null) continue;
            Iterator<AnnotationLinkData> i = links.iterator();
            switch (level) {
                case 0: {
                    AnnotationLinkData d;
                    while (i.hasNext()) {
                        d = i.next();
                        if (ho.getId() != d.getChild().getId()) continue;
                        results.add(d.getLink());
                    }
                    break;
                }
                case 1: {
                    AnnotationLinkData d;
                    while (i.hasNext()) {
                        d = i.next();
                        if (ho.getId() != d.getChild().getId() || userID != d.getOwner().getId()) continue;
                        results.add(d.getLink());
                    }
                    break;
                }
                case 2: {
                    AnnotationLinkData d;
                    while (i.hasNext()) {
                        d = i.next();
                        if (ho.getId() != d.getChild().getId() || userID == d.getOwner().getId()) continue;
                        results.add(d.getLink());
                    }
                    break;
                }
            }
        }
        return results;
    }

    List<FileAnnotationData> getFileAnnotatationsByLevel(int level) {
        ArrayList<FileAnnotationData> result = new ArrayList<FileAnnotationData>();
        Collection<FileAnnotationData> all = this.getAllAttachments();
        for (FileAnnotationData f : all) {
            switch (level) {
                case 0: {
                    result.add(f);
                    break;
                }
                case 1: {
                    if (MetadataViewerAgent.getUserDetails().getId() != f.getOwner().getId()) break;
                    result.add(f);
                    break;
                }
                case 2: {
                    if (MetadataViewerAgent.getUserDetails().getId() == f.getOwner().getId()) break;
                    result.add(f);
                }
            }
        }
        return result;
    }

    boolean isAnnotationUsedByUser(Object annotation) {
        Map<DataObject, StructuredDataResults> data = this.getAllStructuredData();
        if (data == null) {
            return false;
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> j = data.entrySet().iterator();
        long id = MetadataViewerAgent.getUserDetails().getId();
        DataObject ann = (DataObject)annotation;
        while (j.hasNext()) {
            Map.Entry<DataObject, StructuredDataResults> e = j.next();
            Collection<AnnotationLinkData> links = e.getValue().getAnnotationLinks();
            for (AnnotationLinkData link : links) {
                if (link.getChild().getId() != ann.getId() || link.getOwner().getId() != id) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAdministrator() {
        return MetadataViewerAgent.isAdministrator();
    }

    boolean isGroupLeader() {
        return this.isGroupLeader(MetadataViewerAgent.getUserDetails().getDefaultGroup());
    }

    boolean isGroupLeader(GroupData group) {
        ExperimenterData exp = MetadataViewerAgent.getUserDetails();
        Collection groups = MetadataViewerAgent.getAvailableUserGroups();
        if (groups == null) {
            return false;
        }
        long groupID = group.getId();
        Iterator i = groups.iterator();
        Set<ExperimenterData> leaders = null;
        while (i.hasNext()) {
            GroupData g = (GroupData)i.next();
            if (g.getId() != groupID) continue;
            leaders = g.getLeaders();
            break;
        }
        if (leaders == null) {
            return false;
        }
        for (ExperimenterData data : leaders) {
            if (data.getId() != exp.getId()) continue;
            return true;
        }
        return false;
    }

    String formatOwner(DataObject object) {
        if (object == null) {
            return "";
        }
        if (object instanceof ExperimenterData) {
            return EditorUtil.formatExperimenter((ExperimenterData)object);
        }
        return this.formatOwner(object.getOwner());
    }

    String formatDate(DataObject object) {
        return EditorUtil.formatDate(object);
    }

    int getTermsCount() {
        Collection<TermAnnotationData> terms = this.getTerms();
        if (terms == null) {
            return 0;
        }
        return terms.size();
    }

    Collection<TermAnnotationData> getTerms() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        return data.getTerms();
    }

    int getTagsCount() {
        Collection<TagAnnotationData> tags = this.getTags();
        if (tags == null) {
            return 0;
        }
        return tags.size();
    }

    Collection<TagAnnotationData> getTags() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return new ArrayList<TagAnnotationData>();
        }
        Collection<TagAnnotationData> tags = data.getTags();
        if (tags == null || tags.size() == 0) {
            return new ArrayList<TagAnnotationData>();
        }
        return this.sorter.sort(tags);
    }

    Collection<TagAnnotationData> getAllTags() {
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return new ArrayList<TagAnnotationData>();
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = r.entrySet().iterator();
        ArrayList<TagAnnotationData> results = new ArrayList<TagAnnotationData>();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            Collection<TagAnnotationData> tags = e.getValue().getTags();
            if (tags == null) continue;
            for (TagAnnotationData tag : tags) {
                if (ids.contains(tag.getId())) continue;
                results.add(tag);
                ids.add(tag.getId());
            }
        }
        return this.sorter.sort(results);
    }

    Collection<TagAnnotationData> getCommonTags() {
        Integer value;
        Collection<TagAnnotationData> tags;
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return new ArrayList<TagAnnotationData>();
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = r.entrySet().iterator();
        HashMap<Long, Integer> ids = new HashMap<Long, Integer>();
        while (i.hasNext()) {
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            tags = e.getValue().getTags();
            if (tags == null) continue;
            for (TagAnnotationData tag : tags) {
                value = (Integer)ids.get(tag.getId());
                if (value != null) {
                    Integer n = value;
                    Integer n2 = value = Integer.valueOf(value + 1);
                } else {
                    value = 1;
                }
                ids.put(tag.getId(), value);
            }
        }
        ArrayList<TagAnnotationData> results = new ArrayList<TagAnnotationData>();
        ArrayList<Long> count = new ArrayList<Long>();
        int max = r.size();
        for (Map.Entry<DataObject, StructuredDataResults> e : r.entrySet()) {
            tags = e.getValue().getTags();
            if (tags == null) continue;
            for (TagAnnotationData tag : tags) {
                value = (Integer)ids.get(tag.getId());
                if (value == null || value != max || count.contains(tag.getId())) continue;
                results.add(tag);
                count.add(tag.getId());
            }
        }
        return this.sorter.sort(results);
    }

    Map<DataObject, Boolean> getTaggedObjects(AnnotationData refTag) {
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        HashMap<DataObject, Boolean> m = new HashMap<DataObject, Boolean>();
        if (r == null) {
            return m;
        }
        block0: for (Map.Entry<DataObject, StructuredDataResults> e : r.entrySet()) {
            StructuredDataResults result = e.getValue();
            Collection<TagAnnotationData> tags = result.getTags();
            if (tags == null) continue;
            for (TagAnnotationData tag : tags) {
                if (tag.getId() != refTag.getId()) continue;
                DataObject o = (DataObject)result.getRelatedObject();
                m.put(o, this.canDeleteLink(tag, result));
                continue block0;
            }
        }
        return m;
    }

    Map<DataObject, Boolean> getObjectsWith(AnnotationData refFile) {
        HashMap<DataObject, Boolean> m;
        block8: {
            Iterator<Map.Entry<DataObject, StructuredDataResults>> i;
            block9: {
                block7: {
                    Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
                    m = new HashMap<DataObject, Boolean>();
                    if (r == null) {
                        return m;
                    }
                    i = r.entrySet().iterator();
                    if (!(refFile instanceof TermAnnotationData)) break block7;
                    block0: while (i.hasNext()) {
                        Map.Entry<DataObject, StructuredDataResults> e = i.next();
                        StructuredDataResults result = e.getValue();
                        Collection<TermAnnotationData> files = result.getTerms();
                        if (files == null) continue;
                        for (TermAnnotationData file : files) {
                            if (file.getId() != refFile.getId()) continue;
                            DataObject o = (DataObject)result.getRelatedObject();
                            m.put(o, this.canDeleteLink(file, result));
                            continue block0;
                        }
                    }
                    break block8;
                }
                if (!(refFile instanceof FileAnnotationData)) break block9;
                block2: while (i.hasNext()) {
                    Map.Entry<DataObject, StructuredDataResults> e = i.next();
                    StructuredDataResults result = e.getValue();
                    Collection<FileAnnotationData> files = result.getAttachments();
                    if (files == null) continue;
                    for (FileAnnotationData file : files) {
                        if (file.getId() != refFile.getId()) continue;
                        DataObject o = (DataObject)result.getRelatedObject();
                        m.put(o, this.canDeleteLink(file, result));
                        continue block2;
                    }
                }
                break block8;
            }
            if (!(refFile instanceof XMLAnnotationData)) break block8;
            block4: while (i.hasNext()) {
                Map.Entry<DataObject, StructuredDataResults> e = i.next();
                StructuredDataResults result = e.getValue();
                Collection<XMLAnnotationData> files = result.getXMLAnnotations();
                if (files == null) continue;
                for (XMLAnnotationData file : files) {
                    if (file.getId() != refFile.getId()) continue;
                    DataObject o = (DataObject)result.getRelatedObject();
                    m.put(o, this.canDeleteLink(file, result));
                    continue block4;
                }
            }
        }
        return m;
    }

    Collection<FileAnnotationData> getCompanionFiles() {
        String ns;
        FileAnnotationData f;
        StructuredDataResults data = this.parent.getStructuredData();
        ArrayList<FileAnnotationData> list = new ArrayList<FileAnnotationData>();
        if (data == null) {
            return list;
        }
        Collection<FileAnnotationData> attachments = data.getAttachments();
        if (attachments == null) {
            return list;
        }
        Iterator<FileAnnotationData> i = attachments.iterator();
        while (i.hasNext()) {
            f = i.next();
            ns = f.getNameSpace();
            if (!"openmicroscopy.org/omero/import/companionFile".equals(ns) || f == this.originalMetadata) continue;
            list.add(f);
        }
        if (this.refObject instanceof WellSampleData && (data = this.parent.getParentStructuredData()) != null && (attachments = data.getAttachments()) != null) {
            while (i.hasNext()) {
                f = i.next();
                ns = f.getNameSpace();
                if (!"openmicroscopy.org/omero/import/companionFile".equals(ns) || f == this.originalMetadata) continue;
                list.add(f);
            }
        }
        return this.sorter.sort(list);
    }

    Collection<FileAnnotationData> getAttachments() {
        String name;
        String ns;
        StructuredDataResults data = this.parent.getStructuredData();
        ArrayList<FileAnnotationData> l = new ArrayList<FileAnnotationData>();
        if (data == null) {
            return l;
        }
        Collection<FileAnnotationData> attachments = data.getAttachments();
        if (attachments == null) {
            return l;
        }
        for (FileAnnotationData f : attachments) {
            ns = f.getNameSpace();
            if ("openmicroscopy.org/omero/import/companionFile".equals(ns)) {
                name = f.getFileName();
                if (!name.contains("original_metadata.txt")) continue;
                this.originalMetadata = f;
                continue;
            }
            if (this.isNameSpaceExcluded(ns)) continue;
            l.add(f);
        }
        if (this.getRefObject() instanceof WellSampleData && (data = this.parent.getParentStructuredData()) != null && (attachments = data.getAttachments()) != null) {
            for (FileAnnotationData f : attachments) {
                ns = f.getNameSpace();
                if (!"openmicroscopy.org/omero/import/companionFile".equals(ns) || !(name = f.getFileName()).contains("original_metadata.txt")) continue;
                this.originalMetadata = f;
            }
        }
        return this.sorter.sort(l);
    }

    Collection<FileAnnotationData> getAllAttachments() {
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return new ArrayList<FileAnnotationData>();
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = r.entrySet().iterator();
        ArrayList<FileAnnotationData> results = new ArrayList<FileAnnotationData>();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            Collection<FileAnnotationData> files = e.getValue().getAttachments();
            if (files == null) continue;
            for (FileAnnotationData file : files) {
                String ns = file.getNameSpace();
                if (this.isNameSpaceExcluded(ns) || ids.contains(file.getId())) continue;
                results.add(file);
                ids.add(file.getId());
            }
        }
        return this.sorter.sort(results);
    }

    Collection<FileAnnotationData> getCommonAttachments() {
        Integer value;
        Collection<FileAnnotationData> tags;
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return new ArrayList<FileAnnotationData>();
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = r.entrySet().iterator();
        HashMap<Long, Integer> ids = new HashMap<Long, Integer>();
        while (i.hasNext()) {
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            tags = e.getValue().getAttachments();
            if (tags == null) continue;
            for (FileAnnotationData tag : tags) {
                String ns = tag.getNameSpace();
                if (this.isNameSpaceExcluded(ns)) continue;
                value = (Integer)ids.get(tag.getId());
                if (value != null) {
                    Integer n = value;
                    Integer n2 = value = Integer.valueOf(value + 1);
                } else {
                    value = 1;
                }
                ids.put(tag.getId(), value);
            }
        }
        ArrayList<FileAnnotationData> results = new ArrayList<FileAnnotationData>();
        ArrayList<Long> count = new ArrayList<Long>();
        int max = r.size();
        for (Map.Entry<DataObject, StructuredDataResults> e : r.entrySet()) {
            tags = e.getValue().getAttachments();
            if (tags == null) continue;
            for (FileAnnotationData tag : tags) {
                value = (Integer)ids.get(tag.getId());
                if (value == null || value != max || count.contains(tag.getId())) continue;
                results.add(tag);
                count.add(tag.getId());
            }
        }
        return this.sorter.sort(results);
    }

    Collection<AnnotationData> getOtherAnnotations() {
        Collection<AnnotationData> others;
        StructuredDataResults data = this.parent.getStructuredData();
        ArrayList<AnnotationData> l = new ArrayList<AnnotationData>();
        if (data == null) {
            return l;
        }
        Collection<XMLAnnotationData> xml = data.getXMLAnnotations();
        if (xml != null && !xml.isEmpty()) {
            l.addAll(xml);
        }
        if ((others = data.getOtherAnnotations()) != null && !others.isEmpty()) {
            l.addAll(others);
        }
        return l;
    }

    List<MapAnnotationData> getMapAnnotations(MapAnnotationType type) {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<MapAnnotationData> result = new ArrayList<MapAnnotationData>();
        Collection<MapAnnotationData> maps = data.getMapAnnotations();
        if (!CollectionUtils.isEmpty(maps)) {
            for (MapAnnotationData d : maps) {
                if ((type == MapAnnotationType.USER || type == MapAnnotationType.OTHER_USERS) && "openmicroscopy.org/omero/client/mapAnnotation".equals(d.getNameSpace())) {
                    if (type == MapAnnotationType.USER && MetadataViewerAgent.getUserDetails().getId() == d.getOwner().getId()) {
                        result.add(d);
                        continue;
                    }
                    if (type != MapAnnotationType.OTHER_USERS || MetadataViewerAgent.getUserDetails().getId() == d.getOwner().getId()) continue;
                    result.add(d);
                    continue;
                }
                if (type != MapAnnotationType.OTHER || "openmicroscopy.org/omero/client/mapAnnotation".equals(d.getNameSpace())) continue;
                result.add(d);
            }
        }
        Comparator<MapAnnotationData> comp = new Comparator<MapAnnotationData>(){

            @Override
            public int compare(MapAnnotationData o1, MapAnnotationData o2) {
                if (o1.getId() < o2.getId()) {
                    return -1;
                }
                return 1;
            }
        };
        Collections.sort(result, comp);
        return result;
    }

    Collection<AnnotationData> getAllOtherAnnotations() {
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return new ArrayList<AnnotationData>();
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = r.entrySet().iterator();
        ArrayList<AnnotationData> results = new ArrayList<AnnotationData>();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            Collection<AnnotationData> others;
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            Collection<XMLAnnotationData> files = e.getValue().getXMLAnnotations();
            if (files != null) {
                for (XMLAnnotationData file : files) {
                    if (ids.contains(file.getId())) continue;
                    results.add(file);
                    ids.add(file.getId());
                }
            }
            if ((others = e.getValue().getOtherAnnotations()) == null) continue;
            for (AnnotationData other : others) {
                if (ids.contains(other.getId())) continue;
                results.add(other);
                ids.add(other.getId());
            }
        }
        return this.sorter.sort(results);
    }

    Map<Integer, ModuloInfo> getModulo() {
        Collection<XMLAnnotationData> annotations = this.getXMLAnnotations();
        HashMap<Integer, ModuloInfo> modulo = new HashMap<Integer, ModuloInfo>();
        if (CollectionUtils.isEmpty(annotations)) {
            return modulo;
        }
        for (XMLAnnotationData data : annotations) {
            ModuloParser parser = new ModuloParser(data.getText());
            try {
                parser.parse();
                List<ModuloInfo> infos = parser.getModulos();
                for (ModuloInfo info : infos) {
                    modulo.put(info.getModuloIndex(), info);
                }
            }
            catch (Exception e) {
                LogMessage msg = new LogMessage();
                msg.append((CharSequence)"Error while reading modulo annotation.");
                msg.print((Throwable)e);
                MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            }
        }
        return modulo;
    }

    Collection<XMLAnnotationData> getXMLAnnotations() {
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return new ArrayList<XMLAnnotationData>();
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = r.entrySet().iterator();
        ArrayList<XMLAnnotationData> results = new ArrayList<XMLAnnotationData>();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            Collection<XMLAnnotationData> files = e.getValue().getXMLAnnotations();
            if (files == null) continue;
            for (XMLAnnotationData file : files) {
                if (ids.contains(file.getId())) continue;
                results.add(file);
                ids.add(file.getId());
            }
        }
        return this.sorter.sort(results);
    }

    Collection<AnnotationData> getCommonOtherAnnotations() {
        Collection<AnnotationData> others;
        Integer value;
        Collection<XMLAnnotationData> tags;
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return new ArrayList<AnnotationData>();
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = r.entrySet().iterator();
        HashMap<Long, Integer> ids = new HashMap<Long, Integer>();
        while (i.hasNext()) {
            Integer n;
            Integer n2;
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            tags = e.getValue().getXMLAnnotations();
            if (tags != null) {
                for (XMLAnnotationData tag : tags) {
                    value = (Integer)ids.get(tag.getId());
                    if (value != null) {
                        n2 = value;
                        n = value = Integer.valueOf(value + 1);
                    } else {
                        value = 1;
                    }
                    ids.put(tag.getId(), value);
                }
            }
            if ((others = e.getValue().getOtherAnnotations()) == null) continue;
            for (AnnotationData other : others) {
                value = (Integer)ids.get(other.getId());
                if (value != null) {
                    n2 = value;
                    n = value = Integer.valueOf(value + 1);
                } else {
                    value = 1;
                }
                ids.put(other.getId(), value);
            }
        }
        ArrayList<AnnotationData> results = new ArrayList<AnnotationData>();
        ArrayList<Long> count = new ArrayList<Long>();
        int max = r.size();
        for (Map.Entry<DataObject, StructuredDataResults> e : r.entrySet()) {
            tags = e.getValue().getXMLAnnotations();
            if (tags != null) {
                for (XMLAnnotationData tag : tags) {
                    value = (Integer)ids.get(tag.getId());
                    if (value == null || value != max || count.contains(tag.getId())) continue;
                    results.add(tag);
                    count.add(tag.getId());
                }
            }
            if ((others = e.getValue().getOtherAnnotations()) == null) continue;
            for (AnnotationData other : others) {
                value = (Integer)ids.get(other.getId());
                if (value == null || value != max || count.contains(other.getId())) continue;
                results.add(other);
                count.add(other.getId());
            }
        }
        return this.sorter.sort(results);
    }

    FileAnnotationData getOriginalMetadata() {
        return this.originalMetadata;
    }

    int getViewedByCount() {
        Collection viewedBy = this.getViewedBy();
        if (viewedBy == null) {
            return 0;
        }
        return viewedBy.size();
    }

    Collection getViewedBy() {
        return null;
    }

    int getRatingCount(int filter) {
        Map<DataObject, StructuredDataResults> data = this.parent.getAllStructuredData();
        if (data == null) {
            return 0;
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = data.entrySet().iterator();
        int n = 0;
        long userID = this.getLoggedInUserID();
        block4: while (i.hasNext()) {
            Iterator<RatingAnnotationData> j;
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            StructuredDataResults results = e.getValue();
            Collection<RatingAnnotationData> ratings = results.getRatings();
            if (ratings == null) continue;
            switch (filter) {
                case 0: {
                    n += ratings.size();
                    continue block4;
                }
                case 1: {
                    j = ratings.iterator();
                    while (j.hasNext()) {
                        if (j.next().getOwner().getId() != userID) continue;
                        ++n;
                    }
                    break;
                }
            }
            j = ratings.iterator();
            while (j.hasNext()) {
                if (j.next().getOwner().getId() == userID) continue;
                ++n;
            }
        }
        return n;
    }

    RatingAnnotationData getUserRatingAnnotation() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        Collection<RatingAnnotationData> ratings = data.getRatings();
        if (CollectionUtils.isEmpty(ratings)) {
            return null;
        }
        Iterator<RatingAnnotationData> i = ratings.iterator();
        long id = this.getCurrentUser().getId();
        while (i.hasNext()) {
            RatingAnnotationData rate = i.next();
            if (rate.getOwner().getId() != id) continue;
            return rate;
        }
        return null;
    }

    Map<DataObject, RatingAnnotationData> getAllUserRatingAnnotation() {
        Map<DataObject, StructuredDataResults> data = this.parent.getAllStructuredData();
        if (data == null) {
            return null;
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = data.entrySet().iterator();
        HashMap<DataObject, RatingAnnotationData> map = new HashMap<DataObject, RatingAnnotationData>();
        long id = this.getLoggedInUserID();
        while (i.hasNext()) {
            Collection<RatingAnnotationData> ratings;
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            StructuredDataResults results = e.getValue();
            if (results == null || (ratings = results.getRatings()) == null) continue;
            for (RatingAnnotationData rating : ratings) {
                if (rating.getOwner().getId() != id) continue;
                map.put(e.getKey(), rating);
            }
        }
        return map;
    }

    BooleanAnnotationData getPublishedAnnotation() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        return null;
    }

    int getUserRating() {
        RatingAnnotationData data = this.getUserRatingAnnotation();
        if (data == null) {
            return 0;
        }
        return data.getRating();
    }

    int getAllUserRating() {
        Map<DataObject, RatingAnnotationData> map = this.getAllUserRatingAnnotation();
        if (map == null) {
            return 0;
        }
        Collection<RatingAnnotationData> ratings = map.values();
        Iterator<RatingAnnotationData> i = ratings.iterator();
        int n = 0;
        while (i.hasNext()) {
            n += i.next().getRating();
        }
        return n;
    }

    RatingAnnotationData getUserRatingData() {
        Map<DataObject, RatingAnnotationData> map;
        if (!this.isMultiSelection() && (map = this.getAllUserRatingAnnotation()) != null) {
            for (Map.Entry<DataObject, RatingAnnotationData> e : map.entrySet()) {
                if (e.getValue().getOwner().getId() != this.getLoggedInUserID()) continue;
                return e.getValue();
            }
        }
        return null;
    }

    int getRatingAverage(int filter) {
        Map<DataObject, StructuredDataResults> data = this.parent.getAllStructuredData();
        if (data == null) {
            return 0;
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = data.entrySet().iterator();
        int n = 0;
        int value = 0;
        long userID = this.getLoggedInUserID();
        block4: while (i.hasNext()) {
            RatingAnnotationData rating2;
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            StructuredDataResults results = e.getValue();
            Collection<RatingAnnotationData> ratings = results.getRatings();
            if (ratings == null) continue;
            Iterator<RatingAnnotationData> j = ratings.iterator();
            switch (filter) {
                case 0: {
                    while (j.hasNext()) {
                        rating2 = j.next();
                        value += rating2.getRating();
                        ++n;
                    }
                    continue block4;
                }
                case 1: {
                    while (j.hasNext()) {
                        rating2 = j.next();
                        if (rating2.getOwner().getId() != userID) continue;
                        value += rating2.getRating();
                        ++n;
                    }
                    break;
                }
            }
            for (RatingAnnotationData rating2 : ratings) {
                if (rating2.getOwner().getId() == userID) continue;
                value += rating2.getRating();
                ++n;
            }
        }
        if (n == 0) {
            return 0;
        }
        return value / n;
    }

    int getTextualAnnotationCount() {
        Collection<TextualAnnotationData> annotations = this.getTextualAnnotations();
        if (annotations == null) {
            return 0;
        }
        return annotations.size();
    }

    Collection<TextualAnnotationData> getTextualAnnotations() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return null;
        }
        return data.getTextualAnnotations();
    }

    Collection<TextualAnnotationData> getAllTextualAnnotations() {
        Map<DataObject, StructuredDataResults> r = this.parent.getAllStructuredData();
        if (r == null) {
            return new ArrayList<TextualAnnotationData>();
        }
        Iterator<Map.Entry<DataObject, StructuredDataResults>> i = r.entrySet().iterator();
        ArrayList<TextualAnnotationData> results = new ArrayList<TextualAnnotationData>();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            Map.Entry<DataObject, StructuredDataResults> e = i.next();
            Collection<TextualAnnotationData> others = e.getValue().getTextualAnnotations();
            if (others == null) continue;
            for (TextualAnnotationData other : others) {
                if (ids.contains(other.getId())) continue;
                results.add(other);
                ids.add(other.getId());
            }
        }
        return results;
    }

    List getTextualAnnotationsByDate() {
        this.textualAnnotationsByDate = (List)this.getAllTextualAnnotations();
        this.sortAnnotationByDate(this.textualAnnotationsByDate);
        return this.textualAnnotationsByDate;
    }

    TextualAnnotationData getLastUserAnnotation() {
        long userID;
        Map<Long, List> m = this.getTextualAnnotationByOwner();
        List l = m.get(userID = MetadataViewerAgent.getUserDetails().getId());
        if (l == null || l.size() == 0) {
            return null;
        }
        return (TextualAnnotationData)l.get(0);
    }

    Map<Long, List> getTextualAnnotationByOwner() {
        if (this.textualAnnotationsByUsers != null && this.textualAnnotationsByUsers.size() > 0) {
            return this.textualAnnotationsByUsers;
        }
        this.textualAnnotationsByUsers = new HashMap<Long, List>();
        Collection<TextualAnnotationData> original = this.getTextualAnnotations();
        if (original == null) {
            return this.textualAnnotationsByUsers;
        }
        for (AnnotationData annotationData : original) {
            Long ownerID = annotationData.getOwner().getId();
            ArrayList<AnnotationData> userAnnos = this.textualAnnotationsByUsers.get(ownerID);
            if (userAnnos == null) {
                userAnnos = new ArrayList<AnnotationData>();
                this.textualAnnotationsByUsers.put(ownerID, userAnnos);
            }
            userAnnos.add(annotationData);
        }
        for (Long ownerID : this.textualAnnotationsByUsers.keySet()) {
            this.sortAnnotationByDate(this.textualAnnotationsByUsers.get(ownerID));
        }
        return this.textualAnnotationsByUsers;
    }

    boolean isSameObject(Object object) {
        return this.parent.isSameObject(object);
    }

    void setRootObject(Object refObject) {
        boolean b = this.isSameObject(this.refObject);
        this.set = null;
        this.largeImage = false;
        this.refObject = refObject;
        if (this.existingTags != null) {
            this.existingTags.clear();
        }
        this.existingTags = null;
        if (this.textualAnnotationsByUsers != null) {
            this.textualAnnotationsByUsers.clear();
        }
        this.textualAnnotationsByUsers = null;
        if (this.textualAnnotationsByDate != null) {
            this.textualAnnotationsByDate.clear();
        }
        this.textualAnnotationsByDate = null;
        if (this.existingAttachments != null) {
            this.existingAttachments.clear();
        }
        this.existingAttachments = null;
        if (this.resultsLoader != null) {
            this.resultsLoader.clear();
        }
        this.resultsLoader = null;
        if (!b) {
            this.parentRefObject = null;
            this.gpRefObject = null;
            if (this.emissionsWavelengths != null) {
                this.emissionsWavelengths.clear();
            }
            this.emissionsWavelengths = null;
            if (this.channelAcquisitionDataMap != null) {
                this.channelAcquisitionDataMap.clear();
            }
            if (this.channelPlaneInfoMap != null) {
                this.channelPlaneInfoMap.clear();
            }
            this.imageAcquisitionData = null;
            this.instrumentData = null;
            this.originalMetadata = null;
            if (refObject instanceof ImageData || refObject instanceof WellSampleData) {
                this.fireChannelEnumerationsLoading();
                this.fireImageEnumerationsLoading();
                this.fireLargeImageLoading();
            } else if (refObject instanceof ExperimenterData) {
                this.fireExperimenterPhotoLoading();
            }
            if (this.renderer != null) {
                this.renderer.discard();
                this.renderer = null;
            }
        }
    }

    void setParentRootObject(Object parentRefObject, Object gpRefObject) {
        this.parentRefObject = parentRefObject;
        this.gpRefObject = gpRefObject;
    }

    Object getParentRootObject() {
        return this.parentRefObject;
    }

    Object getGrandParentRootObject() {
        return this.gpRefObject;
    }

    ExperimenterData getRefObjectOwner() {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            return this.getOwner((DataObject)ref);
        }
        return null;
    }

    void loadExistingTags() {
        boolean exist = false;
        for (EditorLoader l : this.loaders) {
            if (!(l instanceof TagsLoader)) continue;
            exist = true;
            break;
        }
        if (exist) {
            return;
        }
        TagsLoader loader = new TagsLoader(this.component, this.parent.getSecurityContext(), this.canRetrieveAll());
        loader.load();
        this.loaders.add(loader);
    }

    void loadExistingAttachments() {
        boolean exist = false;
        for (EditorLoader l : this.loaders) {
            if (!(l instanceof AttachmentsLoader)) continue;
            exist = true;
            break;
        }
        if (exist) {
            return;
        }
        AttachmentsLoader loader = new AttachmentsLoader(this.component, this.parent.getSecurityContext(), this.canRetrieveAll());
        loader.load();
        this.loaders.add(loader);
    }

    void cancelExistingTagsLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof TagsLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void loadChannelData() {
        WellSampleData wsd;
        Object refObject = this.getRefObject();
        ImageData data = null;
        if (refObject instanceof ImageData) {
            data = (ImageData)refObject;
        } else if (refObject instanceof WellSampleData && (data = (wsd = (WellSampleData)refObject).getImage()) != null && data.getId() < 0L) {
            data = null;
        }
        if (data == null) {
            return;
        }
        try {
            PixelsData pixs = data.getDefaultPixels();
            ChannelDataLoader loader = new ChannelDataLoader(this.component, this.parent.getSecurityContext(), pixs.getId(), this.parent.getUserID());
            loader.load();
            this.loaders.add(loader);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void cancelChannelDataLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof ChannelDataLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void setExistingTags(Collection tags) {
        if (tags != null) {
            this.existingTags = this.sorter.sort(tags);
        }
        Iterator<EditorLoader> i = this.loaders.iterator();
        EditorLoader toRemove = null;
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (!(loader instanceof TagsLoader)) continue;
            toRemove = loader;
            break;
        }
        if (toRemove != null) {
            this.loaders.remove(toRemove);
        }
    }

    Collection getExistingTags() {
        return this.existingTags;
    }

    void setExistingAttachments(Collection attachments) {
        if (attachments != null) {
            this.existingAttachments = this.sorter.sort(attachments);
        }
        Iterator<EditorLoader> i = this.loaders.iterator();
        EditorLoader toRemove = null;
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (!(loader instanceof AttachmentsLoader)) continue;
            toRemove = loader;
            break;
        }
        if (toRemove != null) {
            this.loaders.remove(toRemove);
        }
    }

    Collection getExistingAttachments() {
        return this.existingAttachments;
    }

    void setChannelData(Map data) {
        List l = this.sorter.sort(data.keySet());
        this.emissionsWavelengths = new LinkedHashMap();
        for (Object channel : l) {
            this.emissionsWavelengths.put(channel, data.get(channel));
        }
    }

    Map getChannelData() {
        if (this.getRndIndex() == 1 && this.renderer != null) {
            List<ChannelData> l = this.renderer.getChannelData();
            LinkedHashMap<ChannelData, Object> m = new LinkedHashMap<ChannelData, Object>();
            for (ChannelData data : l) {
                if (CommonsLangUtils.isNotEmpty(this.renderer.getLookupTable(data.getIndex()))) {
                    m.put(data, this.renderer.getLookupTable(data.getIndex()));
                    continue;
                }
                m.put(data, this.renderer.getChannelColor(data.getIndex()));
            }
            return m;
        }
        return this.emissionsWavelengths;
    }

    void fireAnnotationSaving(DataToSave object, List<Object> metadata, boolean asynch) {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            DataObject data = (DataObject)ref;
            if (data instanceof WellSampleData) {
                data = ((WellSampleData)ref).getImage();
            }
            ArrayList<AnnotationData> list = null;
            if (CollectionUtils.isNotEmpty(this.toDelete)) {
                list = new ArrayList<AnnotationData>();
                Iterator<AnnotationData> i = this.toDelete.iterator();
                while (i.hasNext()) {
                    list.add(i.next());
                }
                this.toDelete.clear();
            }
            this.parent.saveData(object, list, metadata, data, asynch);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void fireChannelSaving(List<ChannelData> channels, boolean applyToAll) {
        DataObject object = null;
        if (applyToAll) {
            if (this.parentRefObject instanceof DatasetData) {
                object = (DataObject)this.parentRefObject;
            } else {
                if (!(this.gpRefObject instanceof PlateData)) return;
                object = (DataObject)this.gpRefObject;
            }
        } else {
            object = (DataObject)this.refObject;
        }
        ChannelDataSaver loader = new ChannelDataSaver(this.component, this.getSecurityContext(), channels, object);
        loader.load();
    }

    void fireAnnotationsDeletion(List<AnnotationData> annotations) {
        Object ref = this.getRefObject();
        if (ref instanceof DataObject) {
            DataObject data = (DataObject)ref;
            if (data instanceof WellSampleData) {
                data = ((WellSampleData)ref).getImage();
            }
            this.parent.saveData(null, annotations, new ArrayList<Object>(), data, true);
        }
    }

    void fireFileAnnotationRemoveCheck(List<FileAnnotationData> annotations) {
        FileAnnotationChecker check = new FileAnnotationChecker(this.component, this.getSecurityContext(), annotations, this.getSelectedObjects());
        check.load();
    }

    void fireAdminSaving(Object data, boolean asynch) {
        if (data instanceof ExperimenterData || data instanceof AdminObject || data instanceof GroupData) {
            this.parent.updateAdminObject(data, asynch);
        }
    }

    boolean isArchived() {
        return this.isArchived(this.getImage());
    }

    boolean isArchived(DataObject ho) {
        ImageData img = null;
        if (ho instanceof ImageData) {
            img = (ImageData)ho;
        }
        if (img == null) {
            return false;
        }
        return img.isArchived();
    }

    void download(File file, boolean override) {
        if (this.refObject instanceof ImageData) {
            this.downloadImages(file, override);
        } else if (this.refObject instanceof FileAnnotationData) {
            this.downloadFiles(file, override);
        }
    }

    void downloadOriginal(String path, boolean override) {
        if (!(this.refObject instanceof ImageData || this.refObject instanceof PlateData || this.refObject instanceof WellData || this.refObject instanceof WellSampleData || this.refObject instanceof PlateAcquisitionData)) {
            return;
        }
        ArrayList<DataObject> images = new ArrayList<DataObject>();
        List<DataObject> l = this.getSelectedObjects();
        if (!CollectionUtils.isEmpty(l)) {
            Iterator<DataObject> i = l.iterator();
            ArrayList<Long> filesetIds = new ArrayList<Long>();
            while (i.hasNext()) {
                DataObject w;
                DataObject p;
                long id;
                DataObject o = i.next();
                if (o instanceof ImageData && this.isArchived(o)) {
                    ImageData image = (ImageData)o;
                    id = image.getFilesetId();
                    if (id < 0L) {
                        images.add(image);
                    } else if (!filesetIds.contains(id)) {
                        images.add(image);
                        filesetIds.add(id);
                    }
                }
                if (o instanceof PlateData) {
                    p = (PlateData)o;
                    images.add(p);
                }
                if (o instanceof PlateAcquisitionData) {
                    p = (PlateAcquisitionData)o;
                    PlateData pl = new PlateData(((PlateAcquisition)p.asIObject()).getPlate());
                    images.add(pl);
                }
                if (o instanceof WellSampleData) {
                    w = (WellSampleData)o;
                    id = ((WellSampleData)w).getImage().getFilesetId();
                    if (id < 0L) {
                        images.add(((WellSampleData)w).getImage());
                    } else if (!filesetIds.contains(id)) {
                        images.add(((WellSampleData)w).getImage());
                        filesetIds.add(id);
                    }
                }
                if (!(o instanceof WellData)) continue;
                w = (WellData)o;
                for (WellSampleData s : ((WellData)w).getWellSamples()) {
                    id = s.getImage().getFilesetId();
                    if (id < 0L) {
                        images.add(s.getImage());
                        continue;
                    }
                    if (filesetIds.contains(id)) continue;
                    images.add(s.getImage());
                    filesetIds.add(id);
                }
            }
        }
        if (!CollectionUtils.isEmpty(images)) {
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            IconManager icons = IconManager.getInstance();
            ImageIcon icon = icons.getIcon(76);
            SecurityContext ctx = this.getSecurityContext();
            DownloadArchivedActivityParam p = new DownloadArchivedActivityParam(new File(path), images, icon);
            p.setOverride(override);
            p.setZip(false);
            un.notifyActivity(ctx, p);
        }
    }

    void loadDiskSpace(Class type, long id) {
        DiskSpaceLoader loader = new DiskSpaceLoader(this.component, this.parent.getSecurityContext(), type, id);
        loader.load();
        this.loaders.add(loader);
    }

    void cancelDiskSpaceLoading() {
        Iterator<EditorLoader> i = this.loaders.iterator();
        ArrayList<EditorLoader> toKeep = new ArrayList<EditorLoader>();
        while (i.hasNext()) {
            EditorLoader loader = i.next();
            if (loader instanceof DiskSpaceLoader) {
                loader.cancel();
                continue;
            }
            toKeep.add(loader);
        }
        this.loaders.clear();
        this.loaders.addAll(toKeep);
    }

    void changePassword(String old, String confirm) {
        PasswordEditor loader = new PasswordEditor(this.component, this.parent.getSecurityContext(), old, confirm);
        ((EditorLoader)loader).load();
        this.loaders.add(loader);
    }

    boolean hasTagsAsChildren() {
        Object ref = this.getRefObject();
        if (!(ref instanceof TagAnnotationData)) {
            return false;
        }
        TagAnnotationData tag = (TagAnnotationData)ref;
        Set<TagAnnotationData> tags = tag.getTags();
        return tags != null && tags.size() > 0;
    }

    ExperimenterData getOwner(DataObject data) {
        if (data == null) {
            return null;
        }
        long id = data.getOwner().getId();
        return MetadataViewerAgent.getExperimenter(id);
    }

    void loadParents() {
        this.parent.loadParents();
    }

    void cancelParentsLoading() {
    }

    boolean hasBeenViewedBy() {
        if (!(this.getRefObject() instanceof ImageData)) {
            return false;
        }
        return this.getViewedByCount() != 0;
    }

    void fireImageEnumerationsLoading() {
        EnumerationLoader loader = new EnumerationLoader(this.component, this.parent.getSecurityContext(), 0);
        loader.load();
    }

    void fireChannelEnumerationsLoading() {
        EnumerationLoader loader = new EnumerationLoader(this.component, this.parent.getSecurityContext(), 1);
        loader.load();
    }

    void fireImagAcquisitionDataLoading() {
        Object ref = this.getRefObject();
        ImageData data = null;
        if (ref instanceof WellSampleData) {
            data = ((WellSampleData)ref).getImage();
        } else if (ref instanceof ImageData) {
            data = (ImageData)ref;
        }
        if (data == null) {
            return;
        }
        AcquisitionDataLoader loader = new AcquisitionDataLoader(this.component, this.parent.getSecurityContext(), data);
        loader.load();
    }

    void fireChannelAcquisitionDataLoading(ChannelData channel) {
        AcquisitionDataLoader loader = new AcquisitionDataLoader(this.component, this.parent.getSecurityContext(), channel);
        loader.load();
    }

    void fireInstrumentDataLoading(long instrumentID) {
        InstrumentDataLoader loader = new InstrumentDataLoader(this.component, this.parent.getSecurityContext(), instrumentID);
        loader.load();
    }

    void setImageAcquisitionData(ImageAcquisitionData data) {
        this.imageAcquisitionData = data;
    }

    ImageAcquisitionData getImageAcquisitionData() {
        return this.imageAcquisitionData;
    }

    void setChannelAcquisitionData(int index, ChannelAcquisitionData data) {
        if (this.channelAcquisitionDataMap == null) {
            this.channelAcquisitionDataMap = new HashMap<Integer, ChannelAcquisitionData>();
        }
        this.channelAcquisitionDataMap.put(index, data);
    }

    ChannelAcquisitionData getChannelAcquisitionData(int index) {
        if (this.channelAcquisitionDataMap == null) {
            return null;
        }
        return this.channelAcquisitionDataMap.get(index);
    }

    void setPlaneInfo(int index, Collection data) {
        if (this.channelPlaneInfoMap == null) {
            this.channelPlaneInfoMap = new HashMap<Integer, Collection>();
        }
        this.channelPlaneInfoMap.put(index, this.sortPlane(data));
    }

    Collection getChannelPlaneInfo(int index) {
        if (this.channelPlaneInfoMap == null) {
            return null;
        }
        return this.channelPlaneInfoMap.get(index);
    }

    List<EnumerationObject> getImageEnumerations(String name) {
        if (this.imageEnumerations != null) {
            return this.imageEnumerations.get(name);
        }
        return new ArrayList<EnumerationObject>();
    }

    List<EnumerationObject> getChannelEnumerations(String name) {
        if (this.channelEnumerations != null) {
            return this.channelEnumerations.get(name);
        }
        return new ArrayList<EnumerationObject>();
    }

    Object getImageEnumerationSelected(String name, String value) {
        List<EnumerationObject> l = this.getImageEnumerations(name);
        if (l.size() == 0) {
            return null;
        }
        for (EnumerationObject o : l) {
            String v = o.getValue();
            if (!(v = v.trim()).equals(value)) continue;
            return o;
        }
        return null;
    }

    Object getChannelEnumerationSelected(String name, String value) {
        if (value == null) {
            return null;
        }
        List<EnumerationObject> l = this.getChannelEnumerations(name);
        if (l.size() == 0) {
            return null;
        }
        Iterator<EnumerationObject> i = l.iterator();
        value = value.trim();
        while (i.hasNext()) {
            EnumerationObject o = i.next();
            String v = o.getValue();
            if (!(v = v.trim()).equals(value)) continue;
            return o;
        }
        return null;
    }

    void setChannelEnumerations(Map enumerations) {
        this.channelEnumerations = new HashMap<String, List<EnumerationObject>>();
        Set set = enumerations.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            this.sortEnumerations(values);
            this.channelEnumerations.put(key, values);
        }
    }

    void setImageEnumerations(Map enumerations) {
        this.imageEnumerations = new HashMap<String, List<EnumerationObject>>();
        Set set = enumerations.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            this.sortEnumerations(values);
            this.imageEnumerations.put(key, values);
        }
    }

    String getAnnotationDescription(AnnotationData annotation) {
        if (annotation == null) {
            return "";
        }
        if (annotation instanceof TagAnnotationData) {
            return ((TagAnnotationData)annotation).getTagDescription();
        }
        if (annotation instanceof TermAnnotationData) {
            return ((TermAnnotationData)annotation).getTermDescription();
        }
        if (annotation instanceof XMLAnnotationData) {
            return ((XMLAnnotationData)annotation).getDescription();
        }
        return "";
    }

    boolean isSingleMode() {
        return this.parent.isSingleMode();
    }

    String getObjectPath() {
        return this.parent.getObjectPath();
    }

    void firePlaneInfoLoading(int channel, int z) {
        Object ref = this.getRefObject();
        if (ref instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)ref;
            ref = wsd.getImage();
        }
        if (!(ref instanceof ImageData)) {
            return;
        }
        ImageData img = (ImageData)ref;
        PlaneInfoLoader loader = new PlaneInfoLoader(this.component, this.parent.getSecurityContext(), img.getDefaultPixels().getId(), channel, z);
        loader.load();
    }

    void makeMovie(int scaleBar, Color overlayColor) {
        this.parent.makeMovie(scaleBar, overlayColor);
    }

    boolean isRendererLoaded() {
        return this.renderer != null;
    }

    boolean fireRenderingControlLoading(long pixelsID, int index) {
        if (this.isRendererLoaded() && index == 0) {
            return false;
        }
        RenderingControlLoader loader = new RenderingControlLoader(this.component, new SecurityContext(((DataObject)this.refObject).getGroupId()), pixelsID, index);
        loader.load();
        return true;
    }

    void loadRenderingControl(long pixelsID) {
        OmeroImageService rds = MetadataViewerAgent.getRegistry().getImageService();
        try {
            RenderingControl ctrl = rds.loadRenderingControl(new SecurityContext(((DataObject)this.refObject).getGroupId()), pixelsID);
            this.setRenderingControl(ctrl);
        }
        catch (Throwable e) {
            LogMessage msg = new LogMessage();
            msg.print("Could not reload RenderingControl for pixelsId=" + pixelsID);
            msg.print(e);
            MetadataViewerAgent.getRegistry().getLogger().warn((Object)this, msg);
        }
    }

    void setRenderingControl(RenderingControl rndControl) {
        if (this.renderer != null) {
            this.renderer.onSettingsApplied(rndControl);
        } else {
            this.renderer = RendererFactory.createRenderer(this.getSecurityContext(), rndControl, this.getImage(), this.getRndIndex(), this.getXMLAnnotations(), this.parent.getAlternativeRenderingSettings(), this.parent);
        }
    }

    Renderer getRenderer() {
        return this.renderer;
    }

    int getRndIndex() {
        return this.parent.getRndIndex();
    }

    boolean hasBeenPublished() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return false;
        }
        return this.getPublishedAnnotation() != null;
    }

    void loadOriginalMetadata(Object uiView) {
        ImageData img = this.getImage();
        OriginalMetadataLoader loader = new OriginalMetadataLoader(this.component, this.parent.getSecurityContext(), img.getId(), uiView);
        loader.load();
    }

    void loadFiles(Map<FileAnnotationData, Object> files) {
        if (!MetadataViewerAgent.isBinaryAvailable()) {
            return;
        }
        FileLoader loader = new FileLoader(this.component, this.parent.getSecurityContext(), files);
        loader.load();
    }

    void onRndLoaded(boolean reload) {
        if (this.renderer == null) {
            return;
        }
        this.parent.onRndLoaded(reload);
    }

    void setInstrumentData(InstrumentData data) {
        this.instrumentData = data;
    }

    InstrumentData getInstrumentData() {
        return this.instrumentData;
    }

    void sortDataObjectByID(List values) {
        if (values == null || values.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                long n1 = ((DataObject)o1).getId();
                long n2 = ((DataObject)o2).getId();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                }
                return -v;
            }
        };
        Collections.sort(values, c);
    }

    void upgradePermissions() {
    }

    Color getChannelColor(int index) {
        if (this.renderer == null) {
            return null;
        }
        return this.renderer.getChannelColor(index);
    }

    String getLookupTable(int index) {
        if (this.renderer == null) {
            return null;
        }
        return this.renderer.getLookupTable(index);
    }

    boolean isNumerousChannel() {
        if (!(this.refObject instanceof ImageData) && !(this.refObject instanceof WellSampleData)) {
            return false;
        }
        if (this.renderer != null) {
            return this.renderer.getPixelsDimensionsC() >= 100;
        }
        ImageData img = null;
        if (this.refObject instanceof WellSampleData) {
            img = ((WellSampleData)this.refObject).getImage();
        }
        if (this.refObject instanceof ImageData) {
            img = (ImageData)this.refObject;
        }
        PixelsData pixels = null;
        try {
            pixels = img.getDefaultPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pixels == null) {
            return false;
        }
        return pixels.getSizeC() >= 100;
    }

    boolean isPreviewAvailable() {
        if (!(this.refObject instanceof ImageData) && !(this.refObject instanceof WellSampleData)) {
            return false;
        }
        if (!MetadataViewerAgent.isBinaryAvailable()) {
            return false;
        }
        ImageData img = null;
        if (this.refObject instanceof WellSampleData) {
            img = ((WellSampleData)this.refObject).getImage();
        }
        if (this.refObject instanceof ImageData) {
            img = (ImageData)this.refObject;
        }
        if (img.getId() < 0L) {
            return false;
        }
        PixelsData pixels = null;
        try {
            pixels = img.getDefaultPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pixels != null && !this.isLargeImage();
    }

    void createFigure(Object value) {
        this.parent.createFigure(value);
    }

    void manageScript(ScriptObject script, int index) {
        this.parent.manageScript(script, index);
    }

    PixelsData getPixels() {
        ImageData img = this.getImage();
        if (img == null) {
            return null;
        }
        return img.getDefaultPixels();
    }

    ImageData getImage() {
        Object object = this.getPrimarySelect();
        ImageData img = null;
        if (object instanceof WellSampleData) {
            img = ((WellSampleData)object).getImage();
        }
        if (object instanceof ImageData) {
            img = (ImageData)object;
        }
        return img;
    }

    void fireROILoading(int index) {
        ImageData img = this.getImage();
        if (img == null) {
            return;
        }
        long userID = MetadataViewerAgent.getUserDetails().getId();
        ROILoader loader = new ROILoader(this.component, this.parent.getSecurityContext(), img.getId(), userID, index);
        loader.load();
    }

    void discardRenderer() {
        if (this.renderer != null) {
            this.renderer.discard();
        }
        this.renderer = null;
    }

    void refresh() {
        this.parent.refresh();
    }

    void setScripts(List scripts) {
        if (scripts == null) {
            this.scripts = null;
            return;
        }
        LinkedHashMap<Long, ScriptObject> map = new LinkedHashMap<Long, ScriptObject>();
        List l = this.sorter.sort(scripts);
        for (ScriptObject s : l) {
            map.put(s.getScriptID(), s);
        }
        this.scripts = map;
    }

    Collection<ScriptObject> getScripts() {
        if (this.scripts == null) {
            return null;
        }
        return this.scripts.values();
    }

    void loadScript(long scriptID) {
        ScriptLoader loader = new ScriptLoader(this.component, this.parent.getSecurityContext(), scriptID);
        loader.load();
        this.loaders.add(loader);
    }

    void setScript(ScriptObject script) {
        if (this.scripts == null || this.scripts.size() == 0) {
            return;
        }
        ScriptObject sc = this.scripts.get(script.getScriptID());
        if (sc != null) {
            sc.setJobParams(script.getParameters());
        }
    }

    ScriptObject getScript(long scriptID) {
        return this.scripts.get(scriptID);
    }

    void loadScripts() {
        ScriptsLoader loader = new ScriptsLoader(this.component, this.parent.getSecurityContext(), false);
        loader.load();
        this.loaders.add(loader);
    }

    long getUserID() {
        return this.parent.getUserID();
    }

    long getLoggedInUserID() {
        return MetadataViewerAgent.getUserDetails().getId();
    }

    ExperimenterData getCurrentUser() {
        return MetadataViewerAgent.getUserDetails();
    }

    ExperimenterData getExperimenter(long expID) {
        List l = (List)MetadataViewerAgent.getRegistry().lookup("/users/details");
        if (l == null) {
            return null;
        }
        for (ExperimenterData exp : l) {
            if (exp.getId() != expID) continue;
            return exp;
        }
        return null;
    }

    String getOwnerName() {
        Object o = this.getRefObject();
        if (o == null) {
            return null;
        }
        if (o instanceof ExperimenterData || o instanceof GroupData) {
            return null;
        }
        if (o instanceof DataObject) {
            ExperimenterData user = this.getCurrentUser();
            DataObject data = (DataObject)o;
            long id = user.getId();
            if (data.getId() < 0L) {
                return null;
            }
            if (!((DataObject)o).isLoaded()) {
                return null;
            }
            try {
                ExperimenterData owner = data.getOwner();
                if (owner.getId() == id) {
                    return EditorUtil.formatExperimenter(user);
                }
                if (owner.isLoaded()) {
                    return EditorUtil.formatExperimenter(owner);
                }
                if ((owner = this.getExperimenter(owner.getId())) != null) {
                    return EditorUtil.formatExperimenter(owner);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    void resetPassword(String newPass) {
        if (this.refObject instanceof ExperimenterData && MetadataViewerAgent.isAdministrator()) {
            this.parent.resetPassword(newPass);
        }
    }

    void uploadPicture(File photo, String format) {
        if (this.refObject instanceof ExperimenterData) {
            ExperimenterData exp = MetadataViewerAgent.getUserDetails();
            UserPhotoUploader loader = new UserPhotoUploader(this.component, this.parent.getSecurityContext(), exp, photo, format);
            loader.load();
        }
    }

    void deletePicture() {
        if (this.refObject instanceof ExperimenterData) {
            try {
                OmeroMetadataService svc;
                Collection photos;
                ExperimenterData exp = MetadataViewerAgent.getUserDetails();
                if (this.usersPhoto != null) {
                    this.usersPhoto.remove(exp.getId());
                }
                if ((photos = (svc = MetadataViewerAgent.getRegistry().getMetadataService()).loadAnnotations(this.parent.getSecurityContext(), FileAnnotationData.class, "openmicroscopy.org/omero/experimenter/photo", exp.getId())) == null || photos.size() == 0) {
                    return;
                }
                ArrayList<DeletableObject> l = new ArrayList<DeletableObject>();
                Iterator j = photos.iterator();
                while (j.hasNext()) {
                    l.add(new DeletableObject((DataObject)j.next()));
                }
                IconManager icons = IconManager.getInstance();
                DeleteActivityParam p = new DeleteActivityParam((Icon)icons.getIcon(115), l);
                p.setUIRegister(false);
                p.setFailureIcon(icons.getIcon(114));
                UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
                un.notifyActivity(this.getSecurityContext(), p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void uploadScript() {
        this.parent.uploadScript();
    }

    private List<ScriptObject> getScriptsWithUI() {
        if (this.scriptsWithUI != null) {
            return this.scriptsWithUI;
        }
        try {
            OmeroImageService svc = MetadataViewerAgent.getRegistry().getImageService();
            this.scriptsWithUI = svc.loadAvailableScriptsWithUI(this.getSecurityContext());
            return this.scriptsWithUI;
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Scripts with UI");
            msg.print((Throwable)e);
            MetadataViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            return new ArrayList<ScriptObject>();
        }
    }

    ScriptObject getScriptFromName(String name) {
        List<ScriptObject> scripts = this.getScriptsWithUI();
        for (ScriptObject script : scripts) {
            if (!name.contains(script.getName())) continue;
            return script;
        }
        return null;
    }

    void loadAnalysisResults(AnalysisResultsItem analysis) {
        if (this.resultsLoader == null) {
            this.resultsLoader = new HashMap<AnalysisResultsItem, EditorLoader>();
        }
        AnalysisResultsFileLoader loader = new AnalysisResultsFileLoader(this.component, this.parent.getSecurityContext(), analysis);
        this.resultsLoader.put(analysis, loader);
        loader.load();
    }

    void cancelAnalysisResultsLoading(AnalysisResultsItem item) {
        if (this.resultsLoader == null) {
            return;
        }
        EditorLoader loader = this.resultsLoader.get(item);
        if (loader != null) {
            loader.cancel();
        }
    }

    void removeAnalysisResultsLoading(AnalysisResultsItem item) {
        if (this.resultsLoader == null) {
            return;
        }
        this.resultsLoader.remove(item);
    }

    boolean isAnnotationToDelete(AnnotationData annotation) {
        if (this.toDelete == null || this.toDelete.size() == 0) {
            return false;
        }
        for (AnnotationData data : this.toDelete) {
            if (data.getId() != annotation.getId()) continue;
            return true;
        }
        return false;
    }

    List<FileAnnotationData> getTabularData() {
        StructuredDataResults data = this.parent.getStructuredData();
        ArrayList<FileAnnotationData> l = new ArrayList<FileAnnotationData>();
        if (data == null) {
            return l;
        }
        Collection<FileAnnotationData> attachments = data.getAttachments();
        if (attachments == null) {
            return l;
        }
        for (FileAnnotationData f : attachments) {
            String ns = f.getNameSpace();
            if (!"openmicroscopy.org/omero/bulk_annotations".equals(ns)) continue;
            l.add(f);
        }
        return l;
    }

    private DataObject saveAsObject(Object ho) {
        if (ho instanceof ImageData || ho instanceof DatasetData) {
            return (DataObject)ho;
        }
        if (ho instanceof WellSampleData) {
            return ((WellSampleData)ho).getImage();
        }
        return null;
    }

    void saveAs(File folder, int format, String filename) {
        DataObject data;
        List l = this.parent.getRelatedNodes();
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        if (l != null) {
            Iterator i = l.iterator();
            while (i.hasNext()) {
                data = this.saveAsObject(i.next());
                if (data == null) continue;
                objects.add(data);
            }
        }
        if ((data = this.saveAsObject(this.getRefObject())) != null && objects.size() == 0) {
            objects.add(data);
        }
        if (objects.size() > 0) {
            IconManager icons = IconManager.getInstance();
            SaveAsParam p = new SaveAsParam(folder, objects);
            p.setIndex(format);
            p.setIcon(icons.getIcon(119));
            p.setBatchExportFilename(filename);
            p.setDeleteWhenFinished(true);
            UserNotifier un = MetadataViewerAgent.getRegistry().getUserNotifier();
            un.notifyActivity(this.getSecurityContext(), p);
        }
    }

    List<DataObject> getSelectedObjects() {
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        List l = this.parent.getRelatedNodes();
        if (CollectionUtils.isEmpty((Collection)l)) {
            if (this.getRefObject() instanceof DataObject) {
                objects.add((DataObject)this.getRefObject());
            }
            return objects;
        }
        for (Object o : l) {
            if (!(o instanceof DataObject)) continue;
            objects.add((DataObject)o);
        }
        return objects;
    }

    boolean isLargeImage() {
        return this.largeImage;
    }

    void setLargeImage(Boolean value) {
        if (value == null) {
            this.largeImage = false;
        }
        this.largeImage = value;
    }

    JFrame getRefFrame() {
        return this.parent.getParentUI();
    }

    void setUserPhoto(BufferedImage photo, long expId) {
        if (this.usersPhoto == null) {
            this.usersPhoto = new HashMap<Long, BufferedImage>();
        }
        this.usersPhoto.put(expId, photo);
    }

    BufferedImage getUserPhoto(long expId) {
        if (this.usersPhoto == null) {
            return null;
        }
        return this.usersPhoto.get(expId);
    }

    SecurityContext getSecurityContext() {
        return this.parent.getSecurityContext();
    }

    boolean doesGroupExist(GroupData data, String name) {
        if (data == null) {
            return false;
        }
        AdminService svc = MetadataViewerAgent.getRegistry().getAdminService();
        try {
            GroupData g = svc.lookupGroup(this.getSecurityContext(), name);
            if (g != null && data.getId() != g.getId()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    Map<DataObject, StructuredDataResults> getAllStructuredData() {
        return this.parent.getAllStructuredData();
    }

    boolean isNameSpaceExcluded(String ns) {
        if (ns == null) {
            return false;
        }
        return EXCLUDED_FILE_NS.contains(ns);
    }

    void updateChannels(List<ChannelData> channels) {
        if (this.channelAcquisitionDataMap != null) {
            this.channelAcquisitionDataMap.clear();
        }
        List l = this.sorter.sort(channels);
        this.emissionsWavelengths = new LinkedHashMap();
        for (Object channel : l) {
            this.emissionsWavelengths.put(channel, this.emissionsWavelengths.get(channel));
        }
    }

    Collection<FilesetData> getFileset() {
        return this.set;
    }

    void setFileset(Collection<FilesetData> set) {
        this.set = set;
    }

    void fireFilesetLoading() {
        ImageData img = this.getImage();
        if (img == null) {
            return;
        }
        FilesetLoader loader = new FilesetLoader(this.component, this.getSecurityContext(), img.getId());
        loader.load();
    }

    int getDisplayMode() {
        Integer value = (Integer)MetadataViewerAgent.getRegistry().lookup("DataDisplay");
        if (value == null) {
            return 1;
        }
        switch (value) {
            case 0: 
            case 1: {
                return value;
            }
        }
        return 1;
    }

    boolean isAnnotationLoaded() {
        StructuredDataResults data = this.parent.getStructuredData();
        if (data == null) {
            return false;
        }
        return data.isLoaded();
    }

    boolean hasOriginalMetadata() {
        return true;
    }

    Collection<GroupData> getAvailableGroups() {
        return MetadataViewerAgent.getAvailableUserGroups();
    }

    boolean isSystemUser(long id) {
        return MetadataViewerAgent.getRegistry().getAdminService().isSystemUser(id);
    }

    boolean isSystemGroup(long id) {
        return MetadataViewerAgent.getRegistry().getAdminService().isSecuritySystemGroup(id);
    }

    boolean isSystemGroup(long id, String key) {
        return MetadataViewerAgent.getRegistry().getAdminService().isSecuritySystemGroup(id, key);
    }

    ImportType getImportType() {
        Collection<AnnotationData> tfl;
        StructuredDataResults data = this.parent.getStructuredData();
        if (data != null && (tfl = data.getTransferLinks()) != null) {
            for (AnnotationData an : tfl) {
                if (!"openmicroscopy.org/omero/import/fileTransfer".equals(an.getNameSpace())) continue;
                String content = an.getContent().toString();
                return ImportType.getImportType(content);
            }
        }
        return ImportType.UPLOAD;
    }

    void fireLDAPDetailsLoading() {
        if (!(this.getRefObject() instanceof ExperimenterData)) {
            return;
        }
        ExperimenterData exp = (ExperimenterData)this.getRefObject();
        LDAPLoader l = new LDAPLoader(this.component, this.getSecurityContext(), exp.getId());
        ((EditorLoader)l).load();
    }

    boolean isLDAP() {
        if (this.getRefObject() instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)this.getRefObject();
            return exp.isLDAP();
        }
        return false;
    }

    boolean isExportable() {
        if (!MetadataViewerAgent.canCreate() || this.getPixels() == null) {
            return false;
        }
        long imgSize = (long)this.getPixels().getSizeX() * (long)this.getPixels().getSizeY();
        long maxSize = DEFAULT_MAX_EXPORT_SIZE;
        String tmp = (String)MetadataViewerAgent.getRegistry().lookup("omero.client.download_as.max_size");
        if (tmp != null) {
            try {
                maxSize = Long.parseLong(tmp);
            }
            catch (NumberFormatException e) {
                MetadataViewerAgent.getRegistry().getLogger().warn((Object)this, "Non integer value provided for omero.client.download_as.max_size");
            }
        }
        return imgSize <= maxSize;
    }

    static {
        EXCLUDED_FILE_NS.add("openmicroscopy.org/omero/import/companionFile");
    }

    public static enum MapAnnotationType {
        USER,
        OTHER_USERS,
        OTHER;

    }
}

