/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDef;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.model.TimeRefObject;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class RefreshExperimenterDataLoader
extends DataBrowserLoader {
    private Class<?> type;
    private long id;
    private Class<?> rootNodeType;
    private Map<SecurityContext, RefreshExperimenterDef> expNodes;
    private CallHandle handle;
    private Object refNode;
    private DataObject toBrowse;
    private Map<SecurityContext, TreeImageSet> smartFolders;

    private void checkClass(Class<?> klass) {
        if (ProjectData.class.equals(klass) || ImageData.class.equals(klass) || TagAnnotationData.class.equals(klass) || DatasetData.class.equals(klass) || FileAnnotationData.class.equals(klass) || ScreenData.class.equals(klass) || GroupData.class.equals(klass)) {
            return;
        }
        throw new IllegalArgumentException("Root node not supported.");
    }

    private void setExperimenterResult(SecurityContext ctx, Object result) {
        HashMap<TreeImageSet, Collection> map;
        RefreshExperimenterDef node = this.getNode(ctx);
        if (result instanceof Map) {
            map = (HashMap<TreeImageSet, Collection>)result;
        } else {
            Collection set = (Collection)result;
            Iterator j = set.iterator();
            map = new HashMap<TreeImageSet, Collection>();
            Set<DataObject> children = null;
            while (j.hasNext()) {
                Object parent = j.next();
                if (parent instanceof TimeRefObject) {
                    TreeImageSet display;
                    if (this.smartFolders == null || (display = this.smartFolders.get(ctx)) == null) continue;
                    display.removeAllChildren();
                    display.removeAllChildrenDisplay();
                    map.put(display, ((TimeRefObject)parent).getResults());
                    continue;
                }
                if (parent instanceof ProjectData) {
                    children = ((ProjectData)parent).getDatasets();
                } else if (parent instanceof DatasetData) {
                    children = new HashSet<DatasetData>(1);
                    children.add((DatasetData)parent);
                } else if (parent instanceof TagAnnotationData) {
                    children = new HashSet<DatasetData>(1);
                    children.add((DatasetData)parent);
                } else if (parent instanceof ScreenData) {
                    children = ((ScreenData)parent).getPlates();
                } else if (parent instanceof GroupData) {
                    children = ((GroupData)parent).getExperimenters();
                }
                map.put((TreeImageSet)parent, children);
            }
        }
        node.setResults(map);
    }

    private RefreshExperimenterDef getNode(SecurityContext ctx) {
        for (Map.Entry<SecurityContext, RefreshExperimenterDef> e : this.expNodes.entrySet()) {
            if (!e.getKey().equals(ctx)) continue;
            return e.getValue();
        }
        return null;
    }

    private void formatSmartFolderResult(SecurityContext ctx, List result) {
        RefreshExperimenterDef node = this.expNodes.get(ctx);
        if (node == null) {
            return;
        }
        List nodes = node.getExpandedNodes();
        int n = nodes.size();
        HashMap<TreeImageSet, Collection> m = new HashMap<TreeImageSet, Collection>();
        for (int i = 0; i < n; ++i) {
            TreeImageSet display = (TreeImageSet)nodes.get(i);
            TimeRefObject ref = (TimeRefObject)result.get(i);
            m.put(display, ref.getResults());
        }
        node.setResults(m);
    }

    public RefreshExperimenterDataLoader(Browser viewer, SecurityContext ctx, Class<?> rootNodeType, Map<SecurityContext, RefreshExperimenterDef> expNodes, Class<?> type, long id, Object refNode, DataObject toBrowse) {
        super(viewer, ctx);
        if (expNodes == null || expNodes.size() == 0) {
            throw new IllegalArgumentException("Nodes not valid.");
        }
        this.checkClass(rootNodeType);
        this.rootNodeType = rootNodeType;
        this.expNodes = expNodes;
        this.type = type;
        this.id = id;
        this.refNode = refNode;
        this.toBrowse = toBrowse;
    }

    @Override
    public void load() {
        Iterator<Map.Entry<SecurityContext, RefreshExperimenterDef>> i = this.expNodes.entrySet().iterator();
        TimeRefObject ref = null;
        HashMap<SecurityContext, List> m = new HashMap<SecurityContext, List>(this.expNodes.size());
        if (ImageData.class.equals(this.rootNodeType) || FileAnnotationData.class.equals(this.rootNodeType)) {
            while (i.hasNext()) {
                Map.Entry<SecurityContext, RefreshExperimenterDef> entry = i.next();
                SecurityContext ctx = entry.getKey();
                long userID = ctx.getExperimenter();
                RefreshExperimenterDef def = entry.getValue();
                List nodes = def.getExpandedNodes();
                Iterator j = nodes.iterator();
                ArrayList<TimeRefObject> times = new ArrayList<TimeRefObject>(nodes.size());
                while (j.hasNext()) {
                    Object node = j.next();
                    if (node instanceof TreeImageTimeSet) {
                        TreeImageTimeSet time = (TreeImageTimeSet)node;
                        ref = new TimeRefObject(userID, 0);
                        ref.setTimeInterval(time.getStartTime(), time.getEndTime());
                    } else if (node instanceof TreeFileSet) {
                        TreeFileSet file = (TreeFileSet)node;
                        ref = new TimeRefObject(userID, 1);
                        ref.setFileType(file.getType());
                    }
                    if (ref == null) continue;
                    times.add(ref);
                }
                m.put(ctx, times);
            }
        } else {
            while (i.hasNext()) {
                ArrayList<Object> nl;
                ArrayList l;
                Map.Entry<SecurityContext, RefreshExperimenterDef> entry = i.next();
                SecurityContext ctx = entry.getKey();
                long userID = ctx.getExperimenter();
                RefreshExperimenterDef def = entry.getValue();
                if (GroupData.class.equals(this.rootNodeType)) {
                    l = (ArrayList)def.getExpandedTopNodes().get(GroupData.class);
                    if (l == null) {
                        l = new ArrayList();
                    }
                    m.put(ctx, l);
                    continue;
                }
                if (TagAnnotationData.class.equals(this.rootNodeType)) {
                    l = def.getExpandedNodes();
                    nl = new ArrayList<Object>();
                    for (Object ob : l) {
                        if (ob instanceof TreeFileSet) {
                            ref = new TimeRefObject(userID, 1);
                            ref.setFileType(4);
                            nl.add(ref);
                            if (this.smartFolders == null) {
                                this.smartFolders = new HashMap<SecurityContext, TreeImageSet>();
                            }
                            this.smartFolders.put(ctx, (TreeImageSet)ob);
                            continue;
                        }
                        nl.add(ob);
                    }
                    m.put(ctx, nl);
                    continue;
                }
                l = def.getExpandedNodes();
                nl = new ArrayList();
                for (Object ob : l) {
                    if (ob instanceof TreeFileSet) {
                        ref = new TimeRefObject(userID, 1);
                        ref.setFileType(100);
                        nl.add(ref);
                        if (this.smartFolders == null) {
                            this.smartFolders = new HashMap<SecurityContext, TreeImageSet>();
                        }
                        this.smartFolders.put(ctx, (TreeImageSet)ob);
                        continue;
                    }
                    nl.add(((TreeImageSet)ob).getUserObject());
                }
                m.put(ctx, nl);
            }
        }
        this.handle = this.dmView.refreshHierarchy(this.rootNodeType, m, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        if (GroupData.class.equals(this.rootNodeType)) {
            for (Map.Entry<SecurityContext, RefreshExperimenterDef> entry : this.expNodes.entrySet()) {
                RefreshExperimenterDef def = entry.getValue();
                Map nodes = def.getExpandedTopNodes();
                this.viewer.setGroups((Collection)result, (List)nodes.get(GroupData.class));
            }
            return;
        }
        Map m = (Map)result;
        Iterator i = m.entrySet().iterator();
        if (ImageData.class.equals(this.rootNodeType) || FileAnnotationData.class.equals(this.rootNodeType)) {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                SecurityContext ctx = (SecurityContext)entry.getKey();
                this.formatSmartFolderResult(ctx, (List)entry.getValue());
            }
        } else {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                SecurityContext ctx = (SecurityContext)entry.getKey();
                Object o = entry.getValue();
                if (this.smartFolders != null && o instanceof Map) {
                    Map map = (Map)o;
                    Iterator k = map.entrySet().iterator();
                    HashMap<TreeImageSet, Collection<Object>> newMap = new HashMap<TreeImageSet, Collection<Object>>();
                    while (k.hasNext()) {
                        Map.Entry e = k.next();
                        Object key = e.getKey();
                        if (key instanceof TimeRefObject) {
                            TreeImageSet display;
                            if (this.smartFolders == null || (display = this.smartFolders.get(ctx)) == null) continue;
                            display.removeAllChildren();
                            display.removeAllChildrenDisplay();
                            newMap.put(display, ((TimeRefObject)key).getResults());
                            continue;
                        }
                        newMap.put((TreeImageSet)key, (Collection<Object>)e.getValue());
                    }
                    this.setExperimenterResult(ctx, newMap);
                    continue;
                }
                this.setExperimenterResult(ctx, o);
            }
        }
        this.viewer.setRefreshExperimenterData(this.expNodes, this.type, this.id);
        if (this.refNode instanceof TreeImageDisplay || this.refNode == null) {
            this.viewer.browse((TreeImageDisplay)this.refNode, this.toBrowse, true);
        }
    }
}

