/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ViewInPluginCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ViewInPlugin
extends TreeViewerAction {
    private static final String NAME_IJ = "View in ImageJ...";
    private static final String DESCRIPTION_IJ = "View the selected image in ImageJ.";
    private static final String NAME_KNIME = "View in KNIME...";
    private static final String DESCRIPTION_KNIME = "View the selected image(s) in KNIME.";
    private int plugin;

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null || selectedDisplay.getParentDisplay() == null || selectedDisplay instanceof TreeImageTimeSet) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(selectedDisplay.getUserObject() instanceof ImageData);
    }

    public ViewInPlugin(TreeViewer model, int plugin) {
        super(model);
        this.plugin = plugin;
        this.name = "Name";
        IconManager icons = IconManager.getInstance();
        switch (plugin) {
            case 1: 
            case 3: {
                this.name = NAME_IJ;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_IJ));
                this.putValue("SmallIcon", icons.getIcon(163));
                break;
            }
            case 2: {
                this.name = NAME_KNIME;
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_KNIME));
                this.putValue("SmallIcon", icons.getIcon(166));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ViewInPluginCmd cmd = new ViewInPluginCmd(this.model, this.plugin);
        cmd.execute();
    }
}

