/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ViewOtherAction
extends TreeViewerAction {
    private static final String NAME = "Other...";
    private static final String DESCRIPTION = "Open the document with the selected application.";
    private static final String DESCRIPTION_GENERAL = "Select the application to open the document.";
    private ApplicationData data;

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null || selectedDisplay.getParentDisplay() == null || selectedDisplay instanceof TreeImageTimeSet) {
            this.setEnabled(false);
            return;
        }
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof ImageData) {
            this.setEnabled(true);
        } else {
            this.setEnabled(ho instanceof FileAnnotationData);
        }
    }

    public ViewOtherAction(TreeViewer model, ApplicationData data) {
        super(model);
        this.name = NAME;
        this.data = data;
        if (data == null) {
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_GENERAL));
        } else {
            this.name = data.getApplicationName();
            this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
            this.putValue("SmallIcon", data.getApplicationIcon());
        }
        Browser browser = model.getSelectedBrowser();
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.model.openWith(this.data);
    }
}

