/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.treetable.model.OMETreeNode;

class DeletableTableNode
extends OMETreeNode {
    static final String IMAGE_TYPE = "Image";
    static final String DATASET_TYPE = "Dataset";
    static final String PROJECT_TYPE = "Project";
    static final String SCREEN_TYPE = "Screen";
    static final String PLATE_TYPE = "Plate";
    static final String PLATE_ACQUISITION_TYPE = "Plate Run";
    static final String FILE_TYPE = "File";
    static final String GROUP_TYPE = "Group";
    static final String EXPERIMENTER_TYPE = "Experimenter";

    DeletableTableNode(Object refNode) {
        super(refNode);
        if (refNode == null) {
            throw new IllegalArgumentException("No node specified.");
        }
    }

    String getType() {
        Object node = this.getUserObject();
        if (!(node instanceof DataObject)) {
            return "";
        }
        DataObject object = (DataObject)node;
        if (object instanceof ImageData) {
            return IMAGE_TYPE;
        }
        if (object instanceof DatasetData) {
            return DATASET_TYPE;
        }
        if (object instanceof ProjectData) {
            return PROJECT_TYPE;
        }
        if (object instanceof ScreenData) {
            return SCREEN_TYPE;
        }
        if (object instanceof PlateData) {
            return PLATE_TYPE;
        }
        if (object instanceof FileAnnotationData) {
            return FILE_TYPE;
        }
        if (object instanceof PlateAcquisitionData) {
            return PLATE_ACQUISITION_TYPE;
        }
        if (object instanceof GroupData) {
            return GROUP_TYPE;
        }
        if (object instanceof ExperimenterData) {
            return EXPERIMENTER_TYPE;
        }
        return "";
    }

    public Object getValueAt(int column) {
        Object node = this.getUserObject();
        if (!(node instanceof DataObject)) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return -1;
                }
                case 2: {
                    return "";
                }
            }
        }
        DataObject object = (DataObject)node;
        switch (column) {
            case 0: {
                return this.getType();
            }
            case 1: {
                return object.getId();
            }
            case 2: {
                if (object instanceof DatasetData) {
                    return ((DatasetData)object).getName();
                }
                if (object instanceof ProjectData) {
                    return ((ProjectData)object).getName();
                }
                if (object instanceof ScreenData) {
                    return ((ScreenData)object).getName();
                }
                if (object instanceof PlateData) {
                    return ((PlateData)object).getName();
                }
                if (object instanceof PlateAcquisitionData) {
                    return ((PlateAcquisitionData)object).getLabel();
                }
                if (object instanceof FileAnnotationData) {
                    return ((FileAnnotationData)object).getFileName();
                }
                if (object instanceof ImageData) {
                    return EditorUtil.getPartialName(((ImageData)object).getName());
                }
                if (object instanceof GroupData) {
                    return ((GroupData)object).getName();
                }
                if (object instanceof ExperimenterData) {
                    return EditorUtil.formatExperimenter((ExperimenterData)object);
                }
                return "";
            }
        }
        return null;
    }
}

