/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.ui;

import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.util.ui.ScriptComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class IdentifierParamPane
extends JPanel {
    static final String DISPLAY_INFO_PROPERTY = "displayInfo";
    static final String INFO_TEXT = "Use ',' to separate values.";
    private Class<?> type;
    private JTextField field;
    private JButton infoButton;
    private boolean required;

    private void initializeComponents() {
        this.field = new JTextField(ScriptComponent.COLUMNS);
        IconManager icons = IconManager.getInstance();
        this.infoButton = new JButton(icons.getIcon(19));
        this.infoButton.setToolTipText(INFO_TEXT);
        UIUtilities.unifiedButtonLookAndFeel(this.infoButton);
        this.infoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                SwingUtilities.convertPointToScreen(p, IdentifierParamPane.this.infoButton);
                IdentifierParamPane.this.firePropertyChange(IdentifierParamPane.DISPLAY_INFO_PROPERTY, null, p);
            }
        });
    }

    private void buildGUI(boolean showInfo) {
        this.setLayout(new FlowLayout(0));
        if (showInfo) {
            this.add(this.infoButton);
        }
        this.add(this.field);
    }

    IdentifierParamPane(Class<?> type) {
        this(type, true, true);
    }

    IdentifierParamPane(Class<?> type, boolean showInfo) {
        this(type, true, showInfo);
    }

    IdentifierParamPane(Class<?> type, boolean required, boolean showInfo) {
        this.type = type;
        this.required = required;
        this.initializeComponents();
        this.buildGUI(showInfo);
    }

    void setValues(List<DataObject> values) {
        if (values == null) {
            this.field.setText("");
            return;
        }
        Iterator<DataObject> i = values.iterator();
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        int n = values.size() - 1;
        while (i.hasNext()) {
            buffer.append(i.next().getId());
            if (index < n) {
                buffer.append(", ");
            }
            ++index;
        }
        this.field.setText(buffer.toString());
    }

    List<String> getValuesAsString() {
        String text = this.field.getText();
        if (text == null) {
            return null;
        }
        String[] values = text.split(",");
        if (values == null || values.length == 0) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            String v = values[i];
            v = v.trim();
            l.add(v);
        }
        return l;
    }

    List<Long> getValuesAsLong() {
        String text = this.field.getText();
        if (text == null) {
            return null;
        }
        if (!Long.class.equals(this.type)) {
            return null;
        }
        String[] values = text.split(",");
        if (values == null || values.length == 0) {
            return null;
        }
        ArrayList<Long> l = new ArrayList<Long>();
        for (int i = 0; i < values.length; ++i) {
            String v = values[i];
            v = v.trim();
            try {
                l.add(Long.parseLong(v));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    List<Object> getValues() {
        String text = this.field.getText();
        if (text == null) {
            return null;
        }
        String[] values = text.split(",");
        if (values == null || values.length == 0) {
            return null;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < values.length; ++i) {
            String v = values[i];
            v = v.trim();
            if (Long.class.equals(this.type)) {
                try {
                    l.add(Long.parseLong(v));
                }
                catch (Exception exception) {}
                continue;
            }
            l.add(v);
        }
        return l;
    }

    List<Object> isReady() {
        if (!this.required) {
            return null;
        }
        return this.getValues();
    }

    void addDocumentListener(DocumentListener listener) {
        if (listener == null) {
            return;
        }
        this.field.getDocument().addDocumentListener(listener);
    }
}

